void finite_difference(Matrix &last, Matrix &current, Matrix &next, Matrix &densities) {

  float c = .5;	// the base wave speed (which will be modified by density)
  float dt = .5;// small step in time
  float dx = 1;	// small step in x
  float dy = 1;	// small step in y

  // actual wave speed is c/sqrrt(density[i][j]); this (value / dt)^2 must be < 1 for convergence

  next = current;

  for(int i = 2; i <= current.get_m()-1; i++) {

    for(int j = 2; j <= current.get_n()-1; j++) {

      next.set(

        2*current.value(i, j) - last.value(i, j) + c*c*dt*dt/densities.value(i, j)

         * (   1/dx/dx*(current.value(i+1, j)-2*current.value(i, j)+current.value(i-1, j)) +
               1/dy/dy*(current.value(i, j+1)-2*current.value(i, j)+current.value(i, j-1))   )

        , i, j);

    }

  }

}
