/***
 * hybridai.cpp
 * 11-06-02
 * Nathan Freeburg
 *
 * Implements the HeuristicAI member functions declared in heuristicai.h.
 */

#include <iostream.h>
#include <math.h>
#include "globals.h"
#include "board.h"
#include "hybridai.h"

HybridAI::HybridAI()
{
	bestMoves = new Move[NUM_PIECES];
	target[0]=BOARD_DIM/2;
	target[1]=BOARD_DIM/2;
	tgtDCity[0]=BOARD_DIM/2;
	tgtDCity[1]=BOARD_DIM/2;
	tgtACity[0]=BOARD_DIM/2;
	tgtACity[1]=BOARD_DIM/2;
	tgtUnit[0]=BOARD_DIM/2;
	tgtUnit[1]=BOARD_DIM/2;
}

HybridAI::HybridAI(char side)
{
	mySide = side;
	bestMoves = new Move[NUM_PIECES];
	target[0]=BOARD_DIM/2;
	target[1]=BOARD_DIM/2;
	tgtDCity[0]=BOARD_DIM/2;
	tgtDCity[1]=BOARD_DIM/2;
	tgtACity[0]=BOARD_DIM/2;
	tgtACity[1]=BOARD_DIM/2;
	tgtUnit[0]=BOARD_DIM/2;
	tgtUnit[1]=BOARD_DIM/2;
}

void HybridAI::setPlayer(char color)
{
	mySide = color;
}


Move* HybridAI::getBestMove(const Board inBoard)
{
	getStrategy(inBoard);

	int alpha = -9999;
	int beta = 9999;
	int value = 0;
	Board scratchBoard(inBoard);

	if(mySide == PLAYER_A)
	{
		for(int i=0; i<NUM_PIECES; i++)
		{
			if(scratchBoard.pieces[2][i]>0)		// There's a piece there.
			{
				value = maxValue(scratchBoard,alpha,beta,MAX_DEPTH,i,bestMoves[i]);
				scratchBoard.makeMove(bestMoves[i].x1,bestMoves[i].y1,bestMoves[i].x2,bestMoves[i].y2);
			}
			else 
			{
				bestMoves[i].x1 = -1;
				bestMoves[i].y1 = -1;
				bestMoves[i].x2 = -1;
				bestMoves[i].y2 = -1;
			}
		}
	}
	else // I'm player B
	{
		int end = 2 * NUM_PIECES - 1;
		for(int i=0; i<NUM_PIECES; i++)
		{
			if(scratchBoard.pieces[2][end-i]>0)		// There's a piece there.
			{
				value = minValue(scratchBoard,alpha,beta,MAX_DEPTH,i,bestMoves[i]);
				scratchBoard.makeMove(bestMoves[i].x1,bestMoves[i].y1,bestMoves[i].x2,bestMoves[i].y2);
			}
			else 
			{
				bestMoves[i].x1 = -1;
				bestMoves[i].y1 = -1;
				bestMoves[i].x2 = -1;
				bestMoves[i].y2 = -1;
			}
		}

	}

	return bestMoves;
}

int HybridAI::calculateValue(const Board inBoard, char player)
{	
	int sumCityDistance = 0;
	int sumEnemyDistance = 0;
	int sumTargetDistance = 0;
	int dist = 0;
	int totalEnemyStr = 0;
	if(player==PLAYER_A)
	{
		for(int i=0; i<NUM_PIECES; i++)
		{
			if(inBoard.pieces[2][i]>0)	// There's a piece there
			{
				sumCityDistance += (BOARD_DIM - inBoard.distToClosestCity(inBoard.pieces[0][i],inBoard.pieces[1][i]));
				sumEnemyDistance += (BOARD_DIM - inBoard.distToClosestEnemy(inBoard.pieces[0][i],inBoard.pieces[1][i]));
				dist += abs((inBoard.pieces[0][i] - target[0]));
				dist += abs((inBoard.pieces[1][i] - target[1]));
				sumTargetDistance += (BOARD_DIM - dist);
				dist = 0;
			}
		}
		totalEnemyStr = inBoard.totalBStrength;
	}
	else
	{
		int end = 2*NUM_PIECES-1;
		for(int i=0; i<NUM_PIECES; i++)
		{
			if(inBoard.pieces[2][end-i]>0)	// There's a piece there
			{
				sumCityDistance -= (BOARD_DIM - inBoard.distToClosestCity(inBoard.pieces[0][end-i],inBoard.pieces[1][end-i]));
				sumEnemyDistance -= (BOARD_DIM - inBoard.distToClosestEnemy(inBoard.pieces[0][end-i],inBoard.pieces[1][end-i]));
				dist += abs((inBoard.pieces[0][end-i] - target[0]));
				dist += abs((inBoard.pieces[1][end-i] - target[1]));
				sumTargetDistance -= (BOARD_DIM - dist);
				dist = 0;
			}
		}
		totalEnemyStr = -1 * inBoard.totalAStrength;
	}
		
	return 20*sumTargetDistance
		+ 10*(inBoard.numACities-inBoard.numBCities)
		+ 8*(inBoard.totalAStrength-inBoard.totalBStrength)
		+ 5*(inBoard.numAPieces-inBoard.numBPieces)
		+ sumCityDistance
		+ sumEnemyDistance
		- totalEnemyStr/2;
}

int HybridAI::maxValue(const Board inBoard, int alphamax, int betamin, int depth, int focus, Move &bestMove)
{
	char winner;
	if(inBoard.gameOver(winner))
	{
		if(winner==0)
			return 0;
		else if(winner==PLAYER_B)
			return 2000 + depth;
		else
			return -2000 - depth;
	}
	if(depth<=0)
	{
		return calculateValue(inBoard,PLAYER_B);
	}

	Board scratchBoard(inBoard);
	Board outBoard(inBoard);
	Move best;
	int bestVal = -9999;
	int x1, y1;

	if(outBoard.pieces[2][focus] > 0)	// Focus piece is there.
	{
		int i;
		for(i = 0; i < focus; i++)
		{
			if(outBoard.pieces[2][i] > 0)
			{
				best = chosen[i][depth];
				outBoard.makeMove(best.x1,best.y1,best.x2,best.y2);
			}
		}
		for(i=focus+1; i<NUM_PIECES; i++)
		{
			x1 = outBoard.pieces[0][i];
			y1 = outBoard.pieces[1][i];
			bestVal = getMinVal(scratchBoard,bestVal,betamin,0,i,best,x1,y1,x1,y1);
			if(scratchBoard.isValid(x1,y1,x1-1,y1,PLAYER_A))
			{
				bestVal = getMinVal(scratchBoard,bestVal,betamin,0,i,best,x1,y1,x1-1,y1);
				scratchBoard = outBoard;
			}
			if(scratchBoard.isValid(x1,y1,x1+1,y1,PLAYER_A))
			{
				bestVal = getMinVal(scratchBoard,bestVal,betamin,0,i,best,x1,y1,x1+1,y1);
				scratchBoard = outBoard;
			}
			if(scratchBoard.isValid(x1,y1,x1,y1-1,PLAYER_A))
			{
				bestVal = getMinVal(scratchBoard,bestVal,betamin,0,i,best,x1,y1,x1,y1-1);
				scratchBoard = outBoard;
			}
			if(scratchBoard.isValid(x1,y1,x1,y1+1,PLAYER_A))
			{
				bestVal = getMinVal(scratchBoard,bestVal,betamin,0,i,best,x1,y1,x1,y1+1);
				scratchBoard = outBoard;
			}
			outBoard.makeMove(best.x1,best.y1,best.x2,best.y2);
		}
		scratchBoard = outBoard;
		x1 = outBoard.pieces[0][focus];
		y1 = outBoard.pieces[1][focus];
		alphamax = getMinVal(scratchBoard,alphamax,betamin,depth,focus,bestMove,x1,y1,x1,y1);
		if(alphamax >= betamin)
			return alphamax;
		if(scratchBoard.isValid(x1,y1,x1-1,y1,PLAYER_A))
		{
			alphamax = getMinVal(scratchBoard,alphamax,betamin,depth,focus,bestMove,x1,y1,x1-1,y1);
			if(alphamax >= betamin)
			{
				return alphamax;
			}
			scratchBoard = outBoard;
		}
		if(scratchBoard.isValid(x1,y1,x1+1,y1,PLAYER_A))
		{
			alphamax = getMinVal(scratchBoard,alphamax,betamin,depth,focus,bestMove,x1,y1,x1+1,y1);
			if(alphamax >= betamin)
			{
				return alphamax;
			}
			scratchBoard = outBoard;
		}
		if(scratchBoard.isValid(x1,y1,x1,y1-1,PLAYER_A))
		{
			alphamax = getMinVal(scratchBoard,alphamax,betamin,depth,focus,bestMove,x1,y1,x1,y1-1);
			if(alphamax >= betamin)
			{
				return alphamax;
			}
			scratchBoard = outBoard;
		}
		if(scratchBoard.isValid(x1,y1,x1,y1+1,PLAYER_A))
		{
			alphamax = getMinVal(scratchBoard,alphamax,betamin,depth,focus,bestMove,x1,y1,x1,y1+1);
			if(alphamax >= betamin)
			{
				return alphamax;
			}
			scratchBoard = outBoard;
		}
		chosen[focus][depth] = bestMove;
		return alphamax;
	}
	else
	{
		return minValue(scratchBoard,alphamax,betamin,depth-1,focus,best);
	}
}

int HybridAI::minValue(const Board inBoard, int alphamax, int betamin, int depth, int focus, Move &bestMove)
{
	char winner;
	if(inBoard.gameOver(winner))
	{
		if(winner==0)
			return 0;
		else if(winner==PLAYER_A)
			return 2000 + depth;
		else
			return -2000 - depth;
	}
	if(depth<=0)
	{
		return calculateValue(inBoard,PLAYER_A);
	}

	int end = 2 * NUM_PIECES - 1;
	Board scratchBoard(inBoard);
	Board outBoard(inBoard);
	Move best;
	int bestVal = 9999;
	int x1, y1;

	if(outBoard.pieces[2][end-focus] > 0)	// Focus piece is there.
	{
		int i;
		for(i = 0; i < focus; i++)
		{
			if(outBoard.pieces[2][end-i] > 0)
			{
				best = chosen[i][depth];
				outBoard.makeMove(best.x1,best.y1,best.x2,best.y2);
			}
		}
		for(i = focus+1; i<NUM_PIECES; i++)
		{
			x1 = outBoard.pieces[0][end-i];
			y1 = outBoard.pieces[1][end-i];
			bestVal = getMaxVal(scratchBoard,alphamax,bestVal,0,i,best,x1,y1,x1,y1);
			if(scratchBoard.isValid(x1,y1,x1-1,y1,PLAYER_B))
			{
				bestVal = getMaxVal(scratchBoard,alphamax,bestVal,0,i,best,x1,y1,x1-1,y1);
				scratchBoard = outBoard;
			}
			if(scratchBoard.isValid(x1,y1,x1+1,y1,PLAYER_B))
			{
				bestVal = getMaxVal(scratchBoard,alphamax,bestVal,0,i,best,x1,y1,x1+1,y1);
				scratchBoard = outBoard;
			}
			if(scratchBoard.isValid(x1,y1,x1,y1-1,PLAYER_B))
			{
				bestVal = getMaxVal(scratchBoard,alphamax,bestVal,0,i,best,x1,y1,x1,y1-1);
				scratchBoard = outBoard;
			}
			if(scratchBoard.isValid(x1,y1,x1,y1+1,PLAYER_B))
			{
				bestVal = getMaxVal(scratchBoard,alphamax,bestVal,0,i,best,x1,y1,x1,y1+1);
				scratchBoard = outBoard;
			}
			outBoard.makeMove(best.x1,best.y1,best.x2,best.y2);
		}
		scratchBoard = outBoard;
		x1 = outBoard.pieces[0][end-focus];
		y1 = outBoard.pieces[1][end-focus];
		betamin = getMaxVal(scratchBoard,alphamax,betamin,depth,focus,bestMove,x1,y1,x1,y1);
		if(alphamax >= betamin)
			return betamin;
		if(scratchBoard.isValid(x1,y1,x1-1,y1,PLAYER_B))
		{
			betamin = getMaxVal(scratchBoard,alphamax,betamin,depth,focus,bestMove,x1,y1,x1-1,y1);
			if(alphamax >= betamin)
			{
				return betamin;
			}
			scratchBoard = outBoard;
		}
		if(scratchBoard.isValid(x1,y1,x1+1,y1,PLAYER_B))
		{
			betamin = getMaxVal(scratchBoard,alphamax,betamin,depth,focus,bestMove,x1,y1,x1+1,y1);
			if(alphamax >= betamin)
			{
				return betamin;
			}
			scratchBoard = outBoard;
		}
		if(scratchBoard.isValid(x1,y1,x1,y1-1,PLAYER_B))
		{
			betamin = getMaxVal(scratchBoard,alphamax,betamin,depth,focus,bestMove,x1,y1,x1,y1-1);
			if(alphamax >= betamin)
			{
				return betamin;
			}
			scratchBoard = outBoard;
		}
		if(scratchBoard.isValid(x1,y1,x1,y1+1,PLAYER_B))
		{
			betamin = getMaxVal(scratchBoard,alphamax,betamin,depth,focus,bestMove,x1,y1,x1,y1+1);
			if(alphamax >= betamin)
			{
				return betamin;
			}
			scratchBoard = outBoard;
		}
		chosen[focus][depth] = bestMove;
		return betamin;
	}
	else
	{
		return minValue(scratchBoard,alphamax,betamin,depth-1,focus,best);
	}
}

int HybridAI::getMinVal(Board in, int alpha, int beta, int d, int f,
						   Move &best, int x1, int y1, int x2, int y2)
{
	in.makeMove(x1,y1,x2,y2);
	Move dummy;
	int value = minValue(in,alpha,beta,d-1,f,dummy);
	if(value > alpha)
	{
		best.x1 = x1;
		best.y1 = y1;
		best.x2 = x2;
		best.y2 = y2;
		alpha = value;
	}

	return alpha;
}

int HybridAI::getMaxVal(Board in, int alpha, int beta, int d, int f,
						   Move &best, int x1, int y1, int x2, int y2)
{
	in.makeMove(x1,y1,x2,y2);
	Move dummy;
	int value = maxValue(in,alpha,beta,d-1,f,dummy);
	if(value < beta)
	{
		best.x1 = x1;
		best.y1 = y1;
		best.x2 = x2;
		best.y2 = y2;
		beta = value;
	}

	return beta;
}

void HybridAI::getStrategy(const Board inBoard)
{
	cout << "getStrategy" << endl;

	int lclEnemyStr = 0, lclFrndlyStr = 0;
	int dfndCity = 0;
	int atkCity = 0;
	int atkUnit = 0;
	int sum = 0;

	for(int n=0; n<inBoard.numCities; n++)
	{
		int x = inBoard.cities[0][n];
		int y = inBoard.cities[1][n];
		for(int i=-3; i<4; i++)
		{
			if(x+i>=0 && x+i<BOARD_DIM)
				for(int j=-3; j<4; j++)
				{
					if(y+j>=0 && y+j<BOARD_DIM)
					{
						if(inBoard.theBoard[y+j][x+i] > 0)
						{
							if(mySide==PLAYER_A) lclFrndlyStr++;
							else lclEnemyStr++;
						}
						else if(inBoard.theBoard[y+j][x+i] < 0)
						{
							if(mySide==PLAYER_B) lclFrndlyStr++;
							else lclEnemyStr++;
						}
					}
				}
		}
		if(inBoard.cityOwner[n]==mySide)
		{
			sum = lclEnemyStr-lclFrndlyStr;
			if(sum>dfndCity)
			{
				tgtDCity[0]=x;
				tgtDCity[1]=y;
				dfndCity=sum;
			}
		}
		else
		{
			sum = lclFrndlyStr-lclEnemyStr;
			if(sum>atkCity)
			{
				tgtACity[0]=x;
				tgtACity[1]=y;
				atkCity=sum;
			}
			lclEnemyStr=0;
			lclFrndlyStr=0;
		}
	}

	for(n=0; n<2*NUM_PIECES; n++)
	{
		if(inBoard.pieces[2][n]>0)
		{
			int x = inBoard.pieces[0][n];
			int y = inBoard.pieces[1][n];
			for(int i=-3; i<4; i++)
			{
				if(x+i>=0 && x+i<BOARD_DIM)
					for(int j=-3; j<4; j++)
					{
						if(y+j>=0 && y+j<BOARD_DIM)
						{
							if(inBoard.theBoard[y+j][x+i] > 0)
							{
								if(mySide==PLAYER_A) lclFrndlyStr++;
								else lclEnemyStr++;
							}
							else if(inBoard.theBoard[y+j][x+i] < 0)
							{
								if(mySide==PLAYER_B) lclFrndlyStr++;
								else lclEnemyStr++;
							}
						}
					}
			}
			sum=lclFrndlyStr-lclEnemyStr;
			if(sum>atkUnit)
			{
				if(n<NUM_PIECES && mySide==PLAYER_B)
				{
					tgtUnit[0]=x;
					tgtUnit[1]=y;
					atkUnit=sum;
				}
				else if(n>=NUM_PIECES && mySide==PLAYER_A)
				{
					tgtUnit[0]=x;
					tgtUnit[1]=y;
					atkUnit=sum;
				}
			}
			lclFrndlyStr=0;
			lclEnemyStr=0;
		}
	}
	
	if(atkCity>dfndCity && atkCity>atkUnit)
	{
		target[0]=tgtACity[0];
		target[1]=tgtACity[1];
	}
	else if(dfndCity>atkCity && dfndCity>atkUnit)
	{
		target[0]=tgtDCity[0];
		target[1]=tgtDCity[1];
	}
	else
	{
		target[0]=tgtUnit[0];
		target[1]=tgtUnit[1];
	}
	cout << "target is " << target[0] << ' ' << target[1] << endl;
}