/***
 * heuristicai.cpp
 * 11-06-02
 * Nathan Freeburg
 *
 * Implements the HeuristicAI member functions declared in heuristicai.h.
 */

#include <math.h>
#include <iostream.h>
#include "globals.h"
#include "board.h"
#include "heuristicai.h"

HeuristicAI::HeuristicAI()
{
	bestMoves = new Move[NUM_PIECES];
}

HeuristicAI::HeuristicAI(char side)
{
	mySide = side;
	bestMoves = new Move[NUM_PIECES];
}

void HeuristicAI::setPlayer(char color)
{
	mySide = color;
}

Move* HeuristicAI::getBestMove(const Board inBoard)
{
	int alpha = -9999;
	int beta = 9999;
	int value = 0;
	Board scratchBoard(inBoard);

	if(mySide == PLAYER_A)
	{
		for(int i=0; i<NUM_PIECES; i++)
		{
			if(scratchBoard.pieces[2][i]>0)		// There's a piece there.
			{
				value = maxValue(scratchBoard,alpha,beta,MAX_DEPTH,i,bestMoves[i]);
			}
			else 
			{
				bestMoves[i].x1 = -1;
				bestMoves[i].y1 = -1;
				bestMoves[i].x2 = -1;
				bestMoves[i].y2 = -1;
			}
		}
	}
	else // I'm player B
	{
		int end = 2 * NUM_PIECES - 1;
		for(int i=0; i<NUM_PIECES; i++)
		{
			if(scratchBoard.pieces[2][end-i]>0)		// There's a piece there.
			{
				value = minValue(scratchBoard,alpha,beta,MAX_DEPTH,i,bestMoves[i]);
			}
			else 
			{
				bestMoves[i].x1 = -1;
				bestMoves[i].y1 = -1;
				bestMoves[i].x2 = -1;
				bestMoves[i].y2 = -1;
			}
		}

	}

	return bestMoves;
}

int HeuristicAI::calculateValue(const Board inBoard, char player)
{
	int sumCityDistance = 0;
	int sumEnemyDistance = 0;
	int totalEnemyStr = 0;
	if(player==PLAYER_A)
	{
		for(int i=0; i<NUM_PIECES; i++)
		{
			if(inBoard.pieces[2][i]>0)	// There's a piece there
			{
				sumCityDistance += (BOARD_DIM - inBoard.distToClosestCity(inBoard.pieces[0][i],inBoard.pieces[1][i]));
				sumEnemyDistance += (BOARD_DIM - inBoard.distToClosestEnemy(inBoard.pieces[0][i],inBoard.pieces[1][i]));
			}
		}
		totalEnemyStr = inBoard.totalBStrength;
	}
	else
	{
		int end = 2*NUM_PIECES-1;
		for(int i=0; i<NUM_PIECES; i++)
		{
			if(inBoard.pieces[2][end-i]>0)	// There's a piece there
			{
				sumCityDistance -= (BOARD_DIM - inBoard.distToClosestCity(inBoard.pieces[0][end-i],inBoard.pieces[1][end-i]));
				sumEnemyDistance -= (BOARD_DIM - inBoard.distToClosestEnemy(inBoard.pieces[0][end-i],inBoard.pieces[1][end-i]));
			}
		}
		totalEnemyStr = -1 * inBoard.totalAStrength;
	}
		
	return 20*(inBoard.numACities-inBoard.numBCities)
		+ 10*(inBoard.totalAStrength-inBoard.totalBStrength)
		+ 10*(inBoard.numAPieces-inBoard.numBPieces)
		+ 5*sumCityDistance
		+ sumEnemyDistance
		- totalEnemyStr;
}

int HeuristicAI::maxValue(const Board inBoard, int alphamax, int betamin, int depth, int focus, Move &bestMove)
{
	char winner;
	if(inBoard.gameOver(winner))
	{
		if(winner==0)
			return 0;
		else if(winner==PLAYER_A)
			return 2000 + depth;
		else
			return -2000 - depth;
	}
	if(depth<=0)
	{
		return calculateValue(inBoard,PLAYER_B);
	}

	Board scratchBoard(inBoard);
	Board outBoard(inBoard);
	Move best;
	int bestVal = -9999;
	int x1, y1;

	if(outBoard.pieces[2][focus] > 0)	// Focus piece is there.
	{
		int i;
		for(i=0; i<focus; i++)
		{
			if(outBoard.pieces[2][i]>0)
			{
				best = chosen[i][depth];
				outBoard.makeMove(best.x1,best.y1,best.x2,best.y2);
			}
		}
		for( i=focus+1; i<NUM_PIECES; i++)
		{
			x1 = outBoard.pieces[0][i];
			y1 = outBoard.pieces[1][i];
			bestVal = getMinVal(scratchBoard,bestVal,betamin,0,i,best,x1,y1,x1,y1);
			if(scratchBoard.isValid(x1,y1,x1-1,y1,PLAYER_A))
			{
				bestVal = getMinVal(scratchBoard,bestVal,betamin,0,i,best,x1,y1,x1-1,y1);
				scratchBoard = outBoard;
			}
			if(scratchBoard.isValid(x1,y1,x1+1,y1,PLAYER_A))
			{
				bestVal = getMinVal(scratchBoard,bestVal,betamin,0,i,best,x1,y1,x1+1,y1);
				scratchBoard = outBoard;
			}
			if(scratchBoard.isValid(x1,y1,x1,y1-1,PLAYER_A))
			{
				bestVal = getMinVal(scratchBoard,bestVal,betamin,0,i,best,x1,y1,x1,y1-1);
				scratchBoard = outBoard;
			}
			if(scratchBoard.isValid(x1,y1,x1,y1+1,PLAYER_A))
			{
				bestVal = getMinVal(scratchBoard,bestVal,betamin,0,i,best,x1,y1,x1,y1+1);
				scratchBoard = outBoard;
			}
			outBoard.makeMove(best.x1,best.y1,best.x2,best.y2);
		}
		scratchBoard = outBoard;
		x1 = outBoard.pieces[0][focus];
		y1 = outBoard.pieces[1][focus];
		if(scratchBoard.isValid(x1,y1,x1-1,y1,PLAYER_A))
		{
			alphamax = getMinVal(scratchBoard,alphamax,betamin,depth,focus,bestMove,x1,y1,x1-1,y1);
			if(alphamax >= betamin)
			{
				return alphamax;
			}
			scratchBoard = outBoard;
		}
		if(scratchBoard.isValid(x1,y1,x1+1,y1,PLAYER_A))
		{
			alphamax = getMinVal(scratchBoard,alphamax,betamin,depth,focus,bestMove,x1,y1,x1+1,y1);
			if(alphamax >= betamin)
			{
				return alphamax;
			}
			scratchBoard = outBoard;
		}
		if(scratchBoard.isValid(x1,y1,x1,y1-1,PLAYER_A))
		{
			alphamax = getMinVal(scratchBoard,alphamax,betamin,depth,focus,bestMove,x1,y1,x1,y1-1);
			if(alphamax >= betamin)
			{
				return alphamax;
			}
			scratchBoard = outBoard;
		}
		if(scratchBoard.isValid(x1,y1,x1,y1+1,PLAYER_A))
		{
			alphamax = getMinVal(scratchBoard,alphamax,betamin,depth,focus,bestMove,x1,y1,x1,y1+1);
			if(alphamax >= betamin)
			{
				return alphamax;
			}
			scratchBoard = outBoard;
		}
		alphamax = getMinVal(scratchBoard,alphamax,betamin,depth,focus,bestMove,x1,y1,x1,y1);
		chosen[focus][depth] = bestMove;
		return alphamax;
	}
	else
	{
		return minValue(scratchBoard,alphamax,betamin,depth-1,focus,best);
	}
}

int HeuristicAI::minValue(const Board inBoard, int alphamax, int betamin, int depth, int focus, Move &bestMove)
{
	char winner;
	if(inBoard.gameOver(winner))
	{
		if(winner==0)
			return 0;
		else if(winner==PLAYER_A)
			return 2000 + depth;
		else
			return -2000 - depth;
	}
	if(depth<=0)
	{
		return calculateValue(inBoard,PLAYER_A);
	}

	int end = 2 * NUM_PIECES - 1;
	Board scratchBoard(inBoard);
	Board outBoard(inBoard);
	Move best;
	int bestVal = 9999;
	int x1, y1;

	if(outBoard.pieces[2][end-focus] > 0)	// Focus piece is there.
	{
		int i;
		for(i=0; i<focus; i++)
		{
			if(outBoard.pieces[2][end-i]>0)
			{
				best = chosen[i][depth];
				outBoard.makeMove(best.x1,best.y1,best.x2,best.y2);
			}
		}
		for(i=focus+1; i<NUM_PIECES; i++)
		{
			x1 = outBoard.pieces[0][end-i];
			y1 = outBoard.pieces[1][end-i];
			bestVal = getMaxVal(scratchBoard,alphamax,bestVal,0,i,best,x1,y1,x1,y1);
			if(scratchBoard.isValid(x1,y1,x1-1,y1,PLAYER_B))
			{
				bestVal = getMaxVal(scratchBoard,alphamax,bestVal,0,i,best,x1,y1,x1-1,y1);
				scratchBoard = outBoard;
			}
			if(scratchBoard.isValid(x1,y1,x1+1,y1,PLAYER_B))
			{
				bestVal = getMaxVal(scratchBoard,alphamax,bestVal,0,i,best,x1,y1,x1+1,y1);
				scratchBoard = outBoard;
			}
			if(scratchBoard.isValid(x1,y1,x1,y1-1,PLAYER_B))
			{
				bestVal = getMaxVal(scratchBoard,alphamax,bestVal,0,i,best,x1,y1,x1,y1-1);
				scratchBoard = outBoard;
			}
			if(scratchBoard.isValid(x1,y1,x1,y1+1,PLAYER_B))
			{
				bestVal = getMaxVal(scratchBoard,alphamax,bestVal,0,i,best,x1,y1,x1,y1+1);
				scratchBoard = outBoard;
			}
			outBoard.makeMove(best.x1,best.y1,best.x2,best.y2);
		}
		scratchBoard = outBoard;
		x1 = outBoard.pieces[0][end-focus];
		y1 = outBoard.pieces[1][end-focus];
		if(scratchBoard.isValid(x1,y1,x1-1,y1,PLAYER_B))
		{
			betamin = getMaxVal(scratchBoard,alphamax,betamin,depth,focus,bestMove,x1,y1,x1-1,y1);
			if(alphamax >= betamin)
			{
				return betamin;
			}
			scratchBoard = outBoard;
		}
		if(scratchBoard.isValid(x1,y1,x1+1,y1,PLAYER_B))
		{
			betamin = getMaxVal(scratchBoard,alphamax,betamin,depth,focus,bestMove,x1,y1,x1+1,y1);
			if(alphamax >= betamin)
			{
				return betamin;
			}
			scratchBoard = outBoard;
		}
		if(scratchBoard.isValid(x1,y1,x1,y1-1,PLAYER_B))
		{
			betamin = getMaxVal(scratchBoard,alphamax,betamin,depth,focus,bestMove,x1,y1,x1,y1-1);
			if(alphamax >= betamin)
			{
				return betamin;
			}
			scratchBoard = outBoard;
		}
		if(scratchBoard.isValid(x1,y1,x1,y1+1,PLAYER_B))
		{
			betamin = getMaxVal(scratchBoard,alphamax,betamin,depth,focus,bestMove,x1,y1,x1,y1+1);
			if(alphamax >= betamin)
			{
				return betamin;
			}
			scratchBoard = outBoard;
		}
		betamin = getMaxVal(scratchBoard,alphamax,betamin,depth,focus,bestMove,x1,y1,x1,y1);
		chosen[focus][depth] = bestMove;
		return betamin;
	}
	else
	{
		return minValue(scratchBoard,alphamax,betamin,depth-1,focus,best);
	}
}

int HeuristicAI::getMinVal(Board in, int alpha, int beta, int d, int f,
						   Move &best, int x1, int y1, int x2, int y2)
{
	in.makeMove(x1,y1,x2,y2);
	Move dummy;
	int value = minValue(in,alpha,beta,d-1,f,dummy);
	if(value > alpha)
	{
		best.x1 = x1;
		best.y1 = y1;
		best.x2 = x2;
		best.y2 = y2;
		alpha = value;
	}

	return alpha;
}

int HeuristicAI::getMaxVal(Board in, int alpha, int beta, int d, int f,
						   Move &best, int x1, int y1, int x2, int y2)
{
	in.makeMove(x1,y1,x2,y2);
	Move dummy;
	int value = maxValue(in,alpha,beta,d-1,f,dummy);
	if(value < beta)
	{
		best.x1 = x1;
		best.y1 = y1;
		best.x2 = x2;
		best.y2 = y2;
		beta = value;
	}

	return beta;
}