/***
 * board.h
 * 10-14-02
 * Nathan Freeburg
 *
 * Declarations for the board class.
 */
#ifndef _BOARD_H
#define _BOARD_H

class Board{
	friend class HeuristicAI;
	friend class HybridAI;
public:
	Board();
	Board(const Board &);
	const Board &operator=(const Board &);

	void makeMove(int x1, int y1, int x2, int y2);
	void showBoard(ostream&);
	void setPiece(char player, int strength, int x, int y);
	void setCity(int x, int y);
	bool gameOver(char &) const;
	int pieceAt(int x, int y) const;
	bool cityAt(int x, int y) const;
	int distToClosestCity(int x, int y) const;
	int distToClosestEnemy(int x, int y) const;
	void removeUnit(int x, int y);
	bool isValid(int x1, int y1, int x2, int y2, char whoseturn);

private:
	int theBoard[BOARD_DIM][BOARD_DIM];
	bool isCity[BOARD_DIM][BOARD_DIM];
	int pieces[3][NUM_PIECES * 2];
	int cities[2][NUM_CITIES];
	char cityOwner[NUM_CITIES];
	int numAPieces, numBPieces;
	int numACities, numBCities;
	int totalAStrength, totalBStrength;
	int numCities;
};

#endif