/***
 * board.cpp
 * 10-14-02
 * Nathan Freeburg
 *
 * Implements the board member functions declared in board.h
 */

#include <iostream.h>
#include <fstream.h>
#include <memory.h>
#include <math.h>
#include "globals.h"
#include "board.h"

Board::Board()
{
	for(int i = 0; i < BOARD_DIM; i++){
		for(int j = 0; j < BOARD_DIM; j++){
			theBoard[i][j] = 0;
			isCity[i][j] = false;
		}
	}
	numAPieces = 0;
	numBPieces = 0;
	numACities = 0;
	numBCities = 0;
	totalAStrength = 0;
	totalBStrength = 0;
	numCities = 0;
}

Board::Board(const Board &inBoard)
{
	memcpy(theBoard,inBoard.theBoard,SIZE_OF_BOARD);
	memcpy(isCity,inBoard.isCity,SIZE_OF_CITIES);
	memcpy(pieces,inBoard.pieces,SIZE_OF_PIECES);
	memcpy(cities,inBoard.cities,2*NUM_CITIES*sizeof(int));
	memcpy(cityOwner,inBoard.cityOwner,CITY_OWNERS);
	numAPieces = inBoard.numAPieces;
	numBPieces = inBoard.numBPieces;
	numACities = inBoard.numACities;
	numBCities = inBoard.numBCities;
	totalAStrength = inBoard.totalAStrength;
	totalBStrength = inBoard.totalBStrength;
	numCities = inBoard.numCities;
}

const Board &Board::operator=(const Board &inBoard)
{
	memcpy(theBoard,inBoard.theBoard,SIZE_OF_BOARD);
	memcpy(isCity,inBoard.isCity,SIZE_OF_CITIES);
	memcpy(pieces,inBoard.pieces,SIZE_OF_PIECES);
	memcpy(cities,inBoard.cities,2*NUM_CITIES*sizeof(int));
	memcpy(cityOwner,inBoard.cityOwner,CITY_OWNERS);
	numAPieces = inBoard.numAPieces;
	numBPieces = inBoard.numBPieces;
	numACities = inBoard.numACities;
	numBCities = inBoard.numBCities;
	totalAStrength = inBoard.totalAStrength;
	totalBStrength = inBoard.totalBStrength;
	numCities = inBoard.numCities;

	return *this;
}

void Board::makeMove(int x1, int y1, int x2, int y2)
{
	if((x1==x2)&&(y1==y2))
		return;
	int piece = theBoard[y1][x1];
	if(theBoard[y2][x2]==0)
	{
		if(piece > 0)
		{
			pieces[0][piece-1] = x2;
			pieces[1][piece-1] = y2;
			if(isCity[y2][x2])
			{
				for(int i=0;i<NUM_CITIES;i++)
				{
					if(cities[0][i]==x2 && cities[1][i]==y2)
					{
						if(cityOwner[i]==PLAYER_B)
						{
							for(int j=NUM_PIECES;j<END;j++)
							{
								if(pieces[2][j]>0)
								{
									pieces[2][j]--;
									totalBStrength--;
									removeUnit(pieces[0][j],pieces[1][j]);
								}
							}
							numBCities--;
						}
						if(cityOwner[i]!=PLAYER_A)
						{
							cityOwner[i]=PLAYER_A;
							for(int j=0;j<NUM_PIECES;j++)
							{
								if(pieces[2][j]>0)
								{
									pieces[2][j]++;
									totalAStrength++;
								}
							}
							numACities++;
						}
					}
				}
			}
		}
		else if(piece < 0)
		{
			pieces[0][END + piece] = x2;
			pieces[1][END + piece] = y2;
			if(isCity[y2][x2])
			{
				for(int i=0;i<NUM_CITIES;i++)
				{
					if(cities[0][i]==x2 && cities[1][i]==y2)
					{
						if(cityOwner[i]==PLAYER_A)
						{
							for(int j=0;j<NUM_PIECES;j++)
							{
								if(pieces[2][j]>0)
								{
									pieces[2][j]--;
									totalAStrength--;
									removeUnit(pieces[0][j],pieces[1][j]);
								}
							}
							numACities--;
						}
						if(cityOwner[i]!=PLAYER_B)
						{
							cityOwner[i]=PLAYER_B;
							for(int j=NUM_PIECES;j<END;j++)
							{
								if(pieces[2][j]>0)
								{
									pieces[2][j]++;
									totalBStrength++;
								}
							}
							numBCities++;
						}
					}
				}
			}
		}
		theBoard[y2][x2] = theBoard[y1][x1];
		theBoard[y1][x1] = 0;
	}
	else
	{
		int otherPiece = theBoard[y2][x2];
		if((piece>0)&&(otherPiece<0))	// A attacks B
		{
			/* if A's piece is stronger than B's */
			if(pieces[2][piece-1]>pieces[2][END+otherPiece])
			{
				if(pieces[2][END+otherPiece]>=2)
					totalBStrength -= 2;
				else
					totalBStrength--;
				pieces[2][END+otherPiece] -= 2;
				removeUnit(pieces[0][END+otherPiece],pieces[1][END+otherPiece]);
			}
			else	/* B's piece is at least as strong as A's */
			{
				pieces[2][END+otherPiece]--;
				totalBStrength--;
				removeUnit(pieces[0][END+otherPiece],pieces[1][END+otherPiece]);
			}
			pieces[2][piece-1]--;
			totalAStrength--;
			removeUnit(pieces[0][piece-1],pieces[1][piece-1]);

		}
		else if((piece<0)&&(otherPiece>0))	// B attacks A
		{
			/* if B's piece is stronger than A's */
			if(pieces[2][END+piece]>pieces[2][otherPiece-1])
			{
				if(pieces[2][otherPiece-1] >= 2)
					totalAStrength -= 2;
				else
					totalAStrength--;
				pieces[2][otherPiece-1] -= 2;
				removeUnit(pieces[0][otherPiece-1],pieces[1][otherPiece-1]);
			}
			else	/* A's piece is at least as strong as B's */
			{
				pieces[2][otherPiece-1]--;
				totalAStrength--;
				removeUnit(pieces[0][otherPiece-1],pieces[1][otherPiece-1]);
			}
			pieces[2][END+piece]--;
			totalBStrength--;
			removeUnit(pieces[0][END+piece],pieces[1][END+piece]);
		}

		else if((piece>0)&&(otherPiece>0))
		{
			//cout << "\nA can't attack A." << endl;
		}
		else if((piece<0)&&(otherPiece<0))
		{
			//cout << "\nB can't attack B." << endl;
		}
		else
		{
			//cout << "\nMove not made.  How did I get here?" << endl;
		}
	}
}

void Board::showBoard(ostream& output)
{
	int i,j;
	char thisSpace;
	cout << "   ";
	output << "   ";
	for(i = 0; i < BOARD_DIM; i++)
	{
		if(i<10) cout << ' ';
		cout << i << ' ';
		if(i<10) output << ' ';
		output << i << ' ';
	}
	cout << endl;
	output << endl;

	for(i = 0; i < BOARD_DIM; i++){
		if(i<10) cout << ' ';
		cout << i << ' ';
		if(i<10) output << ' ';
		output << i << ' ';
		for(j = 0; j < BOARD_DIM; j++){
			thisSpace = theBoard[i][j];
			if(thisSpace == 0) {
				cout << (isCity[i][j] ? "** ":".. ");
				output << (isCity[i][j] ? "** ":".. ");
			}
			else if (thisSpace < 0) {
				cout << (isCity[i][j] ? 'B':'b') << pieces[2][END+thisSpace]
					<< ' ';
				output << (isCity[i][j] ? 'B':'b') << pieces[2][END+thisSpace]
					<< ' ';
			}
			else {
				cout << (isCity[i][j] ? 'A':'a') << pieces[2][thisSpace-1] << ' ';
				output << (isCity[i][j] ? 'A':'a') << pieces[2][thisSpace-1] << ' ';
			}
		}
		cout << endl;
		output << endl;
	}
}

void Board::setPiece(char player, int strength, int x, int y)
{
	if(player == PLAYER_A)
	{
		theBoard[y][x] = numAPieces+1;
		pieces[0][numAPieces] = x;
		pieces[1][numAPieces] = y;
		pieces[2][numAPieces] = strength;
		totalAStrength += strength;
		numAPieces++;
		if(isCity[y][x])
			numACities++;
	}
	else
	{
		numBPieces++;
		theBoard[y][x] = -1 * numBPieces;
		pieces[0][END - numBPieces] = x;
		pieces[1][END - numBPieces] = y;
		pieces[2][END - numBPieces] = strength;
		totalBStrength += strength;
		if(isCity[y][x])
			numBCities++;
	}
}

void Board::setCity(int x, int y)
{
	isCity[y][x] = true;
	cities[0][numCities] = x;
	cities[1][numCities] = y;
	numCities++;
}

bool Board::gameOver(char &winner) const
{
	if((numAPieces == 0)&&(numBPieces == 0))
	{
		winner = 0;
		return true;
	}
	if((numBPieces == 0)||(numACities == numCities))
	{
		winner = 'a';
		return true;
	}
	else if((numAPieces == 0)||(numBCities == numCities))
	{
		winner = 'b';
		return true;
	}
	else return false;
}

int Board::pieceAt(int x, int y) const
{
	return theBoard[y][x];
}

bool Board::cityAt(int x, int y) const
{
	return isCity[y][x];
}

int Board::distToClosestCity(int x, int y) const
{
	int min = 2*BOARD_DIM;
	int tmp = 0;
	int a = 0;
	int b = 0;
	for(int i=0; i<NUM_CITIES; i++)
	{
		if(isCity[cities[1][i]][cities[0][i]])
		{
			a = abs(x-cities[0][i]);
			b = abs(y-cities[1][i]);
			tmp = a + b;
			if(tmp<min) min = tmp;
		}
	}
	return min;
}

int Board::distToClosestEnemy(int x, int y) const
{
	int min = 2*BOARD_DIM;
	int tmp = 0;
	int a = 0;
	int b = 0;
	if(theBoard[y][x] > 0)
	{
		int end = END-1;
		for(int i=0; i<NUM_PIECES; i++)
		{
			if(pieces[2][end-i] > 0)
			{
				a = abs(x-pieces[0][end-i]);
				b = abs(y-pieces[1][end-i]);
				tmp = a + b;
				if(tmp<min) min = tmp;
			}
		}
	}
	else if(theBoard[y][x] < 0)
	{
		for(int i=0; i<NUM_PIECES; i++)
		{
			if(pieces[2][i] > 0)
			{
				a = abs(x-pieces[0][i]);
				b = abs(y-pieces[1][i]);
				tmp = a + b;
				if(tmp<min) min = tmp;
			}
		}
	}
	return min;
}

void Board::removeUnit(int x, int y)
{
	if( (x<0) || (x>=BOARD_DIM) || (y<0) || (y>=BOARD_DIM) )
		return;
	int piece = theBoard[y][x];
	if(piece > 0)
	{
		if(pieces[2][piece-1] <= 0)
		{
			theBoard[y][x] = 0;
			pieces[0][piece-1] = 0;
			pieces[0][piece-1] = 0;
			numAPieces--;
		}
	}
	else if(piece < 0)
	{
		if(pieces[2][END+piece] <= 0)
		{
			theBoard[y][x] = 0;
			pieces[0][END+piece] = 0;
			pieces[0][END+piece] = 0;
			numBPieces--;
		}
	}
}

bool Board::isValid(int x1, int y1, int x2, int y2, char whoseturn)
{
	if( (x1<0) || (x1>=BOARD_DIM) || (y1<0) || (y1>=BOARD_DIM)
		|| (x2<0) || (x2>=BOARD_DIM) || (y2<0) || (y2>=BOARD_DIM))
		return false;
	if((theBoard[y1][x1]>=0) && (whoseturn==PLAYER_B))
		return false;
	if((theBoard[y1][x1]<=0) && (whoseturn==PLAYER_A))
		return false;
	if((theBoard[y2][x2]>0) && (whoseturn==PLAYER_A))
		return false;
	if((theBoard[y2][x2]<0) && (whoseturn==PLAYER_B))
		return false;

	return (((x1-x2==0)&&(y1-y2==1))
		||((x1-x2==0)&&(y1-y2==-1))
		||((x1-x2==1)&&(y1-y2==0))
		||((x1-x2==-1)&&(y1-y2==0))
		||((x1-x2==0)&&(y1-y2==0)));
}