package fortytwo.testserver;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */
import java.util.Vector;
import fortytwo.network.*;

public class Table {
  // static values for the locations of the table
  public static int NORTH = 0;
  public static int EAST = 1;
  public static int SOUTH = 2;
  public static int WEST = 3;

  // table number used for identification
  private int tableNumber;

  // An array of players at the table
  private Player[] players = new Player[4];

  // A Vector of people chatting at the Table
  private Vector chatMembers;

  // The DominoSet used for the game play
  private DominoSet bones;

  // The rules for the game
  private Rules rules;

  // Whose turn it is
  private int whoseTurn;

  // Who is the dealer
  private int dealer;

  // High bidder
  private int highBidder;

  // Score
  private int NSscore;
  private int EWscore;

  // Marks
  private int NSmarks;
  private int EWmarks;


  // MessageListener for sending messages to the main text area
  private MessageListener messageListener;

  // LobbyListener for sending messages
  private LobbyListener lobbyListener;

  public Table(int tempNumber ) {
    tableNumber = tempNumber;
  }

  public Table(int tempNumber, Player player, Rules tempRules,
               MessageListener tempMessageListener,
               LobbyListener tempLobbyListener ) {
    tableNumber = tempNumber;
    rules = tempRules;
    messageListener = tempMessageListener;
    lobbyListener = tempLobbyListener;
    synchronized( player ) {
      players[0] = player;
      player.joinTable( this );
    }
    bones = new DominoSet();
  }

  // equals method used to see if this table is equal to the table in the arguements
  public boolean equals( Table table ) {
    return (table.getTableNumber() == tableNumber);
  }

  // returns the table number
  public int getTableNumber() {
    return tableNumber;
  }

  // returns an ArrayList of players
  public Vector getPlayerNames() {
    Vector playerNames = new Vector();
    for( int i = 0; i < 4; i ++ ) {
      if ( players[i] != null ) {
        playerNames.add( players[i].getUsername() );
      }
    }
    return playerNames;
  }

  public Rules getRules() {
    return rules;
  }

  // addPlayer( Player, int ) adds a player to the specified location in the array
  // of players. Locations are as follows:
  // 0 = NORTH;
  // 1 = EAST;
  // 2 = SOUTH;
  // 3 = WEST;
  // It returns true if added, and false otherwise

  public void addPlayer( Player tempPlayer ) {
    synchronized( players ) {
      for (int i = 0; i < 4; i++) {
        if (players[i] == null) {
          players[i] = tempPlayer;
          tempPlayer.joinTable(this);
          break;
        }
      }
      if (isFull()) {
        // initialize all the components for the game
        dealer = (int) Math.random() % 4;
        whoseTurn = (dealer + 1) % 4;
        EWscore = 0;
        NSscore = 0;
        EWmarks = 0;
        NSmarks = 0;
        deal();
        for ( int i = 0; i < 4; i ++ ) {
          players[i].loadTable( );

        }
      }
    }
  }

  public boolean addPlayer( Player tempPlayer, int location ) {
    // if the players location is available, the let the Player join the table in
    // that location. return true;
    if ( tempPlayer.isAtTable(this) )
      return false;
    synchronized ( players ) {
      if (players[location] == null) {
        players[location] = tempPlayer;
        // Call the Player's joinTable method to give the player access to the Table's
        // public methods.
        tempPlayer.joinTable(this);
        return true;
      }
      return false;
    }
  }

  // removePlayer ( Player ) removes the player from the table.  Note, that it
  // does not need the location of the player.  It returns true if the player
  // is removed sucessfully, and false otherwise
  public boolean removePlayer ( Player tempPlayer ) {
    // loop to check all locations at the table and see if the player is located
    // in that location
    synchronized ( players ) {
      int iCount = 4;
      for (int i = 0; i < 4; i++) {
        // if so, call the Player's leaveTable() method, to remove their instance
        // of this table from their control. Also, set the location to null;
        if ( players[i] == null )
          iCount --;
        else if (players[i].equals(tempPlayer)) {
          players[i].leaveTable();
          players[i] = null;
          return true;
        }
      }
      if ( iCount == 0 ) {
        lobbyListener.removeTable( this );
      }
      return false;
    }
  }

  // removePlayer( String ) removes the player with the specified username by,
  // calling the remove( Player) method.  Note, it returns true if the Player is
  // removed successfully.
  public boolean removePlayer ( String username ) {
    Player tempPlayer = new Player ( username );
    return removePlayer ( tempPlayer );
  }

  // removeAllPlayers() removes all players at this table.
  public void removeAllPlayers () {
    synchronized ( players ) {
      for (int i = 0; i < 4; i++) {
        if (players[i] != null) {
          players[i].leaveTable();
          players[i] = null;
        }
      }
    }
  }

  public void tableChat ( TableChat oTableChat ) {
    for ( int i = 0; i < players.length; i ++ ){
      if ( players[i] != null ) {
        players[i].tableChat( oTableChat );
      }
    }
  }

  // addChatMemeber( Player ) adds a Player to the Vector of chat memebers.
  // it also calls the joinTable method for creating an instance of Table in the
  // Player
  public boolean addChatMember( Player tempPlayer ) {
    // if the player is alread a member of a table
    if ( tempPlayer.isAtTable(this) )
      return false;
    // if the player is not already a member of this table then let them join
    // and add them to the Vetor of chat members.
    synchronized ( chatMembers ) {
      if (!chatMembers.contains(tempPlayer)) {
        tempPlayer.joinTable(this);
        chatMembers.add(tempPlayer);
        return true;
      }
      else
        return false;
    }
  }

  // clearAllHands() clears all the player's hands.  All Dominos are removed.
  public void clearAllHands() {
    synchronized (players) {
      for (int i = 0; i < 4; i++) {
        players[i].clearHand();
      }
    }
  }

  // isFull() is a method returns true if the array of players is full (all locations
  // at the table are full.  It returns false otherwise
  public boolean isFull() {
    synchronized (players) {
      for (int i = 0; i < 4; i++) {
        if (players[i] == null)
          return false;
      }
      return true;
    }
  }

  public int getDealer() {
    return dealer;
  }

  // deal() is a method that shuffles the DominoSet (bones) and then distributes the
  // dominos to the players accordingly.  It returns false if the table is not full.
  // It returns true otherwise.
  public boolean deal() {
    if ( isFull() ){
      bones.shuffleSet();
      for ( int i = 0; i < players.length; i ++ ){
        Vector oHand = new Vector( 7 );
        for ( int j = 0; j < bones.size() / 4 ; j ++ ) {
          oHand.add( bones.get( j + i*7 ).toString() );
        }

        players[i].setHand( oHand );
      }
      return true;
    }
    else
      return false;
  }

  public void requestBid() {

  }

  public void bidReceived() {

  }

  public void requestPlay() {

  }

  public void playReceived() {

  }
}
