package fortytwo.testserver;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */

import java.util.Vector;
import fortytwo.network.*;
import java.net.Socket;

public class Player implements PlayerListener  {

  private String username;
  private String inetAddress;
  private String password;
  private Table table;
  private Vector hand;
  private MessageListener messageListener;
  private ServerMessageManager messageManager;
  private LobbyListener lobbyListener;

  public Player ( String tempUsername ) {
    username = tempUsername;
  }

  public Player ( Socket tempSocket, MessageListener tempMessageListener, LobbyListener tempLobbyListener ) {
    messageListener = tempMessageListener;
    lobbyListener = tempLobbyListener;
    inetAddress = tempSocket.getInetAddress().toString();
    messageManager = new ServerMessageManager( tempSocket, tempMessageListener, lobbyListener );
    messageManager.addPlayerListener( this );
  }

  public void playerLoginReceived( PlayerLogin playerLogin ) {
    username = playerLogin.getUsername();
    password = playerLogin.getPassword();

    //************* NEED TO CHECK PASSWORD ********************//
    if ( true ) {
      messageManager.welcomePlayer(username);
      lobbyListener.addChatUser(username);
    }
    else {
      // ********** NEED TO SEND ERROR MESSAGE ****************//
    }
  }

  public void createTableReceived( CreateTable createTable ) {
    if ( table == null ) {
      lobbyListener.createTable( createTable, this );
    }
  }

  public void joinTableReceived( JoinTable joinTable ) {
    if ( table == null ) {
      lobbyListener.joinTable( joinTable, this );
    }
  }

  public void disconnectReceived() {
    messageListener.messageReceived( "Disconnect received from '" + inetAddress + "' is disconnected." );
    messageManager.disconnect();
    if ( table != null ) {
      table.removePlayer(this);
    }
    lobbyListener.removePlayer( this );
  }

  public void disconnect() {
    messageListener.messageReceived( "Disconnect sent to '" + inetAddress + "'." );
    messageManager.disconnect();
    if ( table != null ) {
      table.removePlayer( this );
    }
  }

  public void tableChatReceived( TableChat oTableChat ) {
    table.tableChat( oTableChat );
  }

  public void error( ErrorMessage errorMessage ) {
    messageManager.errorMessage( errorMessage );
  }

  public void lobbyChatList( LobbyChatList list ) {
    messageManager.lobbyChatList( list );
  }

  public void lobbyChat( LobbyChat lobbyChat ) {
    messageManager.lobbyChat( lobbyChat );
  }

  public void lobbyTableList( LobbyTableList tableList ) {
    messageManager.lobbyTableList( tableList );
  }

  public void loadTable( ) {
    messageManager.loadTable( table.getPlayerNames(), table.getRules(), hand, table.getDealer() );
  }

  public boolean equals( Player tempPlayer ) {
    return username.equals( tempPlayer.getUsername() );
  }

  public String getUsername() {
    return username;
  }

  public void tableChat( TableChat oTableChat ) {
    messageManager.tableChat( oTableChat );
  }

  public boolean isAtTable( Table tempTable ) {
    if ( table.equals( tempTable ) )
      return true;
    else
      return false;
  }

  public boolean isAtTable( ) {
    if ( table == null )
      return false;
    else
      return true;
  }

  public void joinTable( Table tempTable ) {
    if (table == null)
      table = tempTable;
  }

  public void leaveTable() {
    table = null;
  }

  public void clearHand() {
    hand.removeAllElements();
  }

  public void setHand( Vector oHand ) {
    hand = oHand;
  }

  public Vector getHand() {
    return hand;
  }

}
