package fortytwo.server;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */
import java.util.Vector;

public class Table extends Thread {
  // static values for the locations of the table
  public static int NORTH = 0;
  public static int EAST = 1;
  public static int SOUTH = 2;
  public static int WEST = 3;

  // An array of players at the table
  private Player[] player = new Player[4];

  // A Vector of people chatting at the Table
  private Vector chatMembers;

  // The DominoSet used for the game play
  private DominoSet bones;

  // The rules for the game
  private Rules rules;

  // Constructor for the table.  It initializes the set of bones.
  public Table() {
    bones = new DominoSet();
  }

  // addPlayer( Player, int ) adds a player to the specified location in the array
  // of players. Locations are as follows:
  // 0 = NORTH;
  // 1 = EAST;
  // 2 = SOUTH;
  // 3 = WEST;
  // It returns true if added, and false otherwise
  public boolean addPlayer( Player tempPlayer, int location ) {
    // if the players location is available, the let the Player join the table in
    // that location. return true;
    if ( tempPlayer.isAtTable() )
      return false;
    synchronized ( player ) {
      if (player[location] == null) {
        player[location] = tempPlayer;
        // Call the Player's joinTable method to give the player access to the Table's
        // public methods.
        tempPlayer.joinTable(this);
        return true;
      }
      return false;
    }
  }

  // removePlayer ( Player ) removes the player from the table.  Note, that it
  // does not need the location of the player.  It returns true if the player
  // is removed sucessfully, and false otherwise
  public boolean removePlayer ( Player tempPlayer ) {
    // loop to check all locations at the table and see if the player is located
    // in that location
    synchronized ( player ) {
      for (int i = 0; i < 4; i++) {
        // if so, call the Player's leaveTable() method, to remove their instance
        // of this table from their control. Also, set the location to null;
        if (player[i].equals(tempPlayer)) {
          player[i].leaveTable();
          player[i] = null;
          return true;
        }
      }
      return false;
    }
  }

  // removePlayer( String ) removes the player with the specified username by,
  // calling the remove( Player) method.  Note, it returns true if the Player is
  // removed successfully.
  public boolean removePlayer ( String username ) {
    Player tempPlayer = new Player ( username );
    return removePlayer ( tempPlayer );
  }

  // removeAllPlayers() removes all players at this table.
  public void removeAllPlayers () {
    synchronized ( player ) {
      for (int i = 0; i < 4; i++) {
        if (player[i] != null) {
          player[i].leaveTable();
          player[i] = null;
        }
      }
    }
  }

  // addChatMemeber( Player ) adds a Player to the Vector of chat memebers.
  // it also calls the joinTable method for creating an instance of Table in the
  // Player
  public boolean addChatMember( Player tempPlayer ) {
    // if the player is alread a member of a table
    if ( tempPlayer.isAtTable() )
      return false;
    // if the player is not already a member of this table then let them join
    // and add them to the Vetor of chat members.
    synchronized ( chatMembers ) {
      if (!chatMembers.contains(tempPlayer)) {
        tempPlayer.joinTable(this);
        chatMembers.add(tempPlayer);
        return true;
      }
      else
        return false;
    }
  }

  // clearAllHands() clears all the player's hands.  All Dominos are removed.
  public void clearAllHands() {
    synchronized (player) {
      for (int i = 0; i < 4; i++) {
        player[i].clearHand();
      }
    }
  }

  // isFull() is a method returns true if the array of players is full (all locations
  // at the table are full.  It returns false otherwise
  public boolean isFull() {
    synchronized (player) {
      for (int i = 0; i < 4; i++) {
        if (player[i] == null)
          return false;
      }
      return true;
    }
  }

  // deal() is a method that shuffles the DominoSet (bones) and then distributes the
  // dominos to the players accordingly.  It returns false if the table is not full.
  // It returns true otherwise.
  public boolean deal() {
    if ( isFull() ){
      bones.shuffleSet();
      return true;
    }
    else
      return false;
  }

}
