package fortytwo.network;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */

import java.util.StringTokenizer;

public class Rules {
  private boolean m_bFollowMeHi;
  private boolean m_bFollowMeLo;
  private boolean m_bFollowMeOS;
  private boolean m_bNelloHi;
  private boolean m_bNelloLo;
  private boolean m_bNelloOS;
  private boolean m_bPlunge;
  private boolean m_bSevens;

  private static final String m_sFollowMeHi = "FollowMe-Hi";
  private static final String m_sFollowMeLo = "FollowMe-Lo";
  private static final String m_sFollowMeOS = "FollowMe-OS";
  private static final String m_sNelloHi = "Nello-Hi";
  private static final String m_sNelloLo = "Nello-Lo";
  private static final String m_sNelloOS = "Nello-OS";
  private static final String m_sPlunge = "Plunge";
  private static final String m_sSevens = "Sevens";

  public final static String DELIMITER = " ";

  public Rules() {
    m_bFollowMeHi = true;
    m_bFollowMeLo = false;
    m_bFollowMeOS = false;
    m_bNelloHi = false;
    m_bNelloLo = false;
    m_bPlunge = false;
    m_bSevens = false;
  }

  public Rules(boolean tempFollowMeHi, boolean tempFollowMeLo, boolean tempFollowMeOS,
               boolean tempNelloHi, boolean tempNelloLo, boolean tempNelloOS,
               boolean tempPlunge, boolean tempSevens) {
    m_bFollowMeHi = tempFollowMeHi;
    m_bFollowMeLo = tempFollowMeLo;
    m_bFollowMeOS = tempFollowMeOS;
    m_bNelloHi = tempNelloHi;
    m_bNelloLo = tempNelloLo;
    m_bNelloOS = tempNelloOS;
    m_bPlunge = tempPlunge;
    m_bSevens = tempSevens;
  }

  public void setRules(boolean tempFollowMeHi, boolean tempFollowMeLo, boolean tempFollowMeOS,
                       boolean tempNelloHi, boolean tempNelloLo, boolean tempNelloOS,
                       boolean tempPlunge, boolean tempSevens) {
    m_bFollowMeHi = tempFollowMeHi;
    m_bFollowMeLo = tempFollowMeLo;
    m_bFollowMeOS = tempFollowMeOS;
    m_bNelloHi = tempNelloHi;
    m_bNelloLo = tempNelloLo;
    m_bNelloOS = tempNelloOS;
    m_bPlunge = tempPlunge;
    m_bSevens = tempSevens;
  }

  public boolean getFollowMeHi() {
    return m_bFollowMeHi;
  }

  public boolean getFollowMeLo() {
    return m_bFollowMeLo;
  }

  public boolean getFollowMeOS() {
    return m_bFollowMeOS;
  }

  public boolean getNelloHi() {
    return m_bNelloHi;
  }

  public boolean getNelloLo() {
    return m_bNelloLo;
  }

  public boolean getNelloOS() {
    return m_bNelloOS;
  }

  public boolean getPlunge() {
    return m_bPlunge;
  }

  public boolean getSevens() {
    return m_bSevens;
  }

  // for displaying in the LobbyTableList
  public String getRulesAsString() {
    String rulesString = "";
    if (m_bFollowMeHi)
      rulesString += m_sFollowMeHi + DELIMITER;
    if (m_bFollowMeLo)
      rulesString += m_sFollowMeLo + DELIMITER;
    if (m_bFollowMeOS)
      rulesString += m_sFollowMeOS + DELIMITER;
    if (m_bNelloHi)
      rulesString += m_sNelloHi + DELIMITER;
    if (m_bNelloLo)
      rulesString += m_sNelloLo + DELIMITER;
    if (m_bNelloOS)
      rulesString += m_sNelloOS + DELIMITER;
    if (m_bPlunge)
      rulesString += m_sPlunge + DELIMITER;
    if (m_bSevens)
      rulesString += m_sSevens;
    return rulesString;
  }

  public void setRulesFromString( String sRules ) {
    StringTokenizer oTokenizer = new StringTokenizer(sRules);
    if ( oTokenizer.hasMoreTokens() )
      m_bFollowMeHi = false;
    else
      m_bFollowMeHi = true;
    m_bFollowMeLo = false;
    m_bFollowMeOS = false;
    m_bNelloHi = false;
    m_bNelloLo = false;
    m_bNelloOS = false;
    m_bPlunge = false;
    m_bSevens = false;

    while (oTokenizer.hasMoreTokens()) {
      if (oTokenizer.nextToken().equals(m_sFollowMeHi)) {
        m_bFollowMeHi = true;
      }
      else if (oTokenizer.nextToken().equals(m_sFollowMeLo)) {
        m_bFollowMeLo = true;
      }
      else if (oTokenizer.nextToken().equals(m_sFollowMeOS)) {
        m_bFollowMeOS = true;
      }
      else if (oTokenizer.nextToken().equals(m_sNelloHi)) {
        m_bNelloHi = true;
      }
      else if (oTokenizer.nextToken().equals(m_sNelloLo)) {
        m_bNelloLo = true;
      }
      else if (oTokenizer.nextToken().equals(m_sNelloOS)) {
        m_bNelloOS = true;
      }
      else if (oTokenizer.nextToken().equals(m_sPlunge)) {
        m_bPlunge = true;
      }
      else if (oTokenizer.nextToken().equals(m_sSevens)) {
        m_bSevens = true;
      }
    }
  }

  public Rules getRulesFromString(String sRules) {
    Rules oRules;

    boolean m_bFollowMeHi;
    boolean m_bFollowMeLo;
    boolean m_bFollowMeOS;
    boolean m_bNelloHi;
    boolean m_bNelloLo;
    boolean m_bNelloOS;
    boolean m_bPlunge;
    boolean m_bSevens;


    StringTokenizer oTokenizer = new StringTokenizer(sRules);
    if (oTokenizer.hasMoreTokens())
      m_bFollowMeHi = false;
    else
      m_bFollowMeHi = true;
    m_bFollowMeLo = false;
    m_bFollowMeOS = false;
    m_bNelloHi = false;
    m_bNelloLo = false;
    m_bNelloOS = false;
    m_bPlunge = false;
    m_bSevens = false;

    while (oTokenizer.hasMoreTokens()) {
      if (oTokenizer.nextToken().equals(m_sFollowMeHi)) {
        m_bFollowMeHi = true;
      }
      else if (oTokenizer.nextToken().equals(m_sFollowMeLo)) {
        m_bFollowMeLo = true;
      }
      else if (oTokenizer.nextToken().equals(m_sFollowMeOS)) {
        m_bFollowMeOS = true;
      }
      else if (oTokenizer.nextToken().equals(m_sNelloHi)) {
        m_bNelloHi = true;
      }
      else if (oTokenizer.nextToken().equals(m_sNelloLo)) {
        m_bNelloLo = true;
      }
      else if (oTokenizer.nextToken().equals(m_sNelloOS)) {
        m_bNelloOS = true;
      }
      else if (oTokenizer.nextToken().equals(m_sPlunge)) {
        m_bPlunge = true;
      }
      else if (oTokenizer.nextToken().equals(m_sSevens)) {
        m_bSevens = true;
      }
    }
    return new Rules( m_bFollowMeHi, m_bFollowMeLo, m_bFollowMeOS, m_bNelloHi, m_bNelloLo,
                      m_bNelloOS, m_bPlunge, m_bSevens );

  }


}
