package fortytwo.network;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */

import java.net.Socket;
import java.util.LinkedList;
import java.net.UnknownHostException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.InterruptedException;

public class ProtocolHandler {

  private Socket m_oSocket;
  private Thread m_oReceiveThread;
  private Thread m_oSendThread;
  private LinkedList m_oReceiveQueue;
  private LinkedList m_oSendQueue;
  private boolean m_bExternalConnected;
  private boolean m_bInternalConnected;

  // constructor for the server side Protocol Handler
  public ProtocolHandler( Socket clientSocket ) {
    m_oSocket = clientSocket;
    m_oReceiveQueue = new LinkedList();
    m_oSendQueue = new LinkedList();
    if ( m_oSocket.isConnected() ) {
      m_bExternalConnected = true;
      m_bInternalConnected = true;
      m_oReceiveThread = new Thread( new ReceiveThread () );
      m_oSendThread = new Thread( new SendThread() );
      m_oReceiveThread.start();
      m_oSendThread.start();
    }
    else {
      m_oSocket = null;
      m_bExternalConnected = false;
      m_bInternalConnected = false;
    }
  }

  // constructor for the client side Protocol Handler
  public ProtocolHandler( String hostname, int port ) {
    m_oReceiveQueue = new LinkedList();
    m_oSendQueue = new LinkedList();
    try {
      m_oSocket = new Socket( hostname, port );
      if ( m_oSocket.isConnected() ){
        m_bExternalConnected = true;
        m_bInternalConnected = true;
        m_oReceiveThread = new Thread( new ReceiveThread() );
        m_oSendThread = new Thread( new SendThread() );
        m_oReceiveThread.start();
        m_oSendThread.start();
      }
      else {
        m_oSocket = null;
        m_bExternalConnected = false;
        m_bInternalConnected = false;
      }
    }
    catch( UnknownHostException uhException ) {
      System.out.println( "Unknown Host" );
      m_oSocket = null;
      m_bExternalConnected = false;
      m_bInternalConnected = false;
    }
    catch( IOException ioException ) {
      System.out.println( "IOException:" );
      System.out.println( ioException.getMessage() );
      m_oSocket = null;
      m_bExternalConnected = false;
      m_bInternalConnected = false;

    }
  }

  public boolean isConnected() {
    return ( m_bExternalConnected && m_bInternalConnected );
  }

  public boolean hasMessage() {
    boolean bHasMessage;
    synchronized( m_oReceiveQueue )
    {
      bHasMessage = ( m_oReceiveQueue.size() > 0 );
    }
    return bHasMessage;
  }

  public Message nextMessage() {
    Message oMessage = null;
    synchronized ( m_oReceiveQueue ) {
      if ( m_oReceiveQueue.size() > 0 ) {
        oMessage = ( Message )m_oReceiveQueue.removeFirst();
      }
    }
    return oMessage;
  }

  public void sendMessage(Message oMessage) {
    synchronized (m_oSendQueue) {
      m_oSendQueue.addLast(oMessage);
    }
  }

  public void close() {
    m_bExternalConnected = false;
    if (m_oSocket != null) {
      if (m_bInternalConnected) {
        try {
          m_oSocket.close();
        }
        catch (IOException ex) {
        }
        m_oSocket = null;
      }
      else {
        m_oSocket = null;
      }
    }
  }

  public class ReceiveThread implements Runnable {
    public void run() {
      try {
        DataInputStream oIn = new DataInputStream( m_oSocket.getInputStream() );
        while ( isConnected() ) {
          String message = oIn.readUTF();
          synchronized ( m_oReceiveQueue ) {
            Message oMessage = new Message(message);

            //////////////////////////////////
            // DEBUGGING PURPOSES:
            System.out.print ( "Receiving: " );
            System.out.println( message );
            // DEBUGGING PURPOSES END
            //////////////////////////////////

            m_oReceiveQueue.addLast( oMessage );
          }// synchronized end
        }// while end
      }// try end
      catch( IOException ioException) {
        m_bInternalConnected = false;
        return;
      }// catch end
    }// run() end
  }// ReceiveThread class end

  public class SendThread implements Runnable {
    public void run() {
      try {
        DataOutputStream oOut = new DataOutputStream( m_oSocket.getOutputStream() );
        while( isConnected() ) {
          if ( m_oSendQueue.size() > 0 ) {
            Message oMessage;
            synchronized( m_oSendQueue ) {
              oMessage = (Message)m_oSendQueue.removeFirst();
            }// synchronized end

            ///////////////////////////////////
            // DEBUGGING OUTPUT
            System.out.print( "Sending: " );
            System.out.println( oMessage.getMessage() );
            // DEBUGGIN OUTPUT END
            ///////////////////////////////////

            oOut.writeUTF( oMessage.getMessage() );
          }// if end
          else {
            try {
              Thread.sleep( 10 );
            }// try end
            catch( InterruptedException iException ) {
            }// catch end
          }// else end
        }// while end
      }// try end
      catch( IOException ioException ) {
        m_bInternalConnected = false;
        return;
      }// catch end
    }// run() end
  }// SendThread end

}
