package fortytwo.network;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */

import java.util.Vector;
import java.util.StringTokenizer;

public class LobbyChatList extends Message {
  public static final String type = "5";
  private Vector vector_chatList;

  public static final int m_iType = 20;

  public LobbyChatList ( Message message ) {
    setMessage ( message.getMessage() );
    vector_chatList = getChatList();
  }

  public LobbyChatList ( Vector chatList ) {
    vector_chatList = chatList;
    String tempMessage = type + DELIMITER;
    for( int i = 0; i < vector_chatList.size(); i ++ ){
      tempMessage += (String)vector_chatList.get(i) + DELIMITER;
    }
    setMessage( tempMessage );
  }

  public Vector getChatList() {
    StringTokenizer tokenizer = new StringTokenizer( getMessage(), DELIMITER );
    Vector chatList = new Vector();
    if ( tokenizer.countTokens() >= 2 ) {
      String header = tokenizer.nextToken();
      chatList.add( tokenizer.nextToken() );
      while ( tokenizer.hasMoreTokens() ) {
        String element = tokenizer.nextToken();
        // alphabetize the elements
        int i = 0;
        while ( i < chatList.size() ) {
          if ( element.compareTo( (String)chatList.get(i) ) < 0 )
            break;
          i ++;
        }
        chatList.add(i, element);
      }
    }
    return chatList;
  }
}
