package fortytwo.network;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */

import java.util.StringTokenizer;

public class LobbyChat extends Message {
  public static final String type = "10";
  String username;
  String chat;

  public LobbyChat( Message tempMessage ) {
    setMessage( tempMessage.getMessage() );
    getLobbyChat();
  }

  public LobbyChat( String tempUsername, String chatToSend ) {
    username = tempUsername;
    chat = chatToSend;
    setMessage( type + DELIMITER + username + DELIMITER + chatToSend );
  }

  public void getLobbyChat() {
    StringTokenizer tokenizer = new StringTokenizer( getMessage(), DELIMITER );
    String header = "";
    String tempUser = "";
    String tempChat = "";
    if ( tokenizer.countTokens() >= 2 ) {
      header = tokenizer.nextToken();
      tempUser = tokenizer.nextToken();
      if ( tokenizer.hasMoreTokens() ) {
        tempChat = tokenizer.nextToken();
        while (tokenizer.hasMoreTokens())
          tempChat += DELIMITER + tokenizer.nextToken();

        username = tempUser;
        chat = tempChat;
      }
    }
  }

  public String getUsername () {
    return username;
  }

  public String getChat () {
    return chat;
  }

  public void setUsername ( String tempUser ) {
    username = tempUser;
  }

  public void setChat ( String tempChat ) {
    chat = tempChat;
  }

}
