package fortytwo.network;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */

import java.util.StringTokenizer;

public class CreateTable extends Message {

  public static final String type = "20";
  public static final String TRUE = "true";
  public static final String FALSE = "false";
  private Rules rules;

  public CreateTable( Message tempMessage ) {
    setMessage( tempMessage.getMessage() );
    getCreateTable();
  }

  public CreateTable( Rules tempRules ) {
    rules = tempRules;

    setMessage( type + DELIMITER + rules.getFollowMeHi()
                + DELIMITER + rules.getFollowMeLo() + DELIMITER + rules.getFollowMeOS()
                + DELIMITER + rules.getNelloHi() + DELIMITER + rules.getNelloLo()
                + DELIMITER + rules.getNelloOS() + DELIMITER + rules.getPlunge()
                + DELIMITER + rules.getSevens() );


  }

  public void getCreateTable() {
    StringTokenizer tokenizer = new StringTokenizer( getMessage(), DELIMITER );
    String header = "";
    String tempUser = "";
    if ( tokenizer.countTokens() == 9 ) {
      header = tokenizer.nextToken();
      boolean followMeHi, followMeLo, followMeOS, nelloHi;
      boolean nelloLo, nelloOS, plunge, sevens;
      followMeHi = tokenizer.nextToken().equals( TRUE );
      followMeLo = tokenizer.nextToken().equals( TRUE );
      followMeOS = tokenizer.nextToken().equals( TRUE );
      nelloHi = tokenizer.nextToken().equals( TRUE );
      nelloLo = tokenizer.nextToken().equals( TRUE );
      nelloOS = tokenizer.nextToken().equals( TRUE );
      plunge = tokenizer.nextToken().equals( TRUE );
      sevens = tokenizer.nextToken().equals( TRUE );
      rules = new Rules( followMeHi, followMeLo, followMeOS, nelloHi, nelloLo,
                         nelloOS, plunge, sevens );
    }
  }

  public Rules getRules () {
    return rules;
  }

}
