package fortytwo.client;

import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.GridBagConstraints;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.JList;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import java.util.StringTokenizer;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */

import java.util.Vector;
import fortytwo.network.*;

public class TablePanel extends Panel implements TablePanelListener {
  GridBagLayout gbLayout_TablePane = new GridBagLayout();
  JScrollPane jSP_TablesOpen = new JScrollPane();
  JList jList_TablesOpen = new JList();
  JButton jButton_CreateTable = new JButton();
  JButton jButton_JoinTable = new JButton();
  Vector vector_TablesOpen = new Vector();
  public TablePanel() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
    ClientMessageManager.getInstance().addTablePanelListener( this );
  }

  public void welcomePlayerReceived( WelcomePlayer welcomePlayer ) {
    jButton_CreateTable.setEnabled(true);
    if ( vector_TablesOpen.size() == 0 ) {
      jButton_JoinTable.setEnabled(false);
    }
    else
      jButton_JoinTable.setEnabled(true);

  }

  public void disconnectReceived() {
    jButton_CreateTable.setEnabled(false);
    jButton_JoinTable.setEnabled(false);
    jList_TablesOpen.setListData( new Vector() );
    jList_TablesOpen.repaint();
  }

  public void lobbyTableListReceived( LobbyTableList tableList ) {
    vector_TablesOpen = tableList.getLobbyTableList();
    jList_TablesOpen.setListData(vector_TablesOpen);
    jList_TablesOpen.repaint();

    if ( vector_TablesOpen.size() > 0 )
      jButton_JoinTable.setEnabled(true);

  }

  private void jbInit() throws Exception {
    this.setLayout(gbLayout_TablePane);
    jSP_TablesOpen.setMinimumSize(new Dimension(150, 200));
    jSP_TablesOpen.setPreferredSize(new Dimension(150, 200));
    jList_TablesOpen.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    jList_TablesOpen.setVisibleRowCount(8);
    jList_TablesOpen.setListData(vector_TablesOpen);
    jButton_CreateTable.addActionListener( new CreateTableListener() );
    jButton_CreateTable.setEnabled(false);
    jButton_CreateTable.setMaximumSize(new Dimension(69, 23));
    jButton_CreateTable.setHorizontalAlignment(SwingConstants.LEFT);
    jButton_CreateTable.setMargin(new Insets(1, 1, 1, 1));
    jButton_CreateTable.setText("Create Table");
    jButton_CreateTable.setVerticalAlignment(javax.swing.SwingConstants.CENTER);
    jButton_JoinTable.addActionListener( new JoinTableListener() );
    jButton_JoinTable.setMargin(new Insets(1, 3, 1, 3));
    jButton_JoinTable.setText("Join Table");
    jButton_JoinTable.setEnabled(false);
    this.add(jSP_TablesOpen,    new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(4, 4, 4, 4), 2, 2));
    jSP_TablesOpen.getViewport().add(jList_TablesOpen, null);
    this.add(jButton_CreateTable,     new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.SOUTHWEST, GridBagConstraints.NONE, new Insets(4, 4, 4, 4), 2, 2));
    this.add(jButton_JoinTable,   new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.SOUTHEAST, GridBagConstraints.NONE, new Insets(4, 4, 4, 4), 2, 2));

  }

  private class CreateTableListener implements ActionListener {
    public void actionPerformed( ActionEvent oEvent ) {
      ClientMessageManager.getInstance().createTable( new Rules() );
    }
  }

  private class JoinTableListener implements ActionListener {
    public void actionPerformed( ActionEvent oEvent ) {
      if ( jList_TablesOpen.isSelectionEmpty() )
        ;
      else {
        String oTableString = (String) jList_TablesOpen.getSelectedValue();
        StringTokenizer oTokenizer = new StringTokenizer(oTableString);
        String sTableNum = oTokenizer.nextToken();
        System.out.println("Table" + sTableNum );
        ClientMessageManager.getInstance().joinTable( new Integer(sTableNum).intValue() );
      }
    }
  }


}
