package fortytwo.client;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;


/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */

import fortytwo.network.*;

public class TableFrame extends JFrame implements TableFrameListener {
  private JFrame m_oJFrame = this;
  private TableFrameListener m_oListener = this;
  private JPanel m_oContentPane;

  private JPanel m_oButtonPane;
  private JPanel m_oChatPane;
  private JPanel m_oTablePane;

  // button pane components
  private JButton m_oLeaveButton;
  private JButton m_oOptionButton;
  private JButton m_oLastTrickButton;
  private JLabel[] m_oScoreLabels;

  // chat pane components
  private JScrollPane m_oChatScrollPane;
  private JTextArea m_oChatTextArea;
  private JTextField m_oChatTextField;
  private JButton m_oChatButton;

  // table pane components ( may need to be changed in the near future
  private JLabel m_oYourLabel;
  private JLabel m_oYourPartnerLabel;
  private JLabel m_oLeftOpponentLabel;
  private JLabel m_oRightOpponentLabel;

  private Vector m_oHandDominoPanels; // array of domino panels for the player's dominos
  private Vector m_oPlayedDominoPanels;
  private JLabel m_oHighBidderLabel;
  private JLabel m_oBidLabel;
  private JLabel m_oRuleLabel;

  // table state information
  private int m_oWhoseTurn; // whose ture it is
  private int m_oPosition; // what position you are at the table
  private Vector m_oPlayers; // holds the usernames of the players at the table
  private Rules m_oRules; // rules for the table
  private int m_oDealer;
  private Vector m_oDominos;
  private Vector m_oHand;

  /**
   * TableFrame constructor
   * @param oLoadTable LoadTable
   */
  public TableFrame( LoadTable oLoadTable ) {

    // set the Frame's layout, size and title
    setSize(700, 700);
    setTitle("42Unlimited.com Table "); // TODO: Insert table number here

    // add the content panel to the Frame.
    m_oContentPane = new JPanel( null );

    // initialize the main panels and set their layout to null
    m_oTablePane = new JPanel( null );
    m_oChatPane = new JPanel( null );
    m_oButtonPane = new JPanel( null );

    // add them to the content panel and sent the resizing options
    m_oContentPane.addComponentListener(new ComponentAdapter() {
      public void componentResized( ComponentEvent oEvent ) {
        int iWidth = m_oContentPane.getWidth();
        int iHeight = m_oContentPane.getHeight();
        m_oButtonPane.reshape( 0, 0, 150, iHeight);
        m_oTablePane.reshape( 150, 0 + 2, iWidth - 150 , iHeight - 200 );
        m_oTablePane.setBorder( BorderFactory.createLineBorder( Color.black, 1 ) );
        m_oChatPane.reshape( 150, iHeight - 200, iWidth - 150 , 200 );
      }
    });
    m_oContentPane.add( m_oButtonPane );
    m_oContentPane.add( m_oTablePane );
    m_oContentPane.add( m_oChatPane );


    m_oPlayers = oLoadTable.getPlayers( );
    m_oRules = oLoadTable.getRules( );
    m_oDealer = oLoadTable.getDealer();
    m_oDominos = oLoadTable.getDominos();

    getHand();

    // get the position of the players at the table
    getUserSeat();

    // get the usernames and place them into the labels
    m_oYourLabel = new JLabel();
    m_oYourLabel.setHorizontalAlignment( JLabel.CENTER );
    m_oYourPartnerLabel = new JLabel();
    m_oYourPartnerLabel.setHorizontalAlignment( JLabel.CENTER );
    m_oLeftOpponentLabel = new JLabel();
    m_oLeftOpponentLabel.setHorizontalAlignment( JLabel.CENTER );
    m_oRightOpponentLabel = new JLabel( );
    m_oRightOpponentLabel.setHorizontalAlignment( JLabel.CENTER );

    labelizePlayers();

    // construct the domino panels



    // construct the Bidding and Rule Labels
    m_oHighBidderLabel = new JLabel( "High Bidder: " );
    m_oHighBidderLabel.setForeground( Color.red );
    m_oBidLabel = new JLabel( "Bid: " );
    m_oBidLabel.setForeground( Color.red );
    m_oRuleLabel = new JLabel( "Play Type: " );
    m_oRuleLabel.setForeground( Color.red );

    // add the components to the Table Pane and set their resizing options.
    m_oTablePane.addComponentListener(new ComponentAdapter() {
      public void componentResized(ComponentEvent oEvent) {
        int iWidth = m_oTablePane.getWidth();
        int iHeight = m_oTablePane.getHeight();

        m_oYourPartnerLabel.reshape(iWidth / 2 - 75 / 2, 0, 75, 22);
        m_oYourLabel.reshape(iWidth / 2 - 75 / 2, iHeight - 22, 75, 22);
        m_oLeftOpponentLabel.reshape(0, iHeight / 2 - 11, 75, 22);
        m_oRightOpponentLabel.reshape(iWidth - 75, iHeight / 2 - 11, 75, 22);

        m_oHighBidderLabel.reshape( 4, 0, 100, 22);
        m_oBidLabel.reshape( 4, 22, 100, 22);
        m_oRuleLabel.reshape( 4, 22*2, 100, 22 );
        //((Domino)m_oHand.get(0)).reshape( 50, iHeight - 130, 101, 53);
        //((Domino)m_oHand.get(0)).reshape( 50 + 105*1, iHeight - 130, 101, 53);
        //((Domino)m_oHand.get(0)).reshape( 50 + 105*2, iHeight - 130, 101, 53);
        //((Domino)m_oHand.get(0)).reshape( 50 + 105*3, iHeight - 130, 101, 53);
        //((Domino)m_oHand.get(0)).reshape( 100, iHeight - 76, 101, 53);
        //((Domino)m_oHand.get(0)).reshape( 100 + 105*1, iHeight - 76, 101, 53);
        //((Domino)m_oHand.get(0)).reshape( 100 + 105*2, iHeight - 76, 101, 53);
      }
    });

    //m_oTablePane.add( (Domino)m_oHand.get(0) );
    //m_oTablePane.add( (Domino)m_oHand.get(1) );
    //m_oTablePane.add( (Domino)m_oHand.get(2) );
    //m_oTablePane.add( (Domino)m_oHand.get(3) );
    //m_oTablePane.add( (Domino)m_oHand.get(4) );
    //m_oTablePane.add( (Domino)m_oHand.get(5) );
    //m_oTablePane.add( (Domino)m_oHand.get(6) );
    m_oTablePane.add(m_oYourPartnerLabel);
    m_oTablePane.add(m_oYourLabel);
    m_oTablePane.add(m_oLeftOpponentLabel);
    m_oTablePane.add(m_oRightOpponentLabel);

    m_oTablePane.add( m_oHighBidderLabel );
    m_oTablePane.add( m_oBidLabel );
    m_oTablePane.add( m_oRuleLabel );
    m_oTablePane.repaint();
    m_oTablePane.validate();

    // construct the chat area
    m_oChatTextArea = new JTextArea( );
    m_oChatTextArea.setWrapStyleWord(true);
    m_oChatTextArea.setLineWrap( true );
    m_oChatTextArea.setEditable( false );

    m_oChatScrollPane = new JScrollPane( m_oChatTextArea );
    m_oChatScrollPane.setVerticalScrollBarPolicy( JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED );
    m_oChatScrollPane.setHorizontalScrollBarPolicy( JScrollPane.HORIZONTAL_SCROLLBAR_NEVER );
    m_oChatScrollPane.setWheelScrollingEnabled( true );

    m_oChatTextField = new JTextField( );
    m_oChatTextField.addActionListener( new TableChatActionListener() );

    m_oChatButton = new JButton( "Send Chat" );
    m_oChatButton.addActionListener( new TableChatActionListener() );

    m_oChatPane.addComponentListener( new ComponentAdapter() {
     public void componentResized( ComponentEvent oEvent ) {
       int iWidth = m_oChatPane.getWidth();
       int iHeight = m_oChatPane.getHeight();

       m_oChatScrollPane.reshape( 0, 5, iWidth, iHeight - 27 );
       m_oChatTextField.reshape( 0, iHeight - 22, iWidth - 100, 22 );
       m_oChatButton.reshape( iWidth - 100, iHeight - 22, 100, 22 );
     }
    });

    m_oChatPane.add( m_oChatScrollPane );
    m_oChatPane.add( m_oChatTextField );
    m_oChatPane.add( m_oChatButton );
    m_oChatPane.validate();

    // construct the button area
    m_oLeaveButton = new JButton( "Leave Table" );
    m_oOptionButton = new JButton("Options");
    m_oLastTrickButton = new JButton("Last Trick");
    m_oScoreLabels = new JLabel[] {
        new JLabel(),
        new JLabel()
    };

    m_oButtonPane.addComponentListener(new ComponentAdapter() {
      public void componentResized(ComponentEvent oEvent) {
        int iWidth = m_oButtonPane.getWidth();
        int iHeight = m_oButtonPane.getHeight();
        m_oLeaveButton.reshape( 2, 2, iWidth -2, 22 );
        m_oOptionButton.reshape( 2, 24, iWidth -2, 22 );
        m_oScoreLabels[0].reshape( 2, 48, iWidth - 2, 22 );
        m_oScoreLabels[1].reshape( 2, 72, iWidth - 2, 22 );
      }
    });

    m_oButtonPane.add( m_oLeaveButton );
    m_oButtonPane.add( m_oOptionButton );
    m_oButtonPane.add( m_oScoreLabels[0] );
    m_oButtonPane.add( m_oScoreLabels[1] );

    try {
      jbInit();
    }
    catch(Exception ex) {
      ex.printStackTrace();
    }

    ClientMessageManager.getInstance().addTableFrameListener( this );
    m_oContentPane.validate();
    setContentPane( m_oContentPane );
    setVisible( true);
    this.addWindowListener(new WindowAdapter() {
      public void windowClosed(WindowEvent oEvent) {
        ClientMessageManager.getInstance().removeTableFrameListener(m_oListener);
        m_oJFrame.dispose();
      }
});

  }

  /**
   * getUserPosition
   */
  private void getUserSeat() // throws NotAtTableException
  {
    String oUsername = ClientMessageManager.getInstance().getUsername();
    m_oPosition = -1; // error case;
    for (int i = 0; i < m_oPlayers.size(); i++) {
      String oPlayerUsername = (String) m_oPlayers.get(i);
      if (oUsername.equals(oPlayerUsername)) {
        m_oPosition = i;
      }
    }
    if (m_oPosition == -1) {
      ///////////////////////////////////
      // TODO:
      // throw NotAtTableException;
    }
  }

  /**
   * labelizePlayers
   */
  private void labelizePlayers() {
    if ( m_oPlayers.size() == 4 ) {
      String oUsername = (String) m_oPlayers.get(m_oPosition);
      m_oYourLabel.setText(oUsername);
      oUsername = (String) m_oPlayers.get((m_oPosition + 1) % 4);
      m_oLeftOpponentLabel.setText(oUsername);
      oUsername = (String) m_oPlayers.get((m_oPosition + 2) % 4);
      m_oYourPartnerLabel.setText(oUsername);
      oUsername = (String) m_oPlayers.get((m_oPosition + 3) % 4);
      m_oRightOpponentLabel.setText(oUsername);
    }
  }

  private void getHand() {
    m_oHand = new Vector();
    for ( int i = 0; i < m_oDominos.size(); i ++ ) {
      String oDomino = ( String ) m_oDominos.get( i );
      m_oHand.add( new Domino( oDomino ) );
      System.out.println( "Domino added: " + oDomino ) ;
    }
  }

  /**
   *
   * @throws Exception
   */
  private void jbInit() throws Exception {
    setDefaultCloseOperation(DISPOSE_ON_CLOSE);
  }

  private class TableChatActionListener implements ActionListener {
    public void actionPerformed( ActionEvent oEvent ) {
      String oChat = m_oChatTextField.getText();
      if ( oChat.equals( "" ) || oChat == null ) {
        ;
      }
      else {
        ClientMessageManager.getInstance().tableChat( oChat );
        m_oChatTextField.setText( "" );
      }
    }
  }

  /**
   * disconnectReceived
   */
  public void disconnectReceived() {
    ClientMessageManager.getInstance().removeTableFrameListener( m_oListener );
    this.dispose();
  }

  /**
   * playReceived
   */
  public void playReceived() {
  }

  /**
   * bidReceived
   */
  public void bidReceived() {
  }

  /**
   * scoreReceived
   */
  public void scoreReceived() {
  }

  /**
   * playerLeftReceived
   */
  public void playerLeftReceived() {
  }

  /**
   * playerJoinReceived
   */
  public void playerJoinReceived() {
  }

  /**
   *
   * @param oUsername String
   * @param oChat String
   */
  public void tableChatReceived( String oUsername, String oChat ) {
    synchronized( m_oChatTextArea ) {
      m_oChatTextArea.append( oUsername + ": " + oChat + "\n" );
      m_oChatTextArea.setCaretPosition( m_oChatTextArea.getText().length() );
    }

  }
}
