package fortytwo.client;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */

import java.awt.Image;
import javax.swing.ImageIcon;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import java.awt.Graphics;

public class Domino extends JPanel {
  private int m_iLeft;
  private int m_iRight;

  private Image m_oImage;

  public Domino( int leftTemp, int rightTemp ) {
    m_iLeft = leftTemp;
    m_iRight = rightTemp;
    grabImage();
  }

  public Domino( String oString ) {
    StringTokenizer oTokenizer = new StringTokenizer( oString, "-" );
    if ( oTokenizer.countTokens() == 2 ) {
      m_iLeft = new Integer(oTokenizer.nextToken()).intValue();
      m_iRight = new Integer(oTokenizer.nextToken()).intValue();
    }
    grabImage();
  }

  public boolean equals ( Domino tempDom ) {
    if ( tempDom.m_iLeft == m_iLeft && tempDom.m_iRight == m_iRight ||
         tempDom.m_iLeft == m_iRight && tempDom.m_iRight == m_iLeft) {
      return true;
    }
    else
      return false;
  }

  public boolean isBlank( ) {
    if ( m_iLeft == 0 || m_iRight == 0 )
      return true;
    else
      return false;
  }

  public boolean isOne( ) {
    if ( m_iLeft == 1 || m_iRight == 1 )
      return true;
    else
      return false;
  }

  public boolean isTwo( ) {
    if ( m_iLeft == 2 || m_iRight == 2 )
      return true;
    else
      return false;
  }

  public boolean isThree( ) {
    if ( m_iLeft == 3 || m_iRight == 3 )
      return true;
    else
      return false;
  }

  public boolean isFour( ) {
    if ( m_iLeft == 4 || m_iRight == 4 )
      return true;
    else
      return false;
  }

  public boolean isFive( ) {
    if ( m_iLeft == 5 || m_iRight == 5 )
      return true;
    else
      return false;
  }

  public boolean isSix( ) {
    if( m_iLeft == 6 || m_iRight == 6 )
      return true;
    else
      return false;
  }

  public boolean isDouble( ) {
    if ( m_iLeft == m_iRight )
      return true;
    else
      return false;
  }

  private int getOtherSide( int iSide ) {
    if ( m_iLeft == iSide )
      return m_iRight;
    else if ( m_iRight == iSide )
      return m_iLeft;
    else
      return -1;
  }

  private void grabImage() {
    String sName = "domino";
    if ( m_iLeft >= m_iRight )
      sName += m_iLeft + m_iRight;
    else
      sName += m_iRight + m_iLeft;

    m_oImage = new ImageIcon( "http://209.193.52.222/images/" + sName + ".gif" ).getImage();
  }

  public String toString() {
    if ( m_iLeft >= m_iRight )
      return "" + m_iLeft + "-" + m_iRight;
    else
      return "" + m_iRight + "-" + m_iRight;
  }

  public Image getImage( ) {
    return m_oImage;
  }

  public void paintComponent( Graphics g ) {
    super.paintComponent(g);
    g.drawImage(m_oImage, 0, 0, getWidth(), getHeight(), null);
  }

}
