package fortytwo.client;

import java.awt.Panel;
import java.awt.GridBagLayout;
import java.applet.Applet;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Color;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */

import fortytwo.network.MessageManager;

public class ClientGUI extends Applet {
  private boolean isStandalone = false;
  private GridBagLayout gbLayout_ClientGUI = new GridBagLayout();
  private Panel pane_Button;
  private Panel pane_ChatPanel;
  private Panel pane_Table;
  private Panel pane_News;
  private Panel pane_Banner;
  public MessageManager manager;

  //Get a parameter value
  public String getParameter(String key, String def) {
    return isStandalone ? System.getProperty(key, def) :
      (getParameter(key) != null ? getParameter(key) : def);
  }

  //Construct the applet
  public ClientGUI() {
  }

  //Initialize the applet
  public void init() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  //Component initialization
  private void jbInit() throws Exception {
    this.setBackground(new Color(176, 232, 40));
    this.setEnabled(true);
    this.setFont(new java.awt.Font("MS Sans Serif", 0, 11));
    this.setLayout(gbLayout_ClientGUI);
    this.setSize(600, 450);
    pane_Button = new ButtonPanel();
    pane_Table = new TablePanel();
    pane_ChatPanel = new ChatPanel();
    pane_News = new NewsPanel();
    pane_Banner = new BannerPanel();
    pane_Button.setBackground(new Color(176, 232, 40));
    pane_ChatPanel.setBackground(new Color(176, 232, 40));
    pane_News.setBackground(new Color(176, 232, 40));
    pane_Banner.setBackground(new Color(176, 232, 40));
    pane_Table.setBackground(new Color(172, 232, 40));
    this.add(pane_Button,       new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTHEAST, GridBagConstraints.NONE, new Insets(4, 4, 4, 4), 2, 2));
    this.add(pane_Table,       new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0
            ,GridBagConstraints.NORTHWEST, GridBagConstraints.NONE, new Insets(4, 4, 4, 4), 2, 2));
    this.add(pane_News,     new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTHWEST, GridBagConstraints.NONE, new Insets(4, 4, 4, 4), 2, 2));
    this.add(pane_Banner,      new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.NORTH, GridBagConstraints.NONE, new Insets(4, 4, 4, 4), 2, 2));
    this.add(pane_ChatPanel,      new GridBagConstraints(1, 1, 2, 2, 0.0, 0.0
            ,GridBagConstraints.SOUTH, GridBagConstraints.NONE, new Insets(4, 4, 4, 4), 2, 2));
  }

  //Start the applet
  public void start() {
    // connect to the server

  }

  //Stop the applet
  public void stop() {
    // disconnect from the server
    ClientMessageManager.getInstance().disconnect();
  }

  //Destroy the applet
  public void destroy() {
    stop();

  }

  //Get Applet information
  public String getAppletInfo() {
    return "Applet Information";
  }

  //Get parameter info
  public String[][] getParameterInfo() {
    return null;
  }
}
