package fortytwo.client;

/**
 * <p>Title: Forty Two Unlimited</p>
 * <p>Description: Texas Forty Two Game</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: 42Unlimited</p>
 * @author Nathaniel Normandin
 * @version 0.00.01
 */

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JOptionPane;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import fortytwo.network.*;

public class ButtonPanel extends Panel implements ButtonListener {
  String username = "";
  String password = "";
  JButton jButton_Options = new JButton();
  JButton jButton_Logoff = new JButton();
  JButton jButton_Login = new JButton();
  GridLayout gLayout_ButtonPanel = new GridLayout();

  public ButtonPanel() {
    ClientMessageManager.getInstance().addButtonListener(this);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  public void welcomePlayerReceived( WelcomePlayer welcomePlayer ) {
    jButton_Login.setEnabled(false);
    jButton_Logoff.setEnabled(true);
    ///////////////////
    // Once Options are implemented, let it become enabled
    //
    // jButton_Options.setEnabled(true);
    //////////////////

  }

  public void disconnectReceived() {
    jButton_Login.setEnabled(true);
    jButton_Logoff.setEnabled(false);
    jButton_Options.setEnabled(false);
  }

  private void jbInit() throws Exception {
    jButton_Options.setEnabled(false);
    jButton_Options.setText("Options");
    this.setLayout(gLayout_ButtonPanel);
    this.setSize(100, 125);
    jButton_Logoff.setEnabled(false);
    jButton_Logoff.setText("Log Off");
    jButton_Logoff.addActionListener( new LogoffListener( jButton_Logoff ) );
    jButton_Login.setText("Log In");
    jButton_Login.addActionListener( new LoginListener() );
    gLayout_ButtonPanel.setHgap(2);
    gLayout_ButtonPanel.setRows(3);
    gLayout_ButtonPanel.setVgap(2);
    this.add(jButton_Options, null);
    this.add(jButton_Login, null);
    this.add(jButton_Logoff, null);
  }

  private class LoginListener implements ActionListener {

    public void actionPerformed( ActionEvent event ) {
      new LoginJDialog();
    }

  }

  private class LogoffListener implements ActionListener {
    private JButton jButton_Logoff;
    public LogoffListener ( JButton button ) {
      jButton_Logoff = button;
    }
    public void actionPerformed( ActionEvent event ) {
      int userClicked = JOptionPane.showConfirmDialog( jButton_Logoff, "Are you sure you want to log off?",
          "Logoff?", JOptionPane.OK_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE );
      if ( userClicked == JOptionPane.OK_OPTION )
        // if ok is clicked send a disconnect message and close the socket.
        ClientMessageManager.getInstance().disconnect();
      else if ( userClicked == JOptionPane.CANCEL_OPTION ) {
        // if cancel is clicked do nothing
      }

    }
  }

  private class LoginJDialog extends JDialog {
    JPanel jPanel_main = new JPanel();
    JLabel jLabel_Username = new JLabel();
    JLabel jLabel_Password = new JLabel();
    JTextField jTF_Username = new JTextField();
    JPasswordField jPF_Password = new JPasswordField();
    JButton jButton_ok = new JButton();
    JButton jButton_cancel = new JButton();

    public LoginJDialog( Frame frame , String title , boolean modal )
    {
      super( frame , title , modal );
      try
      {
        jbInit();
        pack();
      }
      catch ( Exception ex )
      {
        ex.printStackTrace();
      }
    }

    public LoginJDialog()
    {
      this( null , "42Unlimited Login" , false );
      this.setLocationRelativeTo(jButton_Login);
    }

    public void jbInit() throws Exception {
      GridLayout layout = new GridLayout(  );
      layout.setHgap(6);
      layout.setRows(3);
      layout.setVgap(6);
      jPanel_main.setLayout(layout);
      jPanel_main.setSize(400, 400);

      jLabel_Username.setText( "Username: " );

      jLabel_Password.setText( "Password: " );

      jTF_Username.setSize(75, 14);

      jPF_Password.setSize(75, 14);

      jButton_ok.setText( "Login" );
      jButton_ok.addActionListener( new jButton_ok_ActionListener(this) );

      jButton_cancel.setText( "Cancel" );
      jButton_cancel.addActionListener( new jButton_cancel_ActionListener() );

      jPanel_main.add(jLabel_Username);
      jPanel_main.add(jTF_Username);
      jPanel_main.add(jLabel_Password);
      jPanel_main.add(jPF_Password);
      jPanel_main.add(jButton_ok);
      jPanel_main.add(jButton_cancel);
      jPanel_main.setVisible(true);
      this.setContentPane(jPanel_main);
      this.setVisible(true);
    }

    public boolean validEntries() {
      username = jTF_Username.getText();
      password = jPF_Password.getText();

      if ( username.length() < 2 ) {
        JOptionPane.showMessageDialog(this, "Please insert a valid username.", "Invalid Username", JOptionPane.ERROR_MESSAGE);
        return false;
      }
      else if ( password.length() < 2 ) {
        JOptionPane.showMessageDialog(this, "Please insert a valid password.", "Invalid Password", JOptionPane.ERROR_MESSAGE);
        return false;
      }
      return true;
    }

    public void disposeLoginDialog() {
      this.dispose();
    }

    public class jButton_ok_ActionListener implements ActionListener {
      JDialog adaptee;
      public jButton_ok_ActionListener ( JDialog tempAdaptee ) {
        adaptee = tempAdaptee;
      }
      public void actionPerformed ( ActionEvent event ) {
        if ( validEntries() ) {
          // Send Login information
          ClientMessageManager messageManager = ClientMessageManager.getInstance();
          if ( !messageManager.isConnected() )
            messageManager.connect( );
          if ( messageManager.isConnected() ) {
            if ( !messageManager.isLoggedIn() ) {
              messageManager.playerLogin(username, password);
              messageManager.setUsername(username);
              disposeLoginDialog();
            }
            else {
              JOptionPane.showMessageDialog( adaptee, "You are already logged in!", "Error",
                                             JOptionPane.ERROR_MESSAGE );
            }
          }
        }
      }
    }

    public class jButton_cancel_ActionListener implements ActionListener {

      public void actionPerformed ( ActionEvent event ) {
        disposeLoginDialog();
      }

    }
  }

}
