#!/usr/bin/perl
# Include required Perl modules
use CGI;
use DBI;
use CGI::Carp qw( fatalsToBrowser );

# Establish a handle to the MySQL database
my $db_handler = DBI->connect("DBI:mysql:test:localhost","mysql","");

# Main routine--starts by retrieving data passed to the program from the previous web page
$query=new CGI;
$UserNo=$query->param('UserNo');
$NNo=$query->param('NNo');
$FromMonth=$query->param('FromMonth');
$FromDay=$query->param('FromDay');
$FromYear=$query->param('FromYear');
$FromTime=$query->param('FromTime');
$ToMonth=$query->param('ToMonth');
$ToDay=$query->param('ToDay');
$ToYear=$query->param('ToYear');
$ToTime=$query->param('ToTime');
$Option=$query->param('Option');

# Begin generating HTML
print $query->header;
&GenerateTopOfPage;
if ($Option eq "Insert")
  {
    &InsertEntry;
  }
else
  {
    &DeleteEntry;
  }
&GenerateClosingTags;

# Start of sub-programs
sub GenerateTopOfPage
  {
    # Begin generating HTML code
    print $query->header;
    print "<HTML>\n";
    print "  <HEAD>\n";
    print "    <TITLE>\n";
    print "      Cumulogranite Flying Club--Aircraft Schedule\n";
    print "    </TITLE>\n";
    print "  </HEAD>\n";
    print "  <BODY BACKGROUND=\"/CS470/Pulse.gif\" BGPROPERTIES=\"FIXED\">\n";
    print "    <DIV ALIGN=\"CENTER\">\n";
    print "      <IMG SRC=\"/CS470/Logo.gif\" WIDTH=384 HEIGHT=54>\n";
    print "      <BR>\n";
    print "      <FONT FACE=\"Tahoma\" COLOR=\"WHITE\">\n";
    if ($Option eq "Insert")
      {
        # If the user is creating a new schedule entry...
        print "        Please wait--Inserting schedule entry\n";
        print "        <BR>\n";
        print "        <BR>\n";
      }
    else
      {
        # If the user is deleting a schedule entry
        print "        Please wait--Deleting Schedule Entry\n";
        print "        <BR>\n";
        print "        <BR>\n";
      }
  }

sub InsertEntry
  {
    # Adds a schedule entry to the MySQL database and informs the user that this has been done
    my $err=0;
    $FromMonth=substr("0$FromMonth", -2);
    $FromDay=substr("0$FromDay", -2);
    $FromTime=substr("0$FromTime", -5);
    $From="$FromYear-$FromMonth-$FromDay $FromTime";

    $ToMonth=substr("0$ToMonth", -2);
    $ToDay=substr("0$ToDay", -2);
    $ToTime=substr("0$ToTime", -5);
    $To="$ToYear-$ToMonth-$ToDay $ToTime";
    
    # See if there is already an entry for this Member Number/FromDate/ToDate
    $sql="Select MemberNo from Schedule where ((MemberNo = $UserNo) and (((ScdFrom >= \"$From\") and (ScdFrom < \"$To\")) or ((ScdTo > \"$From\") and (ScdTo <= \"$To\")) or ((ScdFrom < \"$From\") and (ScdTo > \"$To\"))))";
    $statement_handler=$db_handler->prepare($sql);
    if (!defined $statement_handler)
      {
        die "Cannot connect to database--exiting.\n";
      }
    else
      {
        $statement_handler->execute;
      }
    $MemberNo=0;
    ($MemberNo) = $statement_handler->fetchrow();
    if ($MemberNo == $UserNo)
      {
        # Print an error message is the user has already created an entry at this time
        print "        You are already scheduled to fly between $From and $To.\n";
        print "        <BR>\n";
        print "        No changes have been made to the flight schedule.\n";
        print "        <BR>\n";
        $err=1;
      }
    $statement_handler->finish;

    #See if there is already an entry for this N-Number/FromDate/ToDate
    $sql="Select MemberNo from Schedule where ((NNo=\"$NNo\") and (((ScdFrom >= \"$From\") and (ScdFrom < \"$To\")) or ((ScdTo > \"$From\") and (ScdTo <= \"$To\")) or ((ScdFrom < \"$From\") and (ScdTo > \"$To\"))))";
    $statement_handler=$db_handler->prepare($sql);
    if (!defined $statement_handler)
      {
        die "Cannot connect to database--exiting.\n";
      }
    else
      {
        $statement_handler->execute;
      }
    $MemberNo=0;
    ($MemberNo) = $statement_handler->fetchrow();
    if ($MemberNo != 0)
      {
        # Print an error message if the aircraft is already scheduled to fly at this time
        print "        $NNo is already scheduled to fly between $From and $To.\n";
        print "        <BR>\n";
        print "        No changes have been made to the flight schedule.\n";
        print "        <BR>\n";
        $err=1;
      }
    
    # Proceed to add a new entry if there are no conflicts
    if ($err==0)
      {
        # Add the schedule entry...
        $sql="Insert into Schedule values (\"$NNo\", \"$From\", \"$To\", $UserNo)";
        $statement_handler=$db_handler->prepare($sql);
        if (!defined $statement_handler)
          {
            die "Cannot connect to database--exiting.\n";
          }
        else
          {
            $statement_handler->execute;
          }
        $statement_handler->finish;
        # ...and inform the user that the entry has been added.
        print "        Done!\n";
      }
    $db_handler->disconnect;
  }

sub DeleteEntry
  {
    # Remove a schedule entry from the database and inform the user that this has been done
    $FromMonth=substr("0$FromMonth", -2);
    $FromDay=substr("0$FromDay", -2);
    $FromTime=substr("0$FromTime", -5);
    $From="$FromYear-$FromMonth-$FromDay $FromTime";

    $ToMonth=substr("0$ToMonth", -2);
    $ToDay=substr("0$ToDay", -2);
    $ToTime=substr("0$ToTime", -5);
    $To="$ToYear-$ToMonth-$ToDay $ToTime";

    # Verify that the entry exists
    $sql="Select MemberNo from Schedule where ((MemberNo=$UserNo) and (ScdFrom=\"$From\") and (ScdTo=\"$To\") and (NNo=\"$NNo\"))";
    $statement_handler=$db_handler->prepare($sql);
    if (!defined $statement_handler)
      {
        die "Cannot connect to database--exiting.\n";
      }
    else
      {
        $statement_handler->execute;
      }
    $MemberNo=0;
    ($MemberNo) = $statement_handler->fetchrow();
    if ($MemberNo == 0)
      {
        # If there is no entry for the specified Member, N-Number, Date and Times, inform the user
        print "        Either there is no schedule entry for $NNo between $From and $To, or this entry is reserved by another user.\n";
        print "        <BR>\n";
        print "        No changes have been made to the flight schedule.\n";
        print "        <BR>\n";
      }
    else
      {
        # Otherwise, remove the entry from the database
        $sql="Delete from Schedule where ((MemberNo=$UserNo) and (ScdFrom=\"$From\") and (ScdTo=\"$To\") and (NNo=\"$NNo\"))";
        $statement_handler=$db_handler->prepare($sql);
        $statement_handler->execute;
      }
    $statement_handler->finish;
  }

sub GenerateClosingTags
  {
    # Generate the HTML to neatly close the web page
    print "        <A HREF=\"/cgi-bin/BrowseSchedule.pl\">\n";
    print "          Return to Flight Schedule.\n";
    print "        </A>\n";
    print "      </FONT>\n";
    print "    </DIV>\n";
    print "  </BODY>\n";
    print "</HTML>\n";
  }
