#!/usr/bin/perl
# Setup for cookies and MySQL access
  use CGI;
  use DBI;
  use CGI::Carp  qw( fatalsToBrowser );
  $query=new CGI;
  my $db_handler=DBI->connect("DBI:mysql:test:localhost","mysql","");

#Main
  print $query->header;
  &PrintHeadings;
  if ($query->cookie('Admin'))
    {
      print $query->start_html(-title=>"Admin Tools--Manage Schedule Entries");
      $AdminNo=$query->cookie('Admin');

      #Retrieve and process cgi information
      $action=$query->param('action');
      if ($action eq "")
        {
          &PrintMenu;
        }
      elsif ($action eq "View")
        {
          $error=0;
          &GetCgiData;
          &ValidateCgiData;
          if ($error==0)
            {
              &PrintSchedule;
            }
          else
            {
              &PrintValidationError;
            }
        }
      elsif ($action eq "Delete")
        {
          $error=0;
          &GetCgiData;
          &ValidateCgiData;
          if ($error==0)
            {
              &DeleteEntry;
              if ($error==0)
                {
                  &PrintComplete;
                }
              else
                {
                  &PrintUpdateError;
                }
            }
          else
            {
              &PrintValidationError;
            }
        }
      elsif ($action eq "Edit")
        {
          $error=0;
          &GetCgiData;
          &ValidateCgiData;
          if ($error==0)
            {
              &PrintAddEditEntry;
            }
          else
            {
              &PrintValidationError;
            }
        }
      elsif ($action eq "Add")
        {
          &GetCgiData; #Sets CGI data rather than obtains it, thus no following ValidateCgiData func.
          &PrintAddEditEntry;
        }
      elsif ($action eq "Insert")
        {
          $error=0;
          &GetCgiData;
          &ValidateCgiData;
          if ($error==0)
            {
              &InsertEntry;
              if ($error==0)
                {
                  &PrintComplete;
                }
              else
                {
                  &PrintUpdateError;
                }
            }
          else
            {
              &PrintValidationError;
            }
        }
      elsif ($action eq "Update")
        {
          $error=0;
          &GetCgiData;
          &ValidateCgiData;
          if ($error==0)
            {
              &UpdateEntry;
              if ($error==0)
                {
                  &PrintComplete;
                }
              else
                {
                  &PrintUpdateError;
                }
            }
          else
            {
              &PrintValidationError;
            }
        }
      else
        {
          #Should never happen--indicates probable hack attempt with 3rd party CGI script
          &PrintCGIError;
        }
      &PrintClosingTags;
      $db_handler->disconnect;
    }
  else
    {
      &PrintAuthorizationError;
    }

sub PrintHeadings
  {
    print "<HTML>\n";
    print "  <HEAD>\n";
    print "    <TITLE>\n";
    print "      Admin Tools--Manage Schedule\n";
    print "    </TITLE>\n";
    print "  </HEAD>\n";
    print "  <BODY BACKGROUND=\"/AdminTools/stone.gif\">\n";
    print "    <DIV ALIGN=\"CENTER\">\n";
    print "      <IMG SRC=\"/AdminTools/Logo.gif\" WIDTH=\"384\" HEIGHT=\"54\">\n";
    print "      <BR>\n";
    print "      <HR WIDTH=\"93%\" COLOR=\"GRAY\">\n";
    print "      <BR>\n";
    print "      <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=4>\n";
  }

sub PrintMenu
  {
    print "        Manage Schedule\n";
    print "      </FONT>\n";
    print "      <TABLE BORDER=1 WIDTH=\"93%\">\n";
    print "        <TR>\n";
    print "          <TD>\n";
    print "            <DIV ALIGN=\"CENTER\">\n";
    print "              <FORM ACTION=\"/cgi-bin/AdminTools/ManageSchedule.pl\" METHOD=\"POST\">\n";
    print "                <TABLE BORDER=1 WIDTH=\"60%\">\n";
    print "                  <TR>\n";
    print "                    <TD ALIGN=\"RIGHT\" WIDTH=\"50%\">\n";
    print "                      <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=3>\n";
    print "                        Filter schedule by date \n";
    print "                      </FONT>\n";
    print "                    </TD>\n";
    print "                    <TD ALIGN=\"RIGHT\" WIDTH=\"30%\">\n";

    #Generate Month selection data
    print "                      <SELECT NAME=\"Month\">\n";
    my $month=(localtime)[4] + 1;
    my $day=(localtime)[3];
    print "                        <OPTION VALUE=\"$month\">$month\n";
    $i=0;
    while ($i < 12)
      {
        $i++;
        print "                        <OPTION VALUE=\"$i\">$i\n";
      }
    print "                      </SELECT>\n";

    # Generate Day selection data
    print "                      <SELECT NAME=\"Day\">\n";
    print "                        <OPTION VALUE=\"$day\">$day\n";
    $i=0;
    while ($i < 31)
      {
        $i++;
        print "                        <OPTION VALUE=\"$i\">$i\n";
      }
    print "                      </SELECT>\n";

    # Generate Year selection data
    print "                      <SELECT NAME=\"Year\">\n";
    $year = (localtime)[5] + 1900;
    $i = 0;
    while ($i < 11)
      {
        print "                        <OPTION VALUE=\"$year\">$year \n";
        $i++;
        $year++;
      }

    print "                      </SELECT>\n";

    print "                    </TD>\n";
    print "                  </TR>\n";
    print "                  <TR>\n";
    print "                    <TD ALIGN=\"RIGHT\" WIDTH=\"50%\">\n";
    print "                      <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=3>\n";
    print "                        Filter schedule by N-Number\n";
    print "                      </FONT>\n";
    print "                    </TD>\n";
    print "                    <TD ALIGN=\"RIGHT\" WIDTH=\"30%\">\n";
    print "                      <SELECT NAME=\"NNo\">n";
    print "                        <OPTION VALUE=\"%\">All\n";
    $sql="Select NNo from AircraftData order by NNo asc";
    &OpenDBHandle;
    while (($NNo)=$statement_handler->fetchrow())
      {
        print "                        <OPTION VALUE=\"$NNo%\">$NNo\n";
      }
    $statement_handler->finish;
    print "                      </SELECT>\n";
    print "                    </TD>\n";
    print "                  </TR>\n";
    print "                  <TR>\n";
    print "                    <TD ALIGN=\"RIGHT\" WIDTH=\"50%\">\n";
    print "                      <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=3>\n";
    print "                        Filter by aircraft make and model\n";
    print "                      </FONT>\n";
    print "                    </TD>\n";
    print "                    <TD ALIGN=\"RIGHT\" WIDTH=\"30%\">\n";
    print "                      <SELECT NAME=\"MakeModel\">n";
    print "                        <OPTION VALUE=\"%\">All\n";
    $sql="Select distinct MakeModel from AircraftData order by MakeModel asc";
    &OpenDBHandle;
    while (($MakeModel)=$statement_handler->fetchrow())
      {
        print "                        <OPTION VALUE=\"$MakeModel%\">$MakeModel\n";
      }
    $statement_handler->finish;
    print "                      </SELECT>\n";
    print "                    </TD>\n";
    print "                  </TR>\n";
    print "                  <TR>\n";
    print "                    <TD ALIGN=\"Right\" WIDTH=\"50%\">\n";
    print "                      <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=3>\n";
    print "                        Filter schedule by Member\n";
    print "                      </FONT>\n";
    print "                    </TD>\n";
    print "                    <TD ALIGN=\"RIGHT\" WIDTH=\"30%\">\n";
    print "                      <SELECT NAME=\"MemberNo\">\n";
    print "                        <OPTION VALUE=0>All\n";
    $sql="Select MemberNo, LastName, FirstName from Members order by LastName, FirstName asc";
    &OpenDBHandle;
    while (($MemberNo, $LastName, $FirstName)=$statement_handler->fetchrow())
      {
        print "                        <OPTION VALUE=$MemberNo>$LastName, $FirstName\n";
      }
    $statement_handler->finish;
    print "                      </SELECT>\n";
    print "                    </TD>\n";
    print "                  </TR>\n";
    print "                </TABLE>\n";
    print "                <TABLE BORDER=0 WIDTH=\"60%\">\n";
    print "                  <TR>\n";
    print "                    <TD ALIGN=\"RIGHT\" WIDTH=\"80%\">\n";
    print "                      <INPUT TYPE=\"reset\" NAME=\"reset\">\n";
    print "                    </TD>\n";
    print "                    <TD ALIGN=\"LEFT\" WIDTH=\"20%\">\n";
    print "                      <INPUT TYPE=\"submit\" NAME=\"submit\">\n";
    print "                      <INPUT TYPE=\"hidden\" NAME=\"action\" VALUE=\"View\">\n";
    print "                    </TD>\n";
    print "                  </TR>\n";
    print "                </TABLE>\n";
    print "              </FORM>\n";
    print "            </DIV>\n";
    print "          </TD>\n";
    print "        </TR>\n";
    print "      </TABLE>\n";
  }

sub PrintSchedule
  {
    #Prints the results of the View Schedule by Date query
    print "        Manage Schedule\n";
    print "      </FONT>\n";
    print "      <TABLE BORDER=1 WIDTH=\"93%\">\n";
    print "        <TR>\n";
    print "          <TD ALIGN=\"CENTER\">\n";
    print "            <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "              <B>\n";
    print "                N-Number\n";
    print "              </B>\n";
    print "            </FONT>\n";
    print "          </TD>\n";
    print "          <TD ALIGN=\"CENTER\">\n";
    print "            <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "              <B>\n";
    print "                Make & Model\n";
    print "              </B>\n";
    print "            </FONT>\n";
    print "          </TD>\n";
    print "          <TD ALIGN=\"CENTER\">\n";
    print "            <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "              <B>\n";
    print "                Scheduled From:\n";
    print "              </B>\n";
    print "            </FONT>\n";
    print "          </TD>\n";
    print "          <TD ALIGN=\"CENTER\">\n";
    print "            <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "              <B>\n";
    print "                Scheduled To:\n";
    print "              </B>\n";
    print "            </FONT>\n";
    print "          </TD>\n";
    print "          <TD ALIGN=\"CENTER\">\n";
    print "            <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "              <B>\n";
    print "                Rented by:\n";
    print "              </B>\n";
    print "            </FONT>\n";
    print "          </TD>\n";
    print "          <TD ALIGN=\"CENTER\">\n";
    print "            <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "              <B>\n";
    print "                Action:\n";
    print "              </B>\n";
    print "            </FONT>\n";
    print "          </TD>\n";
    print "        </TR>\n";
    $sql="Select Schedule.NNo, MakeModel, ScdFrom, ScdTo, FirstName, LastName, Schedule.MemberNo from Schedule, AircraftData, Members where ((left(ScdFrom, 10) <= \"$Date\") and (left(ScdTo, 10) >= \"$Date\") and (Schedule.NNo like \"$NNo\") and (Schedule.NNo=AircraftData.NNo) and (Schedule.MemberNo=Members.MemberNo)) order by left(ScdFrom, 10), MakeModel, Schedule.NNo, ScdFrom";
    $statement_handler=$db_handler->prepare($sql);

    if (!defined $statement_handler)
      {
        die "Cannot connect to database--exiting.\n";
      }
    else
      {
        $statement_handler->execute;
      }

    while (($NNo, $MakeModel, $ScdFrom, $ScdTo, $FirstName, $LastName, $MemberNo) = $statement_handler->fetchrow())
      {
        $ScdTo=substr($ScdTo, 0, 16);
        $ScdFrom=substr($ScdFrom, 0, 16);
        print "        <TR>\n";
        print "          <TD ALIGN=\"CENTER\">\n";
        print "            <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
        print "              $NNo\n";
        print "            </FONT>\n";
        print "          </TD>\n";
        print "          <TD ALIGN=\"CENTER\">\n";
        print "            <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
        print "              $MakeModel\n";
        print "            </FONT>\n";
        print "          </TD>\n";
        print "          <TD ALIGN=\"CENTER\">\n";
        print "            <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
        print "              $ScdFrom\n";
        print "            </FONT>\n";
        print "          </TD>\n";
        print "          <TD ALIGN=\"CENTER\">\n";
        print "            <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
        print "              $ScdTo\n";
        print "            </FONT>\n";
        print "          </TD>\n";
        print "          <TD ALIGN=\"CENTER\">\n";
        print "            <FONT FACE=\"Tahoma\" COLOR=\"NAVY\" SIZE=2>\n";
        print "              $FirstName $LastName\n";
        print "            </FONT>\n";
        print "          </TD>\n";
        print "          <TD ALIGN=\"CENTER\">\n";
        print "            <TABLE BORDER=0 WIDTH=\"100%\">\n";
        print "              <TR>\n";
        print "                <TD ALIGN=\"CENTER\">\n";
        print "                  <BR>\n";
        print "                  <FORM ACTION=\"ManageSchedule.pl\">\n";
        print "                    <INPUT TYPE=\"hidden\" NAME=\"action\" VALUE=\"Delete\">\n";
        print "                    <INPUT TYPE=\"hidden\" NAME=\"NNo\" VALUE=\"$NNo\">\n";
        print "                    <INPUT TYPE=\"hidden\" NAME=\"MakeModel\" VALUE=\"$MakeModel\">\n";
        print "                    <INPUT TYPE=\"hidden\" NAME=\"ScdFrom\" VALUE=\"$ScdFrom\">\n";
        print "                    <INPUT TYPE=\"hidden\" NAME=\"ScdTo\" VALUE=\"$ScdTo\">\n";
        print "                    <INPUT TYPE=\"hidden\" NAME=\"MemberNo\" VALUE=$MemberNo>\n";
        print "                    <INPUT TYPE=\"submit\" VALUE=\"Delete\">\n";
        print "                  </FORM>\n";
        print "                </TD>\n";
        print "                <TD ALIGN=\"CENTER\">\n";
        print "                  <BR>\n";
        print "                  <FORM ACTION=\"ManageSchedule.pl\">\n";
        print "                    <INPUT TYPE=\"hidden\" NAME=\"action\" VALUE=\"Edit\">\n";
        print "                    <INPUT TYPE=\"hidden\" NAME=\"NNo\" VALUE=\"$NNo\">\n";
        print "                    <INPUT TYPE=\"hidden\" NAME=\"MakeModel\" VALUE=\"$MakeModel\">\n";
        print "                    <INPUT TYPE=\"hidden\" NAME=\"ScdFrom\" VALUE=\"$ScdFrom\">\n";
        print "                    <INPUT TYPE=\"hidden\" NAME=\"ScdTo\" VALUE=\"$ScdTo\">\n";
        print "                    <INPUT TYPE=\"hidden\" NAME=\"MemberNo\" VALUE=$MemberNo>\n";
        print "                    <INPUT TYPE=\"submit\" VALUE=\"Edit\">\n";
        print "                  </FORM>\n";
        print "                </TD>\n";
        print "              </TR>\n";
        print "            </TABLE>\n";
        print "          </TD>\n";
        print "        </TR>\n";
      }
    print "        <TR>\n";
    print "          <TD WIDTH=\"100%\" ALIGN=\"RIGHT\" COLSPAN=6>\n";
    print "            <FORM ACTION=\"ManageSchedule.pl\">\n";
    print "              <INPUT TYPE=\"hidden\" NAME=\"action\" VALUE=\"Add\">\n";
    print "              <INPUT TYPE=\"submit\" VALUE=\"Add New\">\n";
    print "            </FORM>\n";
    print "          </TD>\n";
    print "        </TR>\n";

    $statement_handler->finish;
    $db_handler->disconnect;
    print "      </TABLE>\n";

  }

sub PrintAddEditEntry
  {
    #Prints the HTML code to add or edit entries to/in the schedule
    if ($action eq "Edit")
      {
        #If this is an edit, save the old values to identify the Schedule entry that will be updated
        $OldMemberNo=$MemberNo;
        $OldNNo=$NNo;
        $OldScdFrom=$ScdFrom;
        $OldScdTo=$ScdTo;
      }
    print "        $action Schedule Entry\n";
    print "      </FONT>\n";
    print "      <FORM ACTION=\"ManageSchedule.pl\" METHOD=\"POST\">\n";
    print "        <TABLE BORDER=0 WIDTH=\"93%\">\n";
    print "          <TR>\n";
    print "            <TD ALIGN=\"LEFT\">\n";
    print "              <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                <B>\n";
    print "                  Rented by:\n";
    print "                </B>\n";
    print "                <SELECT NAME=\"MemberNo\">\n";
    if ($MemberNo > 0)
      {
        $sql="Select LastName, FirstNAme from Members where (MemberNo=$MemberNo)";
        &OpenDBHandle;
        ($LastName, $FirstName)=$statement_handler->fetchrow();
        $statement_handler->finish;
        print "                  <OPTION VALUE=\"$MemberNo\">$LastName, $FirstName\n";
      }
    $sql="Select MemberNo, LastName, FirstName from Members where (Grounded=0) order by LastName, FirstName asc";
    &OpenDBHandle;
    while (($MemberNo, $LastName, $FirstName)=$statement_handler->fetchrow())
      {
        print "                  <OPTION VALUE=\"$MemberNo\">$LastName, $FirstName\n";
      }
    $statement_handler->finish;
    print "                </SELECT>\n";
    print "              </FONT>\n";
    print "            </TD>\n";
    print "          </TR>\n";
    print "        </TABLE>\n";
    print "        <TABLE BORDER=1 WIDTH=\"93%\">\n";
    print "          <TR>\n";
    print "            <TD ALIGN=\"CENTER\">\n";
    print "              <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                <B>\n";
    print "                  Aircraft\n";
    print "                </B>\n";
    print "              </FONT>\n";
    print "            </TD>\n";
    print "            <TD ALIGN=\"CENTER\">\n";
    print "              <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                <B>\n";
    print "                  Scheduled From:\n";
    print "                </B>\n";
    print "              </FONT>\n";
    print "            </TD>\n";
    print "            <TD ALIGN=\"CENTER\">\n";
    print "              <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                <B>\n";
    print "                  Scheduled To:\n";
    print "                </B>\n";
    print "              </FONT>\n";
    print "            </TD>\n";
    print "          </TR>\n";
    print "          <TR>\n";
    print "            <TD ALIGN=\"CENTER\">\n";
    print "              <SELECT NAME=\"NNo\">\n";
    if ($action ne "Add")
      {
        #print a default value only if there is a default value to print
        print "                <OPTION VALUE=\"$NNo\">$NNo $MakeModel\n";
      }
    $sql="Select NNo, MakeModel from AircraftData where (Status=\"Up\") order by MakeModel, NNo asc";
    &OpenDBHandle;
    while (($NNo, $MakeModel)=$statement_handler->fetchrow())
      {
        print "                <OPTION VALUE=\"$NNo\">$NNo $MakeModel\n";
      }
    $statement_handler->finish;
    print "              </SELECT>\n";
    print "            </TD>\n";
    print "            <TD ALIGN=\"CENTER\">\n";
    print "              <SELECT NAME=\"FromYear\">\n";
    print "                <OPTION VALUE=\"$FromYear\">$FromYear\n";
    $year = (localtime)[5] + 1900;
    for ($i=0; $i<10; $i++)
      {
        $FromYear=$year + $i;
        print "                <OPTION VALUE=\"$FromYear\">$FromYear\n";
      }
    print "              </SELECT>\n";
    print "              <SELECT NAME=\"FromMonth\">\n";
    print "                <OPTION VALUE=\"$FromMonth\">$FromMonth\n";
    for ($i=1; $i<=12; $i++)
      {
        print "                <OPTION VALUE=\"$i\">$i\n";
      }
    print "              </SELECT>\n";
    print "              <SELECT NAME=\"FromDay\">\n";
    print "                <OPTION VALUE=\"$FromDay\">$FromDay\n";
    for ($i=1; $i<=31; $i++)
      {
        print "                <OPTION VALUE=\"$i\">$i\n";
      }
    print "              </SELECT>\n";
    print "              <SELECT NAME=\"FromTime\">\n";
    print "                <OPTION VALUE=\"$FromHour:$FromMin\">$FromHour:$FromMin\n";
    for ($i=0; $i<24; $i++)
      {
        print "                <OPTION VALUE=\"$i:00\">$i:00\n";
        print "                <OPTION VALUE=\"$i:30\">$i:30\n";
      }
    print "              </SELECT>\n";
    print "            </TD>\n";
    print "            <TD ALIGN=\"CENTER\">\n";
    print "              <SELECT NAME=\"ToYear\">\n";
    print "                <OPTION VALUE=\"$ToYear\">$ToYear\n";
    $year = (localtime)[5] + 1900;
    for ($i=0; $i<10; $i++)
      {
        $ToYear=$year + $i;
        print "                <OPTION VALUE=\"$ToYear\">$ToYear\n";
      }
    print "              </SELECT>\n";
    print "              <SELECT NAME=\"ToMonth\">\n";
    print "                <OPTION VALUE=\"$ToMonth\">$ToMonth\n";
    for ($i=1; $i<=12; $i++)
      {
        print "                <OPTION VALUE=\"$i\">$i\n";
      }
    print "              </SELECT>\n";
    print "              <SELECT NAME=\"ToDay\">\n";
    print "                <OPTION VALUE=\"$ToDay\">$ToDay\n";
    for ($i=1; $i<=31; $i++)
      {
        print "                <OPTION VALUE=\"$i\">$i\n";
      }
    print "              </SELECT>\n";
    print "              <SELECT NAME=\"ToTime\">\n";
    print "                <OPTION VALUE=\"$ToHour:$ToMin\">$ToHour:$ToMin\n";
    for ($i=0; $i<24; $i++)
      {
        print "                <OPTION VALUE=\"$i:00\">$i:00\n";
        print "                <OPTION VALUE=\"$i:30\">$i:30\n";
      }
    print "              </SELECT>\n";
    print "            </TD>\n";
    print "          </TR>\n";
    print "        </TABLE>\n";
    print "        <TABLE BORDER=1 WIDTH=\"93%\">\n";
    print "          <TR>\n";
    print "            <TD ALIGN=\"RIGHT\">\n";
    print "              <INPUT TYPE=\"reset\" VALUE=\"Reset\">\n";
    if ($action eq "Add")
      {
        print "              <INPUT TYPE=\"hidden\" NAME=\"action\" VALUE=\"Insert\">\n";
        print "              <INPUT TYPE=\"submit\" VALUE=\"Add Entry\">\n";
      }
    elsif ($action eq "Edit")
      {
        print "              <INPUT TYPE=\"hidden\" NAME=\"action\" VALUE=\"Update\">\n";
        print "              <INPUT TYPE=\"hidden\" NAME=\"OldMemberNo\" VALUE=\"$OldMemberNo\">\n";
        print "              <INPUT TYPE=\"hidden\" NAME=\"OldNNo\" VALUE=\"$OldNNo\">\n";
        print "              <INPUT TYPE=\"hidden\" NAME=\"OldScdFrom\" VALUE=\"$OldScdFrom\">\n";
        print "              <INPUT TYPE=\"hidden\" NAME=\"OldScdTo\" VALUE=\"$OldScdTo\">\n";
        print "              <INPUT TYPE=\"submit\" VALUE=\"Accept Changes\">\n";
      }
    print "            </TD>\n";
    print "          </TR>\n";
    print "        </TABLE>\n";
    print "      </FORM>\n";
  }
    

sub DeleteEntry
  {
    #Deletes an entry from the Schedule
    #First, verify that the entry exists
    $error=0;
    $sql="Select MemberNo from Schedule where ((NNo=\"$NNo\") and (ScdFrom=\"$ScdFrom\") and (ScdTo=\"$ScdTo\") and (MemberNo=$MemberNo))";
    &OpenDBHandle;
    ($error)=$statement_handler->fetchrow();
    $statement_handler->finish;
    
    if ($error > 0)
      {
        #The entry exists in the database, so delete it.
        $error=0;
        $sql="Delete from Schedule where ((NNo=\"$NNo\") and (ScdFrom=\"$ScdFrom\") and (ScdTo=\"$ScdTo\") and (MemberNo=$MemberNo))";
        &OpenDBHandle;
        $statement_handler=$db_handler->prepare($sql);
        $statement_handler->finish;
      }
    else
      {
        $error=1;
      }
  }

sub InsertEntry
  {
    #Insert new schedule entry
    #First, verify that no conflicting entries exist
    $error=0;
    $sql="Select MemberNo from Schedule where (((MemberNo=$MemberNo) or (NNo=\"$NNo\")) and (((ScdFrom >= \"$ScdFrom\") and (ScdFrom < \"$ScdTo\")) or ((ScdTo > \"$ScdFrom\") and (ScdTo <= \"$ScdTo\")) or ((ScdFrom < \"$ScdFrom\") and (ScdTo > \"$ScdTo\"))))";
    &OpenDBHandle;
    ($error)=$statement_handler->fetchrow();
    $statement_handler->finish;
    
    if ($error==0)
      {
        #No conflicting entry exists in the database, so insert a new entry.
        $error=0;
        $sql="Insert into Schedule values (\"$NNo\", \"$ScdFrom\", \"$ScdTo\", $MemberNo)";
        &OpenDBHandle;
        $statement_handler=$db_handler->prepare($sql);
        $statement_handler->finish;
      }
    else
      {
        $error=1;
      }
  }

sub UpdateEntry
  {
    #Update new schedule entry
    #First, delete the old entry
    $sql="Delete from Schedule where ((MemberNo=$OldMemberNo) and (NNo=\"$OldNNo\") and (ScdFrom=\"$OldScdFrom\") and (ScdTo=\"$OldScdTo\"))";
    &OpenDBHandle;
    $statement_handler=$db_handler->prepare($sql);
    $statement_handler->finish;

    #Then check for conflicting entries
    $error=0;
    $sql="Select MemberNo from Schedule where (((MemberNo=$MemberNo) or (NNo=\"$NNo\")) and (((ScdFrom >= \"$ScdFrom\") and (ScdFrom < \"$ScdTo\")) or ((ScdTo > \"$ScdFrom\") and (ScdTo <= \"$ScdTo\")) or ((ScdFrom < \"$ScdFrom\") and (ScdTo > \"$ScdTo\"))))";
    &OpenDBHandle;
    ($error)=$statement_handler->fetchrow();
    $statement_handler->finish;
    
    if ($error==0)
      {
        #No conflicting entry exists in the database, so insert a new entry.
        $error=0;
        $sql="Insert into Schedule values (\"$NNo\", \"$ScdFrom\", \"$ScdTo\", $MemberNo)";
        &OpenDBHandle;
        $statement_handler=$db_handler->prepare($sql);
        $statement_handler->finish;
      }
    else
      {
        #Replace the deleted entry-would be much easier if MySQL supported transactions...
        $sql="Insert into Schedule values (\"$NNo\", \"$ScdFrom\", \"$ScdTo\", $MemberNo)";
        &OpenDBHandle;
        $statement_handler=$db_handler->prepare($sql);
        $statement_handler->finish;
        $error=1;
      }
  }


sub GetCgiData
  {
    #Retrieve data passed to the program from the web page
    if ($action eq "View")
      {
        $Year=$query->param('Year');
        $Month=substr(("0".$query->param('Month')), -2);
        $Day=substr(("0".$query->param('Day')), -2);
        $Date=$Year."-".$Month."-".$Day;
        $NNo=$query->param('NNo');
        $MakeModel=$query->param('MakeModel');
        $MemberNo=$query->param('MemberNo');
      }
    elsif ($action eq "Delete")
      {
        $NNo=$query->param('NNo');
        $MakeModel=$query->param('MakeModel');
        $ScdFrom=$query->param('ScdFrom');
        $ScdTo=$query->param('ScdTo');
        $MemberNo=$query->param('MemberNo');
      }
    elsif ($action eq "Insert")
      {
        $NNo=$query->param('NNo');
        $MemberNo=$query->param('MemberNo');
        $FromYear=$query->param('FromYear');
        $FromMonth=$query->param('FromMonth');
        $FromMonth=substr("0$FromMonth", -2, 2);
        $FromDay=$query->param('FromDay');
        $FromDay=substr("0$FromDay", -2, 2);
        $FromTime=$query->param('FromTime');
        $ScdFrom="$FromYear-$FromMonth-$FromDay $FromTime";
        $ToYear=$query->param('ToYear');
        $ToMonth=$query->param('ToMonth');
        $ToMonth=substr("0$ToMonth", -2, 2);
        $ToDay=$query->param('ToDay');
        $ToDay=substr("0$ToDay", -2, 2);
        $ToTime=$query->param('ToTime');
        $ScdTo="$ToYear-$ToMonth-$ToDay $ToTime";
      }
    elsif ($action eq "Update")
      {
        $OldNNo=$query->param('OldNNo');
        $OldMemberNo=$query->param('OldMemberNo');
        $OldScdFrom=$query->param('OldScdFrom');
        $OldScdTo=$query->param('OldScdTo');
        $NNo=$query->param('NNo');
        $MemberNo=$query->param('MemberNo');
        $FromYear=$query->param('FromYear');
        $FromMonth=$query->param('FromMonth');
        $FromMonth=substr("0$FromMonth", -2, 2);
        $FromDay=$query->param('FromDay');
        $FromDay=substr("0$FromDay", -2, 2);
        $FromTime=$query->param('FromTime');
        $ScdFrom="$FromYear-$FromMonth-$FromDay $FromTime";
        $ToYear=$query->param('ToYear');
        $ToMonth=$query->param('ToMonth');
        $ToMonth=substr("0$ToMonth", -2, 2);
        $ToDay=$query->param('ToDay');
        $ToDay=substr("0$ToDay", -2, 2);
        $ToTime=$query->param('ToTime');
        $ScdTo="$ToYear-$ToMonth-$ToDay $ToTime";
      }
    elsif ($action eq "Edit")
      {
        $NNo=$query->param('NNo');
        $MakeModel=$query->param('MakeModel');
        $ScdFrom=$query->param('ScdFrom');
        $ScdTo=$query->param('ScdTo');
        $MemberNo=$query->param('MemberNo');
        $FromYear=substr("$ScdFrom", 0, 4);
        $FromMonth=substr("$ScdFrom", 5, 2);
        $FromDay=substr("$ScdFrom", 8, 2);
        $FromHour=substr("$ScdFrom", 11, 2);
        $FromMin=substr("$ScdFrom", 14,2);
        $ToYear=substr("$ScdTo", 0, 4);
        $ToMonth=substr("$ScdTo", 5, 2);
        $ToDay=substr("$ScdTo", 8, 2);
        $ToHour=substr("$ScdTo", 11, 2);
        $ToMin=substr("$ScdTo", 14,2);
      }
    elsif ($action eq "Add")
      {
        #Technically, this is a SetCgiDataDefaults rather than GetCgiData, but...
        $NNo="";
        $MakeModel="";
        $FromYear = (localtime)[5] + 1900;
        $ToYear = (localtime)[5] + 1900;
        $FromMonth = (localtime)[4] + 1;
        $FromMonth = substr("0$FromMonth", -2, 2);
        $ToMonth = substr("0$FromMonth", -2, 2);
        $FromDay = (localtime)[3];
        $FromDay = substr("0$FromDay", -2, 2);
        $ToDay = substr("0$FromDay", -2, 2);
        $FromHour = (localtime)[2];
        $FromHour = substr("0$FromHour", -2, 2);
        $ToHour = substr("0$FromHour", -2, 2);
        $FromMin = (localtime)[1];
        $FromMin = substr("0$FromMin", -2, 2);
        if ($FromMin lt "30")
          {
            $FromMin="00";
          }
        else
          {
            $FromMin="30";
          }
        $ToMin = $FromMin;
        $ScdFrom="$year-$month-$day $hour:$min";
        $ScdTo="$year-$month-$day $hour:$min";
        $MemberNo=0;
      }
  }

sub ValidateCgiData
  {
    #Insert validation scripts here
  }

sub PrintValidationError
  {
    print "        I'm sorry--the data returned by the CGI script was not valid.  Please return to the\n";
    print "        <A HREF=\"/cgi-bin/AdminTools/ManageSchedule.pl\">\n";
    print "          Schedule Management\n";
    print "        </A>\n";
    print "        page, and try again.\n";
    print "        <BR>\n";
  }

sub PrintUpdateError
  {
    if ($action eq "Add")
      {
        print "        Error--unable to insert the data into the database.  Verify that the user does exist in the Members table and that the user does not already exist in the CFIs table.\n";
      }
    elsif ($action eq "Remove")
      {
        print "        Error--unable to remove the data from the database.  Verify that the user already exists in the CFIs table.\n";
      }
    print "        <BR>\n";
  }

sub PrintComplete
  {
    print "        Done!  Changes to the database have been completed.\n";
    print "        <BR>\n";
  }

sub PrintAuthorizationError
  {
    print "        I'm sorry--this page is restricted to CFC Administrators, only.\n";
    print "        <BR>\n";
    print "        <BR>\n";
    print "        Please\n";
    print "        <A HREF=\"/AdminTools/Login.html\">\n";
    print "          sign in\n";
    print "        </A>\n";
    print "        to access this page.\n";
    print "        <BR>\n";
    print "      </FONT>\n";
    print "      <BR>\n";
    print "      <BR>\n";
    print "      <BR>\n";
    print "      <FONT FACE=\"TAHOMA\" SIZE=1 COLOR=\"NAVY\">\n";
    print "        Copyright &#169; 2002 Cumulogranite Flying Club\n";
    print "        <BR>\n";
    print "        <A HREF=\"/CS470/Merrill.gif\">\n";
    print "          1234 Merrill Field Dr.\n";
    print "        </A>\n";
    print "        , Anchorage, AK 99501\n";
    print "      </FONT>\n";
    print "    </DIV>\n";
    print "  </BODY>\n";
    print "</HTML>\n";
  }

sub PrintClosingTags
  {
    #Print common closing elements
    print "      <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=3>\n";
    print "        <BR>\n";
    print "        Return to \n";
    print "        <A HREF=\"/cgi-bin/AdminTools/Home.pl\">\n";
    print "          Admin Tools main menu\n";
    print "        </A>\n";
    print "        <BR>\n";
    print "        or\n";
    print "        <BR>\n";
    print "        <A HREF=\"/cgi-bin/AdminTools/ManageSchedule.pl\">\n";
    print "          Schedule Management menu.\n";
    print "        </A>\n";
    print "      </FONT>\n";
    print "      <BR>\n";
    print "      <BR>\n";
    print "      <BR>\n";
    print "      <FONT FACE=\"TAHOMA\" SIZE=1 COLOR=\"NAVY\">\n";
    print "        Copyright &#169; 2002 Cumulogranite Flying Club\n";
    print "        <BR>\n";
    print "        <A HREF=\"/CS470/Merrill.gif\">\n";
    print "          1234 Merrill Field Dr.\n";
    print "        </A>\n";
    print "        , Anchorage, AK 99501\n";
    print "      </FONT>\n";
    print "    </DIV>\n";
    print "  </BODY>\n";
    print "</HTML>\n";
  }

sub PrintCGIError
  {
    #Error Message to Hacker routine
    print "        Error--you should not have been able to reach this subroutine unless you are creating your
own scripts to access the database.  Please be advised that this server is for use by authorized users, and ha
cking attempts may be considered a violation of the law.  This server logs all incoming connections, and conti
nued abuse will result in notification to the proper authorities, to include your ISP, the FBI and local law e
nforcement, as applicable.\n";
    print "<BR>\n";
    print "Please LEAVE NOW!\n";
    print "<BR>\n";
    print "<BR>\n";
  }


sub OpenDBHandle
  {
    #Opens a handle to the MySQL Database
    $statement_handler=$db_handler->prepare($sql);
    if (!defined $statement_handler)
      {
        die('Cannot connect to the database');
      }
    else
      {
        $statement_handler->execute;
      }
  }
