#!/usr/bin/perl
# Setup for cookies and MySQL access
  use CGI;
  use DBI;
  use CGI::Carp  qw( fatalsToBrowser );
  $query=new CGI;
  my $db_handler=DBI->connect("DBI:mysql:test:localhost","mysql","");

#Main
  print $query->header;
  &PrintHeadings;
  if ($query->cookie('Admin'))
    {
      print $query->start_html(-title=>"Admin Tools--Manage Schedule Entries");
      $AdminNo=$query->cookie('Admin');

      #Retrieve and process cgi information
      $action=$query->param('action');
      if ($action eq "")
        {
          &PrintMenu;
        }
      elsif ($action eq "Add")
        {
          $error=0;
          &GetCgiData;
          &ValidateCgiData;
          if ($error==0)
            {
              &AddNNo;
            }
          else
            {
              &PrintValidationError;
            }
        }
      elsif ($action eq "Activate")
        {
          $error=0;
          &GetCgiData;
          &ValidateCgiData;
          if ($error==0)
            {
              &ActivateNNo;
              if ($error==0)
                {
                  &PrintComplete;
                }
              else
                {
                  &PrintUpdateError;
                }
            }
          else
            {
              &PrintValidationError;
            }
        }
      elsif ($action eq "Ground")
        {
          $error=0;
          &GetCgiData;
          &ValidateCgiData;
          if ($error==0)
            {
              &GroundNNo;
              if ($error==0)
                {
                  &PrintComplete;
                }
              else
                {
                  &PrintUpdateError;
                }
            }
          else
            {
              &PrintValidationError;
            }
        }
      elsif ($action eq "Delete")
        {
          $error=0;
          &GetCgiData;
          &ValidateCgiData;
          if ($error==0)
            {
              &DeleteNNo;
              if ($error==0)
                {
                  &PrintComplete;
                }
              else
                {
                  &PrintUpdateError;
                }
            }
          else
            {
              &PrintValidationError;
            }
        }
      elsif ($action eq "Insert")
        {
          $error=0;
          &GetCgiData;
          &ValidateCgiData;
          if ($error==0)
            {
              &InsertNNo;
              if ($error==0)
                {
                  &PrintComplete;
                }
              else
                {
                  &PrintUpdateError;
                }
            }
          else
            {
              &PrintValidationError;
            }
        }
      else
        {
          #Should never happen--indicates probable hack attempt with 3rd party CGI script
          &PrintCGIError;
        }
      &PrintClosingTags;
      $db_handler->disconnect;
    }
  else
    {
      &PrintAuthorizationError;
    }

sub PrintHeadings
  {
    print "<HTML>\n";
    print "  <HEAD>\n";
    print "    <TITLE>\n";
    print "      Admin Tools--Manage Schedule\n";
    print "    </TITLE>\n";
    print "  </HEAD>\n";
    print "  <BODY BACKGROUND=\"/AdminTools/stone.gif\">\n";
    print "    <DIV ALIGN=\"CENTER\">\n";
    print "      <IMG SRC=\"/AdminTools/Logo.gif\" WIDTH=\"384\" HEIGHT=\"54\">\n";
    print "      <BR>\n";
    print "      <HR WIDTH=\"93%\" COLOR=\"GRAY\">\n";
    print "      <BR>\n";
    print "      <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=4>\n";
  }

sub PrintMenu
  {
    print "        Aircraft Management\n";
    print "      </FONT>\n";
    print "      <TABLE BORDER=1 WIDTH=\"66%\">\n";
    print "        <TR>\n";
    print "          <TD ALIGN=\"CENTER\">\n";
    print "            <TABLE BORDER=0 WIDTH=\"55%\">\n";
    print "              <TR>\n";
    print "                <TD ALIGN=\"RIGHT\" WIDTH=\"85%\">\n";
    print "                  <FORM ACTION=\"AircraftManagement.pl\" METHOD=\"POST\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=3>\n";
    print "                      Add N-Number:\n";
    print "                      <INPUT TYPE=\"text\" NAME=\"NNo\" SIZE=6 MAXLENGTH=6>\n";
    print "                      <BR>\n";
    print "                      <INPUT TYPE=\"hidden\" NAME=\"action\" VALUE=\"Add\">\n";
    print "                      <INPUT TYPE=\"submit\" NAME=\"submit\">\n";
    print "                    </FONT>\n";
    print "                  </FORM>\n";
    print "                </TD>\n";
    print "                <TD>\n";
    print "                  <BR>\n";
    print "                </TD>\n";
    print "              </TR>\n";
    print "            </TABLE>\n";
    print "          </TD>\n";
    print "        <TR>\n";
    print "          <TD ALIGN=\"CENTER\">\n";
    print "            <TABLE BORDER=0 WIDTH=\"55%\">\n";
    print "              <TR>\n";
    print "                <TD ALIGN=\"RIGHT\" WIDTH=\"90%\">\n";
    print "                  <FORM ACTION=\"AircraftManagement.pl\" METHOD=\"POST\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=3>\n";
    print "                      Activate Aircraft\n";
    print "                      <INPUT TYPE=\"radio\" NAME=\"action\" VALUE=\"Activate\">\n";
    print "                      <BR>\n";
    print "                      Ground Aircraft\n";
    print "                      <INPUT TYPE=\"radio\" NAME=\"action\" VALUE=\"Ground\">\n";
    print "                      <BR>\n";
    print "                      Delete Aircraft\n";
    print "                      <INPUT TYPE=\"radio\" NAME=\"action\" VALUE=\"Delete\">\n";
    print "                      <BR>\n";
    print "                      <SELECT NAME=\"NNo\">\n";
    $sql="Select NNo, MakeModel, Status from AircraftData order by NNo asc";
    &OpenDBHandle;
    while (($NNo, $MakeModel, $Status)=$statement_handler->fetchrow())
      {
        print "                       <OPTION VALUE=\"$NNo\">$NNo, $MakeModel ($Status)\n";
      }
    $statement_handler->finish;
    print "                      </SELECT>\n";
    print "                      <BR>\n";
    print "                      <INPUT TYPE=\"reset\" NAME=\"reset\">\n";
    print "                      <INPUT TYPE=\"submit\" NAME=\"submit\">\n";
    print "                    </FONT>\n";
    print "                  </FORM>\n";
    print "                </TD>\n";
    print "                <TD>\n";
    print "                  <BR>\n";
    print "                </TD>\n";
    print "              </TR>\n";
    print "            </TABLE>\n";
    print "          </TD>\n";
    print "        </TR>\n";
    print "      </TABLE>\n";
  }

sub GetCgiData
  {
    #Retrieve data passed to the program from the web page
    if ($action eq "Add")
      {
        $NNo=$query->param('NNo');
        #Technically, the rest aren't cgi--they're defaults...
        $Year="";
        $MakeModel="";
        $Category="Airplane";
        $Class="Single-Engine Land";
        $HP=0;
        $Complex=0;
        $Tailwheel=0;
        $EngineSize=0;
        $FuelCapacity=0;
        $IFRVFR="IFR\VFR";
        $DayNight="Day/Night";
        $MinPQ="";
        $EmptyWeight=0;
        $GrossWeight=0;
        $Arm=0;
        $Rate=0;
        $Status="Up";
        $ImageURL="";
      } 
    elsif (($action eq "Activate") || ($action eq "Ground") || ($action eq "Delete"))
      {
        $NNo=$query->param('NNo');
      }
    elsif ($action eq "Insert")
      {
        $NNo=$query->param('NNo');
        $Year=$query->param('Year');
        $MakeModel=$query->param('MakeModel');
        $Category=$query->param('Category');
        $Class=$query->param('Class');
        $HP=$query->param('HP');
        $Complex=$query->param('Complex');
        $Tailwheel=$query->param('Tailwheel');
        $EngineSize=$query->param('EngineSize');
        $FuelCapacity=$query->param('FuelCapacity');
        $IFRVFR=$query->param('IFRVFR');
        $DayNight=$query->param('DayNight');
        $MinPQ=$query->param('MinPQ');
        $EmptyWeight=$query->param('EmptyWeight');
        $GrossWeight=$query->param('GrossWeight');
        $Arm=$query->param('Arm');
        $Rate=$query->param('Rate');
        $Status=$query->param('Status');
        $ImageURL=$query->param('ImageURL');
      }
  }

sub ValidateCgiData
  {
    #Insert validation scripts here
  }

sub AddNNo
  {
    #Displays the form to obtain the new aircraft information
    print "        Add/Edit Aircraft\n";
    print "      </FONT>\n";
    print "      <TABLE BORDER=1 WIDTH=\"93%\">\n";
    print "        <TR>\n";
    print "          <TD ALIGN=\"CENTER\">\n";
    print "            <FORM ACTION=\"/cgi-bin/AdminTools/AircraftManagement.pl\" METHOD=\"POST\">\n";
    print "              <TABLE BORDER=0 WIDTH=\"100%\">\n";
    print "                <TR>\n";
    print "                  <TD ALIGN=\"LEFT\">\n";
    print "                    N-Number:\n";
    print "                    <INPUT TYPE=\"text\" NAME=\"NNo\" SIZE=6 MAXLENGTH=6 VALUE=\"$NNo\">\n";
    print "                  <\TD>\n";
    print "                  <TD ALIGN=\"Left\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      YEAR:\n";
    print "                      <INPUT TYPE=\"text\" NAME=\"Year\" SIZE=4 MAXLENGTH=4>\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"LEFT\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      Make and Model:\n";
    print "                      <INPUT TYPE=\"text\" NAME=\"MakeModel\" SIZE=15 MAXLENGTH=30>\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                </TR>\n";
    print "              </TABLE>\n";
    print "              <BR>\n";
    print "              <TABLE BORDER=1 WIDTH=\"100%\">\n";
    print "                <TR>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      Category:\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      Class:\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      Day/Night:\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      IFR/VFR:\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      High-Performance:\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      Complex:\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      Tailwheel:\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      Rental Rate:\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      Flight Status:\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                </TR>\n";
    print "                <TR>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      <SELECT NAME=\"Category\">\n";
    print "                        <OPTION VALUE=\"Airplane\">Airplane\n";
    print "                        <OPTION VALUE=\"Glider\">Glider\n";
    print "                        <OPTION VALUE=\"Rotorcraft\">\n";
    print "                        <OPTION VALUE=\"LTA\">\n";
    print "                      </SELECT>\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      <SELECT NAME=\"Class\">\n";
    print "                        <OPTION VALUE=\"Single-Engine Land\">Single-Engine Land\n";
    print "                        <OPTION VALUE=\"Single-Engine Sea\">Single-Engine Sea\n";
    print "                        <OPTION VALUE=\"Multi-Engine Land\">Multi-Engine Land\n";
    print "                        <OPTION VALUE=\"Multi-Engine Sea\">Multi-Engine Sea\n";
    print "                        <OPTION VALUE=\"Glider\">Glider\n";
    print "                      </SELECT>\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      <SELECT NAME=\"DayNight\">\n";
    print "                        <OPTION VALUE=\"Day/Night\">Day/Night\n";
    print "                        <OPTION VALUE=\"Day Only\">Day Only\n";
    print "                      </SELECT>\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      <SELECT NAME=\"IFRVFR\">\n";
    print "                        <OPTION VALUE=\"IFR/VFR\">IFR/VFR\n";
    print "                        <OPTION VALUE=\"VFR Only\">VFR Only\n";
    print "                      </SELECT>\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      <SELECT NAME=\"HP\">\n";
    print "                        <OPTION VALUE=0>No\n";
    print "                        <OPTION VALUE=1>Yes\n";
    print "                      </SELECT>\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      <SELECT NAME=\"Complex\">\n";
    print "                        <OPTION VALUE=0>No\n";
    print "                        <OPTION VALUE=1>Yes\n";
    print "                      </SELECT>\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      <SELECT NAME=\"Tailwheel\">\n";
    print "                        <OPTION VALUE=0>No\n";
    print "                        <OPTION VALUE=1>Yes\n";
    print "                      </SELECT>\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      \$<INPUT TYPE=\"text\" NAME=\"Rate\" SIZE=9 MAXLENGTH=9>\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      <SELECT NAME=\"Status\">\n";
    print "                        <OPTION VALUE=\"Up\">Up\n";
    print "                        <OPTION VALUE=\"Down\">Down\n";
    print "                      </SELECT>\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "              </TABLE>\n";
    print "              <BR>\n";
    print "              <TABLE BORDER=1 WIDTH=\"100%\">\n";
    print "                <TR>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      Engine Size:\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      Fuel Capacity:\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      Empty Weight:\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      Gross Weight:\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      Arm:\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      Image URL:\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                </TR>\n";
    print "                <TR>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      <INPUT TYPE=\"text\" NAME=\"EngineSize\" SIZE=6 MAXLENGTH=6>\n";
    print "                      H.P.\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      <INPUT TYPE=\"text\" NAME=\"FuelCapacity\" SIZE=6 MAXLENGTH=6>\n";
    print "                      Gal.\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      <INPUT TYPE=\"text\" NAME=\"EmptyWeight\" SIZE=6 MAXLENGTH=6>\n";
    print "                      lbs.\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      <INPUT TYPE=\"text\" NAME=\"GrossWeight\" SIZE=6 MAXLENGTH=6>\n";
    print "                      lbs.\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      <INPUT TYPE=\"text\" NAME=\"Arm\" SIZE=11 MAXLENGTH=11>\n";
    print "                      in.\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"CENTER\">\n";
    print "                    <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=2>\n";
    print "                      <INPUT TYPE=\"text\" NAME=\"ImageURL\" SIZE=10 MAXLENGTH=50>\n";
    print "                    </FONT>\n";
    print "                  </TD>\n";
    print "                </TR>\n";
    print "              </TABLE>\n";
    print "              <TABLE BORDER=0 WIDTH=\"50%\">\n";
    print "                <TR>\n";
    print "                  <TD>\n";
    print "                    <TABLE BORDER=1 WIDTH=\"100%\">\n";
    print "                      <TR>\n";
    print "                        <TD>\n";
    print "                          <TEXTAREA NAME=\"MinPQ\" COLS=42 ROWS=6></TEXTAREA>\n";
    print "                        </TD>\n";
    print "                      </TR>\n";
    print "                    </TABLE>\n";
    print "                  </TD>\n";
    print "                  <TD ALIGN=\"RIGHT\">\n";
    print "                    <INPUT TYPE=\"reset\" NAME=\"reset\">\n";
    print "                    <INPUT TYPE=\"submit\" NAME=\"submit\">\n";
    print "                    <INPUT TYPE=\"hidden\" NAME=\"action\" VALUE=\"Insert\">\n";
    print "                  </TD>\n";
    print "                </TR>\n";
    print "              </TABLE>\n";
    print "            </FORM>\n";
    print "          </TD>\n";
    print "        </TR>\n";
    print "      </TABLE>\n";
  }

sub InsertNNo
  {
    #Insert the data retrieved from the AddNNo subroutine
    #Make sure the requested N-Number isn't already in the database
    $error=0;
    $sql="Select NNo from AircraftData where (NNo=\"$NNo\")";
    &OpenDBHandle;
    ($error)=$statement_handler->fetchrow();
    $statement_handler->finish;
    if ($error==0)
      {
        $sql="Insert into AircraftData values (\"$NNo\", \"$Year\", \"$MakeModel\", \"$Category\", \"$Class\", $HP, $Complex, $Tailwheel, $EngineSize, $FuelCapacity, \"$IFRVFR\", \"$DayNight\", \"$MinPQ\", $EmptyWeight, $GrossWeight, $Arm, $Rate, \"$Status\", \"$ImageURL\")";
        &OpenDBHandle;
        $statement_handler=$db_handler->prepare($sql);
        $statement_handler->finish;
      }
  }

sub ActivateNNo
  {
    #Activates the designated aircraft
    #First, verify that there is a grounded aircraft in the database with the specified N-Number...
    $error=0;
    $sql="Select NNo from AircraftData where ((NNo=\"$NNo\") and (Status=\"Down\"))";
    &OpenDBHandle;
    ($error)=$statement_handler->fetchrow();
    $statement_handler->finish;
    if ($error==$NNo)
      {
        #...and if so, change status to "UP"
        $error=0;
        $sql="Update AircraftData set Status=\"Up\" where (NNo=\"$NNo\")"; 
        &OpenDBHandle;
        $statement_handler=$db_handler->prepare($sql);
        $statement_handler->finish;
      }
    else
      {
        #but if not, then set the error flag to true;
        $error=1;
      }
  }

sub GroundNNo
  {
    #Grounds the designated aircraft
    #First, verify that there is an active aircraft in the database with the specified N-Number...
    $error=0;
    $sql="Select NNo from AircraftData where ((NNo=\"$NNo\") and (Status=\"Up\"))";
    &OpenDBHandle;
    ($error)=$statement_handler->fetchrow();
    $statement_handler->finish;
    if ($error==$NNo)
      {
        #...and if so, change status to "DOWN"
        $error=0;
        $sql="Update AircraftData set Status=\"Down\" where (NNo=\"$NNo\")"; 
        &OpenDBHandle;
        $statement_handler=$db_handler->prepare($sql);
        $statement_handler->finish;
      }
    else
      {
        #but if not, then set the error flag to true;
        $error=1;
      }
  }

sub DeleteNNo
  {
    #Deletes the designated aircraft
    #First, verify that there is an active aircraft in the database with the specified N-Number
    $error=0;
    $sql="Select NNo from AircraftData where (NNo=\"$NNo\")";
    &OpenDBHandle;
    ($error)=$statement_handler->fetchrow();
    $statement_handler->finish;
    if ($error==$NNo)
      {
        #If so...
        #...delete all schedule entries with this airplane...
        $sql="Delete from Schedule where (NNo=\"$NNo\")";
        &OpenDBHandle;
        $statement_handler=$db_handler->prepare($sql);
        $statement_handler->finish;

        #...then, delete the airplane from the database
        $error=0;
        $sql="Delete from AircraftData where (NNo=\"$NNo\")"; 
        &OpenDBHandle;
        $statement_handler=$db_handler->prepare($sql);
        $statement_handler->finish;
      }
    else
      {
        #but if not, then set the error flag to true;
        $error=1;
      }
  }

sub PrintValidationError
  {
    print "        I'm sorry--the data returned by the CGI script was not valid.  Please return to the\n";
    print "        <A HREF=\"/cgi-bin/AdminTools/AircraftManagement.pl\">\n";
    print "          Aircraft Management\n";
    print "        </A>\n";
    print "        page, and try again.\n";
    print "        <BR>\n";
  }

sub PrintUpdateError
  {
    if (($action eq "Add") || ($action eq "Insert"))
      {
        print "        Error--unable to add $NNo.  Verify that $NNo does not already exist in the AircraftData table.\n";
      }
    elsif ($action eq "Activate")
      {
        print "        Error--unable to activate $NNo.  Verify that $NNo exists in the AircraftData table and has a status of 'Down'.\n";
      }
    elsif ($action eq "Ground")
      {
        print "        Error--unable to ground $NNo.  Verify that $NNo exists in the AircraftData table and has a status of 'Up'.\n";
      }
    elsif ($action eq "Delete")
      {
        print "        Error--unable to remove $NNo from the database.  Verify that $NNo already exists in the AircraftData table.\n";
      }
    print "        <BR>\n";
  }

sub PrintComplete
  {
    print "        Done!  Changes to the database have been completed.\n";
    print "        <BR>\n";
  }

sub PrintAuthorizationError
  {
    print "        I'm sorry--this page is restricted to CFC Administrators, only.\n";
    print "        <BR>\n";
    print "        <BR>\n";
    print "        Please\n";
    print "        <A HREF=\"/AdminTools/Login.html\">\n";
    print "          sign in\n";
    print "        </A>\n";
    print "        to access this page.\n";
    print "        <BR>\n";
    print "      </FONT>\n";
    print "      <BR>\n";
    print "      <BR>\n";
    print "      <BR>\n";
    print "      <FONT FACE=\"TAHOMA\" SIZE=1 COLOR=\"NAVY\">\n";
    print "        Copyright &#169; 2002 Cumulogranite Flying Club\n";
    print "        <BR>\n";
    print "        <A HREF=\"/CS470/Merrill.gif\">\n";
    print "          1234 Merrill Field Dr.\n";
    print "        </A>\n";
    print "        , Anchorage, AK 99501\n";
    print "      </FONT>\n";
    print "    </DIV>\n";
    print "  </BODY>\n";
    print "</HTML>\n";
  }

sub PrintClosingTags
  {
    #Print common closing elements
    print "      <FONT FACE=\"TAHOMA\" COLOR=\"NAVY\" SIZE=3>\n";
    print "        <BR>\n";
    print "        Return to \n";
    print "        <A HREF=\"/cgi-bin/AdminTools/Home.pl\">\n";
    print "          Admin Tools main menu\n";
    print "        </A>\n";
    print "        <BR>\n";
    print "        or\n";
    print "        <BR>\n";
    print "        <A HREF=\"/cgi-bin/AdminTools/AircraftManagement.pl\">\n";
    print "          Aircraft Management menu.\n";
    print "        </A>\n";
    print "      </FONT>\n";
    print "      <BR>\n";
    print "      <BR>\n";
    print "      <BR>\n";
    print "      <FONT FACE=\"TAHOMA\" SIZE=1 COLOR=\"NAVY\">\n";
    print "        Copyright &#169; 2002 Cumulogranite Flying Club\n";
    print "        <BR>\n";
    print "        <A HREF=\"/CS470/Merrill.gif\">\n";
    print "          1234 Merrill Field Dr.\n";
    print "        </A>\n";
    print "        , Anchorage, AK 99501\n";
    print "      </FONT>\n";
    print "    </DIV>\n";
    print "  </BODY>\n";
    print "</HTML>\n";
  }

sub OpenDBHandle
  {
    #Opens a handle to the MySQL Database
    $statement_handler=$db_handler->prepare($sql);
    if (!defined $statement_handler)
      {
        die('Cannot connect to the database');
      }
    else
      {
        $statement_handler->execute;
      }
  }
