<?php
/*=================================================
	Project: phpGedView
	File: functions.php
	Author: John Finlay
	Comments:
		Various functions used by all scripts and included by the config.php
		file.

	Change Log:
		5/30/02 - File Created
		6/12/02 - Fixed a global variable bug in print_header function
		6/14/02 - Fixed some end of file bugs and updated the print source function
			added links for source list and family list to footer function
		6/18/02 - Changed to a table layout, added user defined header and footer files
		8/15/02 - made more GEDCOM 5.0 compliant
		9/24/02 - Added support for language files
===================================================*/

// -- check if a person is dead
function is_dead($indirec) {
	global $HIDE_LIVE_PEOPLE;
	global $lang;

	if ($HIDE_LIVE_PEOPLE){
		if (strstr($indirec, "DEAT")) return true;
		// -- check for a death record
		$cyear = date("Y");
		$ct = preg_match_all("/\d DATE .*(\d\d\d\d)/", $indirec, $match, PREG_SET_ORDER);
		for($i=0; $i<$ct; $i++) {
			$byear = $match[$i][1];
			// -- if they were born less than 120 years ago assume they are still living
			if (($cyear-$byear) >120) {
				return true;
			}
		}
		return false;
	}
	return true;
}

// -- find and return the GEDCOM record that begins before the provided offset
function find_previous_record($offset) {
	global $fcontents;
	global $lang;

	$temp = substr($fcontents, 0, $offset);
	$pos1 = strrpos($temp, "0");
	while(($pos1) && (($temp[$pos1+1]!=" ") || ($temp[$pos1+2]!="@"))) {
		$temp = substr($temp, 0, $pos1-1);
		$pos1 = strrpos($temp, "0");
	}
	$pos2 = strpos($fcontents, "0 @", $offset);
	if ($pos2) $record = substr($fcontents, $pos1, $pos2-$pos1);
	else $record = substr($fcontents, $pos1);
	return $record;
}

// -- find and return the GEDCOM record that begins before the provided offset
function find_previous_id($offset) {
	global $fcontents;
	global $lang;

	$temp = substr($fcontents, 0, $offset);
	$pos1 = strrpos($temp, "0");
	while(($pos1) && (($temp[$pos1+1]!=" ") || ($temp[$pos1+2]!="@"))) {
		$temp = substr($temp, 0, $pos1-1);
		$pos1 = strrpos($temp, "0");
	}
	return substr($temp, $pos1+3, strpos($temp, "@", $pos1+3));
}

// -- find and return a given family's information
function find_family_record($famid) {
	global $fcontents;
	global $lang;

	$pos1 = strpos($fcontents, "0 @$famid@ FAM");
	if (!$pos1) {
		print "<h3>".$lang["unable_to_find_family"]." $famid</h3>";
		return false;
	}
	$pos2 = strpos($fcontents, "0 @", $pos1+1);
	if ($pos2) $famrec = substr($fcontents, $pos1, $pos2-$pos1);
	else $famrec = substr($fcontents, $pos1);
	return $famrec;
}

// -- find and return a given individuals information
function find_person_record($pid) {
	global $fcontents;
	global $lang;

	$pos1 = strpos($fcontents, "0 @$pid@ INDI");
	if (!$pos1) {
		print $lang["unable_to_find_indi"]." $pid";
		return false;
	}
	$pos2 = strpos($fcontents, "0 @", $pos1+1);
	if ($pos2) $indirec = substr($fcontents, $pos1, $pos2-$pos1);
	else $indirec = substr($fcontents, $pos1);
	return $indirec;
}

// -- find and return a given ids record
function find_gedcom_record($pid) {
	global $fcontents;
	global $lang;

	$pos1 = strpos($fcontents, "0 @$pid@");
	if (!$pos1) {
		print $lang["unable_to_find_record"]." $pid";
		return false;
	}
	$pos2 = strpos($fcontents, "0 @", $pos1+1);
	if ($pos2) $indirec = substr($fcontents, $pos1, $pos2-$pos1);
	else $indirec = substr($fcontents, $pos1);
	return $indirec;
}

// -- find and return given source information
function find_source_record($sid) {
	global $fcontents;
	global $lang;

	if ($sid=="") return;
	$pos1 = strpos($fcontents, "0 @$sid@ SOUR");
	if (!$pos1) {
		print $lang["unable_to_find_source"]." $sid";
		return false;
	}
	$pos2 = strpos($fcontents, "0 @", $pos1+1);
	if ($pos2) $source = substr($fcontents, $pos1, $pos2-$pos1);
	else $source = substr($fcontents, $pos1);
	return $source;
}

// -- find and return a given individuals name surname, givennames suffix
if (($USE_INDEX_FILES)&&(!isset($BUILDING_INDEX))) {
	function get_sortable_name($pid) {
		global $indilist;
		if ($pid=="") return;
		return $indilist["$pid"];
	}

	function get_family_descriptor($fid) {
		global $famlist;
		return $famlist["$fid"];
	}

	function get_source_descriptor($sid) {
		global $sourcelist;
		return $sourcelist["$sid"];
	}
}
else {
	function get_sortable_name($pid) {
		global $fcontents;
		global $lang;

		if ($pid=="") return;
		$pos1 = strpos($fcontents, "0 @$pid@ INDI");
		if (!$pos1) {
			print "Unable to find individual with id $pid";
			return false;
		}
		$pos2 = strpos($fcontents, "0 @", $pos1+1);
		$indirec = substr($fcontents, $pos1, $pos2-$pos1);
		$ct = preg_match("/2 SURN (.*)/", $indirec, $match);
		preg_match("/2 GIVN (.*)/", $indirec, $gmatch);
		preg_match("/2 NSFX (.*)/", $indirec, $smatch);
		if ($ct>0) {
			$name = rtrim($match[1]).", ".rtrim($gmatch[1])." ".rtrim($smatch[1]);
		}
		else {
			preg_match("/1 NAME (.*)/", $indirec, $match);
			$names = preg_split("/\//", $match[1]);
			$name = trim($names[1]).",";
			$name .= " ".trim($names[0])." ".trim($names[2]);
		}
		$name = preg_replace("'\/'", "", $name);
		return $name;
	}

	function get_family_descriptor($fid) {
		global $lang;
		$parents = find_parents($fid);
		return get_sortable_name($parents["HUSB"])." + ".get_sortable_name($parents["WIFE"]);
	}

	function get_source_descriptor($sid) {
		global $lang;
		$source = find_source_record($sid);
		if ($source) {
			$ct = preg_match("/1 ABBR (.*)/", $source, $match);
			if ($ct > 0) return $match[1];
			else {
				$ct = preg_match("/1 TITL (.*)/", $source, $match);
				if ($ct > 0) {
					$title = $match[1];
					$ct = preg_match_all("/2 CON[C|T] (.*)/", $factrec, $match, PREG_SET_ORDER);
					for($i=0; $i<$ct; $i++) {
						$title .= $match[$i][1];
					}
					return $title;
				}
			}
		}
		return $sid;
	}
}

// -- find and return a given individuals surname
/*function get_person_surname($pid) {
	global $fcontents;
	global $lang;

	if ($pid=="") return;
	$pos1 = strpos($fcontents, "0 @$pid@ INDI");
	if (!$pos1) {
		print $lang["unable_to_find_indi"]." $pid";
		return false;
	}
	$pos2 = strpos($fcontents, "0 @", $pos1+1);
	$indirec = substr($fcontents, $pos1, $pos2-$pos1);
	$ct = preg_match("/2 SURN (.*)/", $indirec, $match);
	if ($ct>0) {
		$name = trim($match[1]);
	}
	else {
		preg_match("/1 NAME (.*)/", $indirec, $match);
		$names = preg_split("/[\s,\/]/", $match[1]);
		$name = trim($names[count($names)-1]);
	}
	$name = preg_replace("'\/'", "", $name);
	return $name;
}*/

// -- find and return a given individuals name
function get_person_name($pid)
{

	if ($pid=="") return;
	if (!$genealogy)
	{
		$genealogy = mysql_pconnect('localhost','genealogy','genealogy');
		if (!$genealogy) {die ("MySQL connection failed!");}
		mysql_select_db("genealogy",$genealogy);
	}
	$nameQry = mysql_query("SELECT name FROM tblPerson where ID = '$pid'", $genealogy);
	if (!$nameQry) { die ("User name Query failed!"); }
	$ref = mysql_fetch_row($nameQry);
	$name = $ref[0];
	return $name;
}

function get_user_name($pid)
{

	if ($pid=="") return;
	if (!$genealogy)
	{
		$genealogy = mysql_pconnect('localhost','genealogy','genealogy');
		if (!$genealogy) {die ("MySQL connection failed!");}
		mysql_select_db("genealogy",$genealogy);
	}
	$nameQry = mysql_query("SELECT username FROM tblUser where ID = '$pid'", $genealogy);
	if (!$nameQry) { die ("User name Query failed!"); }
	$ref = mysql_fetch_row($nameQry);
	$name = $ref[0];
	return $name;
}
/*
// -- find and print given Repository information
function print_repository_record($sid) {
	global $fcontents;
	global $lang;

	$pos1 = strpos($fcontents, "0 @$sid@ REPO");
	if (!$pos1) {
		print $lang["unable_to_find_repo"]." $sid";
		return false;
	}
	$pos2 = strpos($fcontents, "0 @", $pos1+1);
	$source = substr($fcontents, $pos1, $pos2-$pos1);
	$ct = preg_match("/1 NAME (.*)/", $source, $match);
	if ($ct > 0) print "<br><font class=label>".$lang["repo_name"]."</font> <font class=field>$match[1]</font>";
	$ct = preg_match("/1 ADDR (.*)/", $source, $match);
	if ($ct > 0) {
		print "<br><font class=label>".$lang["address"]."</font> <font class=field>$match[1]";
		$ct = preg_match_all("/2 CON[C|T] (.*)/", $factrec, $match, PREG_SET_ORDER);
		for($i=0; $i<$ct; $i++) {
			print $match[$i][1];
		}
		print "</font>";
	}
	$ct = preg_match("/1 PHON (.*)/", $source, $match);
	if ($ct > 0) print "<br><font class=label>".$lang["phone"]."</font> <font class=field>$match[1]</font>";
}

// -- find and print given source information
function print_source_record($sid) {
	global $fcontents;
	global $lang;

	$pos1 = strpos($fcontents, "0 @$sid@ SOUR");
	if (!$pos1) {
		print $lang["unable_to_find_source"]." $sid";
		return false;
	}
	$pos2 = strpos($fcontents, "0 @", $pos1+1);
	$source = substr($fcontents, $pos1, $pos2-$pos1);
	$ct = preg_match("/1 ABBR (.*)/", $source, $match);
	if ($ct > 0) print "<font class=label>".$lang["source_name"]."</font> <a href=\"source.php?sid=$sid\"><font size=-1>$match[1]</font></a>";
	$ct = preg_match("/1 TITL (.*)/", $source, $match);
	if ($ct > 0) {
		print "\n\t\t\t<br><font class=label>".$lang["title"]."</font> <font class=field>$match[1]";
		$ct = preg_match_all("/2 CON[C|T] (.*)/", $factrec, $match, PREG_SET_ORDER);
		for($i=0; $i<$ct; $i++) {
			print $match[$i][1];
		}
		print "</font>";
	}
	$ct = preg_match("/1 AUTH (.*)/", $source, $match);
	if ($ct > 0) print "<font class=label>".$lang["author"]."</font> <font class=field>$match[1]</font>";
	$ct = preg_match("/1 PUBL (.*)/", $source, $match);
	if ($ct > 0) {
		print "<br><font class=label>".$lang["publication"]."</font> <font class=field>$match[1]";
		$ct = preg_match_all("/2 CON[C|T] (.*)/", $factrec, $match, PREG_SET_ORDER);
		for($i=0; $i<$ct; $i++) {
			print $match[$i][1];
		}
		print "</font>";
	}
	$ct = preg_match("/1 REPO @(.*)@/", $source, $match);
	if ($ct > 0) {
		print_repository_record($match[1]);
		$ct = preg_match("/\d CALN (.*)/", $source, $match);
		if ($ct > 0) print "<font class=label>".$lang["call_number"]."</font> <font class=field>$match[1]</font>";
	}
}
*/
// -- find and print a given individuals information for a pedigree chart
function print_pedigree_person($pid) {
	global $fcontents;
	global $HIDE_LIVE_PEOPLE;
	global $lang;

//print $pid;
	if ($pid==false)
	{
		print "<br>";
		return false;
	}
      $genealogy = mysql_pconnect('localhost','genealogy','genealogy');
      if (!$genealogy) {die ("MySQL connection failed!");}
      mysql_select_db("genealogy",$genealogy);

	$pedigreeQry = mysql_query("SELECT familyIDchild, name, DOB, death, father, mother FROM tblPerson where ID = '$pid'", $genealogy);
      if (!$pedigreeQry) { die ("Pedigree Query failed!"); }
      $ref = mysql_fetch_row($pedigreeQry);
	$famid = $ref[0];
	$name = $ref[1];
	$birth = $ref[2];
	$death = $ref[3];


/*
	$pos1 = strpos($fcontents, "0 @$pid@ INDI");
	if (!$pos1) {
		print $lang["unable_to_find_indi"]." $pid";
		return false;
	}
	$pos2 = strpos($fcontents, "0 @", $pos1+1);
	$indirec = substr($fcontents, $pos1, $pos2-$pos1);
	$ct = preg_match("/1\s*FAMS\s*@(.*)@/", $indirec, $match);
	if ($ct>0)
	*/
      if ($famid)
	{
		//$famid = $match[1];

	      print "<a href=\"index.php?fuseaction=main.family&family=$famid\"><img src=\"images/cfamily-noshade.gif\" width=\"25\" border=0 align=\"right\"></a>";
	}
	print "<a href=\"index.php?fuseaction=main.person&id=$pid\"><img src=\"images/indis-noshade1.gif\" width=\"25\" border=0 align=\"right\"></a>";
	/*
	preg_match("/1 NAME (.*)/", $indirec, $match);
	preg_match("/2 NSFX (.*)/", $indirec, $smatch);
	*/
	//print "<a href=\"individual.php?pid=$pid\"><font class=\"name\">";
	print "<a href=\"index.php?fuseaction=main.search&searchFor=$pid\"><font class=\"name\">";
	//$match[1]= preg_replace("'\/'", "", $match[1]);
	//print "$match[1] $smatch[1]</font></a><br><font class=\"details\">";
	print "$name</font></a><br><font class=\"details\">";

	/*if (!is_dead($indirec))
	{
		print $lang["living"];
		return;
	}*/
	print $lang["birth"];
	print "Birth: ";
/*	$bpos1 = strpos($indirec, "1 BIRT");
	if ($bpos1)
	{
		$birthrec = substr($indirec, $bpos1+1);
		preg_match("/1 [A-Z]{4}/", $birthrec, $match);
		$bpos2 = strpos($birthrec, $match[0]);
		if ($bpos2) $birthrec = substr($birthrec, 0, $bpos2);
		preg_match("/2 DATE (.*)/", $birthrec, $match);

		print $match[1];
		preg_match("/2 PLAC (.*)/", $birthrec, $match);
		print " -- ".$match[1];
	}
*/
      print $birth;
	print "<br>";
	print $lang["death"];
	print "Death: ";
	/*$bpos1 = strpos($indirec, "1 DEAT");
	if ($bpos1) {
		$birthrec = substr($indirec, $bpos1+1);
		preg_match("/1 [A-Z]{4}/", $birthrec, $match);
		$bpos2 = strpos($birthrec, $match[0]);
		if ($bpos2) $birthrec = substr($birthrec, 0, $bpos2);
		preg_match("/2 DATE (.*)/", $birthrec, $match);
		print $match[1];
		preg_match("/2 PLAC (.*)/", $birthrec, $match);
		print " -- ".$match[1];
	}
*/
      print $death;
	print "</font>";
}

// -- find and return a two element array containing the parents of the given family record
function find_parentsold($famid) {
	global $fcontents;
	global $lang;
	$pos1 = strpos($fcontents, "0 @$famid@ FAM");
	if (!$pos1) {
		print "<h3>".$lang["unable_to_find_family"]." $famid</h3>";
		return false;
	}
	$pos2 = strpos($fcontents, "0 @", $pos1+1);
	$famrec = substr($fcontents, $pos1, $pos2-$pos1);
	$parents = array();
	$ct = preg_match("/1 HUSB @(.*)@/", $famrec, $match);
	$parents["HUSB"]=$match[1];
	$ct = preg_match("/1 WIFE @(.*)@/", $famrec, $match);
	$parents["WIFE"]=$match[1];
	return $parents;
}

// -- find and return the family id for which the given individual is a child
function find_family_idold($pid) {
	global $fcontents;
	global $lang;
	if (!$pid) return false;
	$pos1 = strpos($fcontents, "0 @$pid@ INDI");
	if (!$pos1) {
		print "<h3>".$lang["unable_to_find_indi"]." $pid</h3>";
		return false;
	}
	$pos2 = strpos($fcontents, "0 @", $pos1+1);
	$indirec = substr($fcontents, $pos1, $pos2-$pos1);
	$ct = preg_match("/1\s*FAMC\s*@(.*)@/", $indirec, $match);
	if ($ct>0) return $match[1];
	else return false;
}

// -- find and return the family id for which the given individual is a spouse
function find_sfamily_id_old($pid) {
	global $fcontents;
	$pos1 = strpos($fcontents, "0 @$pid@ INDI");
	if (!$pos1) {
		print "<h3>".$lang["unable_to_find_indi"]." $pid</h3>";
		return false;
	}
	$pos2 = strpos($fcontents, "0 @", $pos1+1);
	$indirec = substr($fcontents, $pos1, $pos2-$pos1);
	$ct = preg_match("/1\s*FAMS\s*@(.*)@/", $indirec, $match);
	if ($ct>0) return $match[1];
	else return false;
}

// -- read the file into a big string
function read_gedcom_file() {
	/*global $fcontents;
	global $GEDCOM;
	global $lang;
	$fcontents = implode("", file($GEDCOM));*/
}

// -- print out the html header information
function print_header($title) {
	global $BGCOLOR;
	global $BGIMAGE;
	global $cart;
	global $lang;
	global $BODY_PROPERTIES;
	global $TABLEBORDERCOLOR;
	global $TABLEFILLCOLOR;
	global $view;

	print "<html>\n\t<head>\n\t\t<title>$title</title>\n\t<link rel=\"stylesheet\" href=\"style.css\" type=\"text/css\">\n\t</head>\n\t<body bgcolor=\"$BGCOLOR\"";
	if ($BGIMAGE!="") print "background=\"$BGIMAGE\"";
	print " $BODY_PROPERTIES>\n\t";
	if ($view!="preview") {
		include("header.html");
		include("toplinks.html");
	}
}

function find_family_id($id)
{
 $genealogy = mysql_pconnect('localhost','genealogy','genealogy');
      if (!$genealogy) {die ("MySQL connection failed!");}
      mysql_select_db("genealogy",$genealogy);
	$userIdQry = mysql_query("SELECT familyIDchild FROM tblPerson where ID = '$id'", $genealogy);
      if (!$userIdQry) { die ("User Id Query failed!"); }
      $ref = mysql_fetch_row($userIdQry);
	return $ref[0];
}

function find_sfamily_id($id)
{
	$genealogy = mysql_pconnect('localhost','genealogy','genealogy');
	if (!$genealogy) {die ("MySQL connection failed!");}
	mysql_select_db("genealogy",$genealogy);
	$userIdQry = mysql_query("SELECT ID FROM tblFamily where husbID = '$id' or wifeID = '$id'", $genealogy);
	//$userIdQry = mysql_query("SELECT ID FROM tblPerson where father = '$id' or mother = '$id'", $genealogy);
	if (!$userIdQry) { die ("User Id Query failed!"); }
	$ref = mysql_fetch_row($userIdQry);
	return $ref[0];
}

function find_parents($id)
{
      //print "Passed ID = " . $id;
      $genealogy = mysql_pconnect('localhost','genealogy','genealogy');
      if (!$genealogy) {die ("MySQL connection failed!");}
      mysql_select_db("genealogy",$genealogy);
	$userIdQry = mysql_query("SELECT father, mother FROM tblPerson where ID = '$id'", $genealogy);
      if (!$userIdQry) { die ("User Id Query failed!"); }
      $ref = mysql_fetch_row($userIdQry);
	$parents[0] = $ref[0];
	$parents[1] = $ref[1];
      return $parents;
 }

function print_pedigree_personNew($id)
{
      $genealogy = mysql_pconnect('localhost','genealogy','genealogy');
      if (!$genealogy) {die ("MySQL connection failed!");}
      mysql_select_db("genealogy",$genealogy);
	$userIdQry = mysql_query("SELECT ID, name, SSN, submitter from tblPerson where ID = '$id'", $genealogy);
      if (!$userIdQry) { die ("User Id Query failed!"); }
      $ref = mysql_fetch_row($userIdQry);
      print "<a href=index.php?fuseaction=main.search&searchFor=$ref[0]>$ref[1]</a><br> SSN = $ref[2] <br>submitter = $ref[3]";
}

// -- print the html to close the page
function print_footer() {
	global $without_close;
	global $lang;
	global $cart;
	global $view;
	global $PHP_SELF, $QUERY_STRING, $action, $query;
	if ($view!="preview") {
		include("footer.html");
		print "\n\t<br><br><br><div align=\"center\">";
		//print "<a href=\"http://phpgedview.sourceforge.net\"><img src=\"images/gedview.gif\" border=0></a><br>";
		if (!strstr($PHP_SELF, "search.php")) print "<br><a href=\"$PHP_SELF?view=preview&$QUERY_STRING\">Print Preview</a><br></div>";
		else print "<br><a href=\"$PHP_SELF?view=preview&$QUERY_STRING&action=$action&query=$query\">Print Preview</a><br></div>";
	}
	if (!isset($without_close)) print "\n\t<body>\n<html>";
}

// -- this will define a useful array function that is not available in older versions of php
if (phpversion() < '4.1') {
      eval('function array_key_exists($key, $arr) {
	      		global $lang;
                if (!is_array($arr)) {
	                print "<font class=\"error\">".$lang["not_an_array"]."</font>";
                   return false;
                }
                foreach (array_keys($arr) as $k) {
                   if ($k == $key) {
                      return true;
                   }
                }
                return false;
             }');
   }

?>
