<?php
/*
<fusedoc fuse="fbx_Switch.php">
	<responsibilities>
		I am the switch statement that handles the fuseaction, delegating work to various fuses.
	</responsibilities>
	<io>
		<in>
			<string name="$Fusebox['fuseaction']" />
			<string name="$Fusebox['circuit']" />
		</in>
	</io>	
</fusedoc>
*/
// User Switch File
if ($authenticated)
{
	switch($Fusebox["fuseaction"])
	{
		case "main":
			include("includes/dsp_main.inc");
			break;
		case "family":
			include("includes/dsp_family.inc");
			break;
		case "person":
			include("includes/dsp_person.inc");
			break;
		case "search":
			include("includes/dsp_search.inc");
			break;
		case "add":
			include("includes/dsp_addInfo.inc");
			break;
		case "addPerson":
			include("queries/qry_addPerson.inc");
			break;
		case "addMarriage":
			include("queries/qry_addMarriage.inc");
			break;
		case "editPerson":
			include("includes/dsp_editPerson.inc");
			break;
		case "editFamily":
			include("includes/dsp_editFamily.inc");
			break;
		case "commitChangesPerson";
			include("queries/qry_commitChangesPerson.inc");
			break;
		case "commitChangesFamily";
			include("queries/qry_commitChangesFamily.inc");
			break;
		case "upload":
			include("includes/dsp_uploadFile.inc");
			break;
		case "users":
		case "Fusebox.defaultFuseaction":
		   print "I received a fuseaction called <b>'" . $Fusebox["fuseaction"] . "'</b> that circuit <b>'" . $Fusebox["circuit"] . "'</b> handles.";
		   include("includes/dsp_main.inc");
			break;
		default:
			print "I received a fuseaction called <b>'" . $Fusebox["fuseaction"] . "'</b> that circuit <b>'" . $Fusebox["circuit"] . "'</b> does not have a handler for.";
			break;
	}
}
else
{
      // Bounce user to login screen if they try to access an area that needs authentication.
      header('Location: index.php?fuseaction=main.login');
}


?>
