<?php
/*=================================================
	Project: phpGedView
	File: config.php
	Author: John Finlay
	Comments:
		Configuration file for PHPGedView

	Change Log:
		5/30/02 - File Created
		6/11/02 - Moved some configuration variables from other files
		6/12/02 - Added box spacing variables
		6/18/02 - Added more asthetic variables
		7/8/02 - included more support for index files
		8/15/02 - Added support for ALPHA_INDEX_LISTS
		9/24/02 - Addes support for language files
===================================================*/

// -- amount of time to execute before quitting in seconds
// -- set this to 0 to remove all time limits
set_time_limit(10*60);	// -- 10 minutes (mostly required for buildindex time)
$VERSION = "1.0";
$GEDCOM = "surname.ged";		// -- path to gedcom file

$LANGUAGE = "english";
//$LANGUAGE = "spanish";
//$LANGUAGE = "french";

//$PEDIGREE_ROOT_ID = "I1";		// -- use this line to change the default person who appears on

$HIDE_LIVE_PEOPLE = true;			// -- a false value will show details of people who are still alive
$SHOW_GEDCOM_RECORD = true;		// -- a true value will provide a link on detail pages that will
												// --allow people to view the actual lines from the gedcom file
$USE_INDEX_FILES = true;			// -- on gedcom files about 1 MB or larger performance will be greatly enhanced
												// -- by using index file for the searching and list pages.  Setting this variable to
												// -- true will insure that index file are used.  Index files will be updated when
												// -- a change is detected in the GEDCOM file.
$ALPHA_INDEX_LISTS = true;			// -- for very long individual and family lists, set this to true to split the list into
												// -- pages by the first letter of their last name.
												// -- NOTE: only available if $USE_INDEX_FILES = true otherwise this is ignored
$ENABLE_CLIPPINGS_CART = true;	// -- allow tree clippings to be saved in a shopping cart style for download as a
												// -- GEDCOM and imported into other users programs
$CONTACT_EMAIL = "you@yourdomain.com";					// -- this is who the user should contact for more information
$WEBMASTER_EMAIL = "webmaster@yourdomain.com";		// -- this is who the user should contact in case of errors

// -- set the default number of generations to display on the pedigree charts
if ((!isset($PEDIGREE_GENERATIONS))||($PEDIGREE_GENERATIONS=="")) $PEDIGREE_GENERATIONS= 4;
$bwidth = 200;		// -- width of DIV layer boxes
$bheight = 80;			// -- height of DIV layer boxes
$baseyoffset = 175;	// -- this is added to $yoffset to position the entire pedigree tree relative to the top of the page
$basexoffset = 20;//0;	// -- this is added to $xoffset to position the entire pedigree tree relative to the left of the page
$bxspacing = 0;		// -- spacing between boxes in the x direction
$byspacing = 2;		// -- spacing between boxes in the y direction

// -- global variables for the descendancy chart
$Dbaseyoffset = 20;//275;	// -- this is added to $yoffset to position the entire pedigree tree relative to the top of the page
$Dbasexoffset = 10;	// -- this is added to $xoffset to position the entire pedigree tree relative to the left of the page
$Dbxspacing = 0;		// -- spacing between boxes in the x direction
$Dbyspacing = 1;		// -- spacing between boxes in the y direction
$Dbwidth = 270;		// -- width of DIV layer boxes
$Dbheight = 60;			// -- height of DIV layer boxes
$Dindent = 15;			// -- width to indent descendancy boxes

// --------- HTML Display variables
$BODY_PROPERTIES = ""; 	// -- other body property tags
$BGCOLOR = "#FFFFFF";									// -- page background color
$BGIMAGE = "";													// -- page background image leave blank for none
$BOXFILLCOLOR = "#DDDDDD";								// -- fill color of boxes
$BOXBORDERCOLOR = "#CCCCCC";						// -- border color of boxes
$TABLEBORDERCOLOR = "#CCCCCC";					// -- border color of tables
$TABLEFILLCOLOR = "#DDDDDD";								// -- fill color of boxes
$TABLEBORDERSIZE = "1";										// -- border size of tables
$TABLECELLSPACING = "0";									// -- cellspacing for tables
$TABLECELLPADDING = "1";									// -- cellpadding for tables


//===================================================================================
//-- PLEASE DO NOT MODIFY LINES BELOW
//===================================================================================
$language["english"]	="lang.en.php";
$language["spanish"]	="lang.es.php";
$language["french"]	="lang.fr.php";

$factsfile["english"]	="facts.en.php";
$factsfile["spanish"]	="facts.es.php";
$factsfile["french"]		="facts.fr.php";

//require($language[$LANGUAGE]);				//-- load language file
//require("templecodes.php");		// -- load in the LDS temple code translations
require("functions.php");			// -- load function definitions

// -- check if the file exists.  If not alert the user and exit program.
/*
if (!file_exists($GEDCOM)) {
	print_header($lang["error_title"]);
	print "<h2>".$lang["error_header"]."</h2>\n";
	print $lang["for_support"]." <a href=\"$WEBMASTER_EMAIL\">$WEBMASTER_EMAIL</a>\n";
	print_footer();
	//exit;
}

//-- check for index files and update them if necessary
/*
if (($USE_INDEX_FILES)&&(!isset($BUILDING_INDEX))) {
	$indexfile = "indilist.ind";
	$updateindex=false;
	if (file_exists($indexfile)) {
		$indextime = filemtime($indexfile);
		$gedtime = filemtime($GEDCOM);
		if ($indextime < $gedtime) $updateindex=true;
	}
	else {
		$updateindex=true;
	}

if ($updateindex) {
		print_header($lang["build_title"]);
		print "<center><font class=\"error\">".$lang["build_error"]."  <br>".$lang["please_wait"]."</font>";
		print "<script>window.location='buildindex.php';</script>";
		print_footer();
		exit;                // Make sure that code below does not get executed when we redirect.
	}
}
*/
/*
// -- setup session information for tree clippings cart features
if ($ENABLE_CLIPPINGS_CART) {
	$sessionname = session_name();
	if (!isset($$sessionname)) {
		$sessionID = uniqid("");
	}
	else {
		$sessionID = $$sessionname;
	}
	session_id($sessionID);
	session_start();
	if (!session_is_registered('cart')) {
		session_register('cart');
		$cart = array();
	}
}

*/
?>
