<?php
/*=================================================
	Project: phpGedView
	File: lang.en.php
	Author: John Finlay
	Comments:
		English Language file for PHPGedView

	Change Log:
		9/24/02 - File Created

===================================================*/

//-- CONFIG FILE MESSAGES
$lang["error_title"]			= "ERROR: Cannot open GEDCOM file";
$lang["error_header"] 		= "The GEDCOM file, $GEDCOM, does not exist at the specified location.";
$lang["for_support"]		= "For support and information contact";
$lang["build_title"]			= "Building Index Files";
$lang["build_error"]		= "A new GEDCOM file was detected.";
$lang["please_wait"]		= "Please wait while Index files must be rebuilt.";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$lang["index_header"]		= "Pedigree Tree";
$lang["gen_ped_chart"]	= "$PEDIGREE_GENERATIONS Generation Pedigree Chart";
$lang["generations"]		= "Generations";
$lang["view"]					= "View";

//-- FUNCTIONS FILE MESSAGES
$lang["unable_to_find_family"]	= "Unable to find family with id";
$lang["unable_to_find_indi"]		= "Unable to find individual with id";
$lang["unable_to_find_record"]	= "Unable to find record with id";
$lang["unable_to_find_source"]	= "Unable to find source with id";
$lang["unable_to_find_repo"]	= "Unable to find Repository with id";
$lang["repo_name"]					= "Repository Name:";
$lang["address"]							= "Address:";
$lang["phone"]							= "Phone:";
$lang["source_name"]					= "Source Name:";
$lang["title"]								= "Title:";
$lang["author"]							= "Author:";
$lang["publication"]					= "Publication:";
$lang["call_number"]					= "Call Number:";
$lang["living"]								= "Living";
$lang["birth"]								= "Birth:";
$lang["death"]								= "Death:";
$lang["descend_chart"]				= "Descendancy Chart";
$lang["individual_list"]				= "Individual List";
$lang["family_list"]					= "Family List";
$lang["source_list"]					= "Source List";
$lang["place_list"]						= "Place Hierarchy";
$lang["media_list"]						= "MultiMedia List";
$lang["search"]							= "Search";
$lang["clippings_cart"]				= "Family Tree Clippings Cart";
$lang["not_an_array"]				= "Not an Array";

//-- INDIVUDUAL FILE MESSAGES
$lang["male"]					= "Male";
$lang["female"]				= "Female";
$lang["temple"]				= "LDS Temple";
$lang["temple_code"]		= "LDS Temple Code:";
$lang["status"]				= "Status";
$lang["source"]				= "Source:";
$lang["citation"]				= "Citation:";
$lang["text"]					= "Text:";
$lang["note"]					= "Note:";
$lang["unrecognized_code"]	= "Unrecognized GEDCOM Code";
$lang["indi_info"]			= "Individual Information";
$lang["pedigree_chart"]	= "Pedigree<br>Chart";
$lang["desc_chart2"]		= "Descendancy<br>Chart";
$lang["family"]				= "Family";
$lang["as_spouse"]			= "Family As<br>Spouse";
$lang["as_child"]				= "Family As<br>Child";
$lang["view_gedcom"]	= "View GEDCOM<br>Record";
$lang["add_to_cart"]		= "Add to<br>Clippings Cart";
$lang["still_living_error"]	= "This person is still living or does not have a birth or death date recorded.  All details of living persons are hidden from public view.<br>For more information contact";
$lang["name"]					= "Name:";
$lang["given_name"]		= "Given Name:";
$lang["surname"]			= "Surname:";
$lang["suffix"]					= "Suffix:";
$lang["object_note"]		= "Object Note:";
$lang["sex"]						= "Sex:";
$lang["personal_facts"]	= "Personal Facts and Details";
$lang["type"]					= "Type";
$lang["date"]					= "Date";
$lang["place_description"]	= "Place / Description";

//-- FAMILY FILE MESSAGES
$lang["family_info"]				= "Family Information";
$lang["family_group_info"]	= "Family Group Information";
$lang["husband"]					= "Husband:";
$lang["wife"]							= "Wife:";
$lang["marriage"]					= "Marriage:";
$lang["lds_sealing"]				= "LDS Sealing:";
$lang["marriage_license"]		= "Marriage License:";
$lang["media_object"]				= "Multimedia Object:";
$lang["children"]						= "Children";
$lang["no_children"]				= "No Children";
$lang["parents_timeline"]			= "Show parents on<br>timeline chart";

//-- CLIPPINGS FILE MESSAGES
$lang["clip_cart"]					= "Clippings Cart";
$lang["clip_explaination"]		= "The Family Tree Clippings Cart allows you to taking &quot;clippings&quot; from this family tree and bundle them up into a single GEDCOM file for downloading.<br><br>";
$lang["item_with_id"]			= "Item with id";
$lang["error_already"]			= "is already in your clippings cart.";
$lang["which_links"]				= "Which links from this family would you also like to add?";
$lang["just_family"]				= "Add just this family record.";
$lang["parents_and_family"]	= "Add the parents with this family record.";
$lang["parents_and_child"]	= "Add parents and children records with this family record.";
$lang["parents_desc"]				= "Add parents and all descendant records with this family record.";
$lang["continue"]					= "Continue Adding";
$lang["which_p_links"]			= "Which links from this person would you also like to add?";
$lang["just_person"]				= "Add just this person.";
$lang["person_parents_sibs"]= "Add this person, his parents, and siblings.";
$lang["person_ancestors"]		= "Add this person and his direct line ancestors.";
$lang["person_ancestor_fams"]="Add this person, his direct line ancestors, and their families.";
$lang["person_spouse"]			= "Add this person, his spouse, and children.";
$lang["person_desc"]				= "Add this person, his spouse, and all descendant records.";
$lang["unable_to_open"]		= "Unable to open Clippings folder for writing";
$lang["person_living"]			= "This person is living.  Personal details will not be included.";
$lang["download"]					= "Right click (control-click on a Mac) on the links below and select &quot;Save target as&quot; to download the files.";
$lang["media_files"]				= "Media Files referenced in this GEDCOM";
$lang["cart_is_empty"]			= "Your tree clippings cart is empty.";
$lang["id"]								= "ID";
$lang["name_description"]		= "Name / Description";
$lang["remove"]						= "Remove";
$lang["empty_cart"]				= "Empty Cart";
$lang["download_now"]			= "Download Now";

//-- PLACELIST FILE MESSAGES
$lang["connections"]				= "Place connections found<br>View Results Now";
$lang["top_level"]					=	"Top Level";
$lang["form"]							= "Places are encoded in the form: ";
$lang["default_form"]				= "City, County, State/Province, Country";
$lang["unknown"]					= "Unknown";

//-- MEDIALIST FILE MESSAGES
$lang["multi_title"]					= "MultiMedia Object List";
$lang["media_found"]				= "Media Objects found";
$lang["view_person"]				= "View Person";
$lang["view_family"]				= "View Family";
$lang["view_source"]				= "View Source";

//-- SEARCH FILE MESSAGES
$lang["search_gedcom"]			= "Search GEDCOM file";
$lang["enter_terms"]				= "Enter Search Terms:";
$lang["soundex_search"]			= "Soundex Last Name Search:";
$lang["search_results"]			= "Search Results";
$lang["sources"]						= "SOURCES";

//-- SOURCELIST FILE MESSAGES
$lang["source_list"]				= "Source List";
$lang["sources_found"]			= "Sources found";

//-- SOURCE FILE MESSAGES
$lang["source_info"]				= "Source Information";
$lang["other_records"]			= "Other Records that link to this source:";
$lang["people"]						= "PEOPLE";
$lang["families"]						= "FAMILIES";

//-- BUILDINDEX FILE MESSAGES
$lang["building_indi"]				= "Building Individual and Family Index";
$lang["building_index"]			= "Building Index Lists";
$lang["detected chage"]			= "phpGedView detected a change in the GEDCOM file $GEDCOM.  Index files must now be rebuilt before proceeding.";
$lang["please_be_patient"]		= "PLEASE BE PATIENT";
$lang["reading_file"]				= "Reading Gedcom File";
$lang["flushing"]						= "Flushing contents";
$lang["found_record"]			= "Found record";
$lang["exec_time"]					= "Total Execution time:";
$lang["unable_to_create_index"]="Unable to create index file.  Make sure write permissions are available to the phpGedViewDirectory.  Permissions may be restored once index files are written.";
$lang["indi_complete"]			= "Individual Index file update complete.";
$lang["family_complete"]		= "Family Index file update complete.";
$lang["source_complete"]		= "Source Index file update complete.";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$lang["total_fams"]					= "Total Families";
$lang["total_indis"]					= "Total Individuals";
$lang["starts_with"]				= "Starts With:";
$lang["person_list"]				= "Person List:";
$lang["paste_person"]			= "Paste Person";

//-- TIMELINE FILE MESSAGES
$lang["age"]								= "Age";
$lang["timeline_title"]				= "phpGedView Timeline";
$lang["timeline_chart"]			= "Timeline Chart";
$lang["remove_person"]			= "Remove Person";
$lang["show_age"]					= "Show Age Marker";
$lang["add_another"]				= "Add Another person to chart:<br>Person ID:";
$lang["find_id"]						= "Find ID";
$lang["show"]							= "Show";
$lang["year"]							= "Year:";
$lang["timeline_instructions"]= "In the most recent browsers you can click and drag the boxes around on the chart.";

?>