{* 	responsibility_find.tpl
	
	Description:  	A paginated listing of responsibilities.

	@author 	Matt Lindberg
	@created	04-06-2005
	@modified	04-06-2005
	
	Variable Dictionary

	$rightcolumntitle		- title displayed in upper-left corner of right content column
	$totalrespons			- the total # of responsibilities found
	$linkallpageback		- hyperlink, if == 'none' will not be displayed
	$linkonepageback		- ''
	$linkallpageforward		- ''
	$linkonepageforward		- ''
	$respons				- array of responsibility information
		.linkedit
		.linkdetail
		.linkdelete
		.name
		.description
	$pagenumber
	$totalpages
*}

{include file="header.tpl"}
{* Add Extra Left Column Content Starting Here *}


{* End Left Column Content *}
</div>


{* Start Right Column Content *}
<div id="rightcolumn">

{include file="actiontitle.tpl"}


{* Start Find Responsibility List *}
<table class="searchresult">
	<tr class="searchresultpages">
		<td>{$totalrespons} responsibilities found</td>
		<td class="pagenumber">
		
		{if $linkallpageback eq none}
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		{else}
		<a href="{$linkallpageback}">&lt;&lt;</a>&nbsp;&nbsp;&nbsp;
		{/if}
		
		{if $linkonepageback eq none}
		&nbsp;&nbsp;
		{else}
		<a href="{$linkonepageback}">&lt;&nbsp;</a>
		{/if}
		
		page {$pagenumber} of {$totalpages} 
		
		{if $linkonepageforward eq none}
		&nbsp;&nbsp;&nbsp;&nbsp;
		{else}
		<a href="{$linkonepageforward}">&gt;</a>&nbsp;&nbsp;&nbsp;
		{/if}
		
		{if $linkallpageforward eq none}
		&nbsp;&nbsp;
		{else}
		<a href="{$linkallpageforward}">&gt;&gt;</a></td>
		{/if}
		
	</tr>
	
	<tr classs="searchresultheader">
		<th style="width:70%">Name and Description</th>
		<th style="width:30%">Actions</th>
	</tr>
	
	<!-- A single responsibility summary element -->
	{section name=responnum loop=$respons}
	{strip}
	<tr class="searchresultelement">
		<td width="300"><a href="{$respons[responnum].linkdetail}">{$respons[responnum].name}</a><br/>{$respons[responnum].description|replace:"\n":"<br/>"}</td>
	
		<td class="searchresultaction">
			<a href="{$respons[responnum].linkedit}">edit</a><br/>
			<a href="#" onClick="javascript:confirmRequest('{$respons[responnum].linkdelete}','Are you sure you want to delete this responsibility?\n\nThis cannot be undone.')">delete</a>
		</td>
	</tr>
	
	<tr>
		<td colspan="2"><hr class="searchresultseperator"/></td>
	</tr>
	{/strip}
	{/section}
	<!-- End a responsibility summary element -->
	
	<tr class="searchresultpages">
		<td>{$totalrespons} responsibilities found</td>
		<td class="pagenumber">
		
		{if $linkallpageback eq none}
		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		{else}
		<a href="{$linkallpageback}">&lt;&lt;</a>&nbsp;&nbsp;&nbsp;
		{/if}
		
		{if $linkonepageback eq none}
		&nbsp;&nbsp;
		{else}
		<a href="{$linkonepageback}">&lt;&nbsp;</a>
		{/if}
		
		page {$pagenumber} of {$totalpages} 
		
		{if $linkonepageforward eq none}
		&nbsp;&nbsp;&nbsp;&nbsp;
		{else}
		<a href="{$linkonepageforward}">&gt;</a>&nbsp;&nbsp;&nbsp;
		{/if}
		
		{if $linkallpageforward eq none}
		&nbsp;&nbsp;
		{else}
		<a href="{$linkallpageforward}">&gt;&gt;</a></td>
		{/if}
		
	</tr>
</table>

{* End Find Responsibility List *}


</div>
{include file="footer.tpl"}