{* 	member_edit.tpl
	
	Description:  	The main editing form for a single member.  Contains multiple section that can be displayed or hidden
			using css id's and javascript to display and hide individual sections.

	@author 	Matt Lindberg
	@created	04-03-2005
	@modified	04-03-2005
	
	Variable Dictionary
	
	$memberid					- the id of the member
	$backbuttonlink				- url string to attach to the 'back' button
	$sections				
		.main
			.displayid
			.login				- Object: form input
			.email				- Object: form input
			.rankid				- Object: form input - the member's rank id
			.rankname
			.formaction			- the url to submit main form data to via 'Save'
			.characterimage		- path to character image
			.sex				- Object: form input - 'male' or 'female'
			.charactername		- Object: form input
			.raceid				- Object: form input - race id of main character
			.racename
			.classid			- Object: form input - class id of main character
			.classname
			.level				- Object: form input - integer level of main character
			.thottbot			- Object: form input - 'yes' or 'no'
		.aliases
			.createaliaslink		- action link for new alias creation
			.characters			- array of all alias characters for a member
				.name			
				.racename
				.classname
				.level
				.picfile
				.deletelink
				.editlink
				.setasmainlink	
		.deedlog
			.adddeedslink
			.deeds				- array of all deeds added to a member's deed log
				.desc
				.timescompleted	- # of times a members deed has been completed
				.deletelink
				.detailslink
				.guilddp		- # of deedpoints for a single completion of this deed
				.questdp		- "  "
				.pvpdp			- "  " 
			.totalguilddp
			.totalquestdp
			.totalpvpdp
		.responlist
			.chooseresponlink	- action link for choosing member responsibilities
			.memberrespon		- array of responsibilities assigned to a single member
				.desc
				.detailslink
				.markcompletelink
				.completebydate
				.overdue
			.rankrespon			- array of responsibilities assigned to a rank, inherited by the member
				.desc
				.detailslink
				.markcompletelink
				.completebydate
				.overdue		- 'yes' or 'no'
		.notes
			.notes
				.datecreated
				.title
				.readlink
				.deletelink
			.form
				.submitaction
				.title			- Object:  form input
				.note			- Object:  form input
	$rankoptions				- associative array of rank options in the form <rank> => <rankid>
	$raceoptions				- associative array of race options in the form <race> => <raceid>
	$classoptions				- associative array of class options in the form <class> => <classid>
	$leveloptions				- associative array of level options in the form <level> => <level>
	$characterpics
		.male					- array of male character pictures
			.raceid
			.picfile
		.female					- array of female character pictures
			.raceid
			.picfile
	$displaysection				- the id of a member edit section that is displayed when the page first renders.  If $displaysection
								  is set to "false", the main section will be displayed first
*}
{include file="header.tpl"}
{* Add Extra Left Column Content Starting Here *}


{* End Left Column Content *}
</div>

{* Start Right Column Content *}
<div id="rightcolumn">
{include file="actiontitle.tpl"}



<SCRIPT type="text/javascript">
{* Changes the character avatar displayed in a member edit form using a sex radio box and and race drop-down menu *}
{literal}
function showCharacterImage() {
	<!--
	if( !document.images ) {
		return false;
	}
	else {
		var race = document.memberedit.{/literal}{$sections.main.raceid->name}{literal}.options[document.memberedit.{/literal}{$sections.main.raceid->name}{literal}.selectedIndex].value;
		var sex = null;
		if(document.memberedit.{/literal}{$sections.main.sex->name}{literal}.length) {
			for( var i=0; i < document.memberedit.{/literal}{$sections.main.sex->name}{literal}.length; i++) {
				if( document.memberedit.{/literal}{$sections.main.sex->name}{literal}[i].checked) {
					sex = document.memberedit.{/literal}{$sections.main.sex->name}{literal}[i].value;
				}
			}
		}
		document.images.characterimage.src = charpics[sex][race];
		return true;
	}
	-->
}
{/literal}


{* Initialize the character picture arrays *}
var charpics = new Array();
var malepics = new Array();
var fempics = new Array();

{section name=fempictures loop=$characterpics.female}
fempics[{$characterpics.female[fempictures].raceid}] = "{$characterpics.female[fempictures].picfile}";
{/section}

{section name=malepictures loop=$characterpics.male}
malepics[{$characterpics.male[malepictures].raceid}] = "{$characterpics.male[malepictures].picfile}";
{/section}

charpics["m"] = malepics;
charpics["f"] = fempics;



// toggler array for main member section
var mainOn = new Array("mainsection");
var mainOff = new Array("aliassection","deedlogsection","responsection","notesection");
// " " for member aliases section
var aliasOn = new Array("aliassection");
var aliasOff = new Array("mainsection","deedlogsection","responsection","notesection");
// " " for deedlog section
var deedOn = new Array("deedlogsection");
var deedOff = new Array("aliassection","mainsection","responsection","notesection");
// " " for responsibility section
var responOn = new Array("responsection");
var responOff = new Array("aliassection","deedlogsection","mainsection","notesection");
// " " for notes section
var notesOn = new Array("notesection");
var notesOff = new Array("aliassection","deedlogsection","responsection","mainsection");
</SCRIPT>

{if $backbuttonlink != nodisplay}
<div id="backbutton"><a href="{$backbuttonlink}"">Back</a></div>
{/if}
<div id="viewtoolbox">
	Member sections:&nbsp;&nbsp;
	<a class="anchorSubmenuOff" href="#" onclick="toggleMultiDisplay(mainOn,mainOff)">Main</a>&nbsp;&nbsp;
	<a class="anchorSubmenuOff" href="#" onclick="toggleMultiDisplay(aliasOn,aliasOff)">Aliases</a>&nbsp;&nbsp;
	<a class="anchorSubmenuOff" href="#" onclick="toggleMultiDisplay(deedOn,deedOff)">Deedlog</a>&nbsp;&nbsp;
	<a class="anchorSubmenuOff" href="#" onclick="toggleMultiDisplay(responOn,responOff)">Responsibilities</a>&nbsp;&nbsp;
	<a class="anchorSubmenuOff" href="#" onclick="toggleMultiDisplay(notesOn,notesOff)">Notes</a> 
</div>

<!-- Begin main member editing section -->
<div id="mainsection">
<form name="memberedit" action="{$sections.main.formaction}" method="POST">
<table>
<tr>
	<td></td>
	<th>Standard Information</th>
	<td></td>
</tr>

<tr>
	<td><label for="">Login</label></td>
	<td colspan="2"><input type="text" name="{$sections.main.login->name}" size="60" value="{$sections.main.login->value}" class="textFormInputBox"/></td>
</tr>

<tr>
	<td><label for="">E-mail</label></td>
	<td colspan="2"><input type="text" name="{$sections.main.email->name}" size="60" id="" value="{$sections.main.email->value}" class="textFormInputBox"/><br/></td>
</tr>
<tr>
	<td><label>Rank</label></td>
	<td colspan="2">
	{html_options class=textFormInputBox name=$sections.main.rankid->name options=$rankoptions selected=$sections.main.rankid->value}
	</td>
</tr>
<tr>
	<td colspan="3" height="10px"></td>
</tr>
<tr>
	<td></td>
	<th>Main Character</th>
	<td></td>
</tr>
<tr>
	<td><label for="">Name</label></td>
	<td colspan="2">
	<input name="{$sections.main.charactername->name}" type="text" size="60" value="{$sections.main.charactername->value}" class="textFormInputBox"/>
	</td>
</tr>
<tr>
	<td><label for="">Sex</label></td>
	<td colspan="2">
	<span>male</span>
	<input name="{$sections.main.sex->name}"  type="radio" value="m" {if $sections.main.sex->value == "m"}checked{/if} onClick="showCharacterImage()"/>&nbsp;
	<span>female</span>
	<input name="{$sections.main.sex->name}"  type="radio" value="f" {if $sections.main.sex->value == "f"}checked{/if} onClick="showCharacterImage()"/>&nbsp;
	</td>
</tr>
<tr>
	<td><label for="">Race</label></td>
	<td>
	<select name="{$sections.main.raceid->name}" class="textFormInputBox" onChange="showCharacterImage()">
	{html_options options=$raceoptions selected=$sections.main.raceid->value}
	</select>
	</td>
	<td>
	<img name="characterimage" src="{$sections.main.characterimage}">
	</td>
</tr>
<tr>
	<td><label for="">Class</label></td>
	<td colspan="2">
	{html_options class=textFormInputBox name=$sections.main.classid->name options=$classoptions selected=$sections.main.classid->value}
</td>
</tr>
<tr>
	<td><label for="">Level</label></td>
	<td colspan="2">
	{html_options class=textFormInputBox name=$sections.main.level->name options=$leveloptions selected=$sections.main.level->value}
	</td>
</tr>
<tr>
	<td><label for="">Enable thottbot profile link?</label></td>
	<td colspan="2">
	<span>yes</span>
	<input name="{$sections.main.thottbot->name}" {if $sections.main.thottbot->value == "1"}checked{/if} type="radio" value="1"/>&nbsp;
	<span>no</span>
	<input name="{$sections.main.thottbot->name}" {if $sections.main.thottbot->value == "0"}checked{/if} type="radio" value="0"/>&nbsp;
	</td>
</tr>
<tr>
	<td></td>
	<td colspan="2"><input type="submit" name="Submit" value="Save" class="buttonSubmit"/></td>
</tr>
<input type="hidden" name="{$memberid->name}" value="{$memberid->value}"/>
</table>
</form>
</div>
<!-- End main member editing section -->





<!-- Begin member aliases section -->
<div id="aliassection">


<table class="searchresult">
<tr>
	<td colspan="5"><a class="anchorFunction" href="{$sections.aliases.createaliaslink}">new alias</a></td>
</tr>
<tr class="searchresultheader">
	<th style="width: 96">Alias</th>
	<th style="width: 80">Race</th>
	<th style="width: 80">Class</th>
	<th style="width: 80">Level</th>
	<th style="width: 120">Actions</th>
</tr>

{section name=aliases loop=$sections.aliases.characters}
<!-- Begin single alias summary row -->
<tr class="searchresultelement">
	<td style="text-align: center; width: 96px;">
		<img src="{$sections.aliases.characters[aliases].picfile}"><br/>{$sections.aliases.characters[aliases].name}
	</td>
	<td>{$sections.aliases.characters[aliases].racename}</td>
	<td>{$sections.aliases.characters[aliases].classname}</td>
	<td>{$sections.aliases.characters[aliases].level}</td>
	<td>
		<a class="anchorFunction" onClick="javascript:confirmRequest('{$sections.aliases.characters[aliases].deletelink}','Do you really want to delete this alias?\n\nThis cannot be undone.');"href="#">delete</a><br/>
		<a class="anchorFunction" href="{$sections.aliases.characters[aliases].editlink}">edit</a><br/>
		<a class="anchorFunction" onClick="javascript:confirmRequest('{$sections.aliases.characters[aliases].setasmainlink}','Set {$sections.aliases.characters[aliases].name} as main character?')" href="#">set as main</a>
	</td>	
</tr>
<!-- End alias summary row -->
<tr>
	<td colspan="5"><hr class="searchresultseperator"/></td>
</tr>
{/section}

</table>
</div>
<!-- End member aliases section -->





<!-- Begin deed log section -->
<div id="deedlogsection">
<table class="searchresult">
<tr>
	<td colspan="3"><a class="anchorFunction" href="{$sections.deedlog.adddeedslink}">add deeds</a></td>
	<th colspan="4">Deedpoints</th>
</tr>
<tr class="searchresultheader">
	<th colspan="2" style="width: 65%;">Deed</th>
	<th style="width: 10%;">Times Completed</th>
	<th style="width: 5%;">Guild</th>
	<th style="width: 5%;">Quest</th>
	<th style="width: 5%;">Pvp</th>
	<th style="width: 10%;">Total</th>
</tr>

{section name=deedlog loop=$sections.deedlog.deeds}
<!-- Start deed row -->
<tr class="rowTableList1">
	<td>
	{$sections.deedlog.deeds[deedlog].desc}
	</td>
	<td style="text-align: right;">
		<a class="anchorFunction" onClick="javascript:confirmRequest('{$sections.deedlog.deeds[deedlog].deletelink}','Do you really want to delete this deedlog entry?\n\nThis cannot be undone.');" href="#">delete</a>&nbsp;&nbsp;
		
	</td>
	<td class="cellData">{$sections.deedlog.deeds[deedlog].timescompleted}</td>
	<td class="cellData">{$sections.deedlog.deeds[deedlog].guilddp*$sections.deedlog.deeds[deedlog].timescompleted}</td>
	<td class="cellData">{$sections.deedlog.deeds[deedlog].questdp*$sections.deedlog.deeds[deedlog].timescompleted}</td>
	<td class="cellData">{$sections.deedlog.deeds[deedlog].pvpdp*$sections.deedlog.deeds[deedlog].timescompleted}</td>
	<td class="cellData">{$sections.deedlog.deeds[deedlog].guilddp*$sections.deedlog.deeds[deedlog].timescompleted+$sections.deedlog.deeds[deedlog].questdp*$sections.deedlog.deeds[deedlog].timescompleted+$sections.deedlog.deeds[deedlog].pvpdp*$sections.deedlog.deeds[deedlog].timescompleted}</td>	
</tr>
<!-- End deed row -->
{/section}

<tr>
	<td colspan="7"><hr/></td>
</tr>

<tr>
	<td colspan="3"></td>
	<th colspan="4">Deedpoint Grand Total</th>
</tr>
<tr class="searchresultheader">
	<td colspan="3"></td>
	<th>Guild</th>
	<th>Quest</th>
	<th>Pvp</th>
	<th>Total</th>
</tr>

<tr>
	<td colspan="3"></td>
	<td class="cellData">{$sections.deedlog.totalguilddp}</td>
	<td class="cellData">{$sections.deedlog.totalquestdp}</td>
	<td class="cellData">{$sections.deedlog.totalpvpdp}</td>
	<td class="cellData">{$sections.deedlog.totalguilddp+$sections.deedlog.totalquestdp+$sections.deedlog.totalpvpdp}</td>
</tr>
</table>
</div>
<!-- End deed log section -->




<!-- Begin responsibilities section -->
<div id="responsection">
<table class="searchresult">
<tr>
	<td colspan="7"><a class="anchorFunction" href="{$sections.responlist.chooseresponlink}">choose responsibilities</a></td>
</tr>
<tr class="searchresultheader">
	<th colspan="5">Member responsibilities</th>
</tr>
<tr class="searchresultheader">
	<th colspan="2" style="width: 60%;">Name</th>
	<th style="width: 15%;">Complete by</th>
	<th style="width: 5%;">Due</th>
	<th style="width: 20%;">Actions</th>
</tr>
<!-- Start member responsibilities -->

{section name=memberrespons loop=$sections.responlist.memberrespon}
<!-- Start single responsibility row -->
<tr class="rowTableList1">
	<td>
	{$sections.responlist.memberrespon[memberrespons].desc}
	</td>
	<td style="text-align: right;">
		<a class="anchorFunction" href="{$sections.responlist.memberrespon[memberrespons].detailslink}">details</a>
	</td>
	<td class="cellData">{$sections.responlist.memberrespon[memberrespons].completebydate}</td>
	
	{if $sections.responlist.memberrespon[memberrespons].overdue == 'yes'}
	<td class="cellData" height="23px">
	<img src="./img/small_red_flag.png"/>
	</td>
	{else}
	<td class="cellData" height="23px">
	</td>
	{/if}
	<td>
		mark complete
	</td>	
</tr>
<!-- End single responsibility row -->
{/section}
<!-- End member responsibilities -->
<tr>
	<td colspan="5"><hr/></td>
</tr>


<!-- Start rank responsibilities -->
<tr class="searchresultheader">
	<th colspan="5">Rank responsibilities</th>
</tr>
<tr class="searchresultheader">
	<th colspan="2" style="width: 60%;">Name</th>
	<th style="width: 15%;">Complete by</th>
	<th style="width: 5%;">Overdue</th>
	<th style="width: 20%;">Actions</th>
</tr>

{section name=rankrespons loop=$sections.responlist.rankrespon}
<!-- Start single responsibility row -->
<tr class="rowTableList1">
	<td>
	{$sections.responlist.rankrespon[rankrespons].desc}
	</td>
	<td style="text-align: right;">
		<a class="anchorFunction" href="{$sections.responlist.rankrespon[rankrespons].detailslink}">details</a>
	</td>
	<td class="cellData">{$sections.responlist.rankrespon[rankrespons].completebydate}</td>
	{if $sections.responlist.rankrespon[rankrespons].overdue == 'yes'}
	<td class="cellData" height="23px">
	<img src="./img/small_red_flag.png"/>
	</td>
	{else}
	<td class="cellData" height="23px">
	</td>
	{/if}
	<td>
		<a class="anchorFunction" href="{$sections.responlist.rankrespon[rankrespons].markcompletelink}">mark complete</a>
	</td>	
</tr>
<!-- End single responsibility row -->
{/section}

<!-- End rank responsibilities -->

</table>
</div>
<!-- End responsibilities section -->





<!-- Begin notes section -->
<div id="notesection">
<form action="{$sections.notes.form.submitaction}" method="post">
<table class="searchresult">

<tr class="searchresultheader">
	<th style="width: 15%;">Date Created</th>
	<th colspan="2" style="width: 70%;">Title</th>
	<th style="width: 15%">Actions</th>
</tr>
	
{section name=membernotes loop=$sections.notes.notes}
<!-- Start member note entry -->
<tr class="rowTableList1">
	<td class="cellData">{$sections.notes.notes[membernotes].datecreated}</td>
	<td>
	{$sections.notes.notes[membernotes].title}
	</td>
	<td>
		<a class="anchorFunction" onClick="javascript:window.open('{$sections.notes.notes[membernotes].readlink}', 'popupWindow', 'location=no,menubar=no,width=300,height=200,scrollbar=yes,resizable=yes')" href="#">read</a>
	</td>
	<td>
		<a class="anchorFunction" onClick="javascript:confirmRequest('{$sections.notes.notes[membernotes].deletelink}','Do you really want to delete this note?\n\nThis cannot be undone.');" href="#">delete</a>
	</td>	
</tr>
<!-- End member note entry -->
{/section}
<tr>
	<td colspan="4"><hr/></td>
</tr>
<!-- Start new note input form -->
<tr>
<td></td>
<th colspan="3">Enter New Note</th>
</tr>
<tr>
<td><label for="">Title:</label></td>
<td colspan="3"><input type="text" name="{$sections.notes.form.title->name}" size="60" id="" value="{$sections.notes.form.title->value}" class="textFormInputBox"/></td>
</tr>
<tr>
<td><label for="">Note:</label></td>
<td colspan="3"><textarea class="textFormInputBox" name="{$sections.notes.form.note->name}" rows="5" cols="50" id="">{$sections.notes.form.note->value}</textarea><br/>
</td>
</tr>
<tr>
	<td></td>
	<td colspan="3"><input class="buttonSubmit" type="submit" name="Submit" value="Save"/></td>
</tr>
<!-- End new note input form -->

</table>
</form>
</div>
<!-- End notes section -->

</div>
{include file="footer.tpl"}
<SCRIPT type="text/javascript">
{if $displaysection==mainsection || $displaysection=="false" }
toggleMultiDisplay(mainOn,mainOff);
{elseif $displaysection==aliassection }
toggleMultiDisplay(aliasOn,aliasOff);
{elseif $displaysection==deedlogsection}
toggleMultiDisplay(deedOn,deedOff);
{elseif $displaysection==responsection}
toggleMultiDisplay(responOn,responOff);
{elseif $displaysection==notesection}
toggleMultiDisplay(notesOn,notesOff);
{else}
toggleMultiDisplay(mainOn,mainOff);
{/if}
</SCRIPT>
<script type="text/javascript">
showCharacterImage();
</script>