<?php
// Collection.php


/**
 * A collection of objects.
 * 
 */
class Collection
{
	
	/** 
	 * Constructor.
	 *
	 * @access public
	 */
	function Collection()
	{
		trigger_error(__ERROR.": Can't instantiate Collection directly, must subclass");
	}
	
	/**
	 * Gets the nth item in the Collection.
	 *
	 * @param $item integer
	 * @access public
	 */
	function get($item)
	{
		trigger_error(__ERROR.":Must override get() method in subclass.");
	}
	
	/**
	 * Gets the number of items in this collection.
	 *
	 * @access public
	 * @return int
	 */
	function size()
	{
		trigger_error(__ERROR.": Must override size() method in subclass.");
	}
	
	/**
	 * Gets an Iterator for traversing this collection.
	 *
	 * @access public
	 * @return Iterator
	 */
	function createIterator()
	{
		trigger_error(__ERROR.": Must overview createIterator() method in subclass.");
	}
	
	
}
?>