<?php
// MySQLDataAccess.php

/**
 * Database access class for MySQL.   
 *
 */
class MySQLDataAccess 
{
	// MySQL connection resource
	var $db_conn;
	
	// MySQLStatementBuilder
	var $statement_builder;
	
	
	/**
	 * Constructor.
	 *
	 * @param $host string
	 * @param $user string
	 * @param $pass string
	 * @param $db string
	 * @access public
	 */
	function MySQLDataAccess($host, $user, $pass, $db)
	{
		global $__CS; 
		$__CS->EnterMethod("MySQLDataAccess");
		
		// Connect to mySQL DMS
		if( !( $this->db_conn = @ mysql_connect($host, $user, $pass))) {
			trigger_error(mysql_error());
		}
		// Select database
		if( !(mysql_select_db($db, $this->db_conn) )) {
			 trigger_error(mysql_error());
		}
		$this->statement_builder = NULL;
		
		$__CS->ExitMethod("MySQLDataAccess");
	}
	
	
	/** 
	 * Returns a collection of MySQL query results.
	 *
	 * @param $sql string
	 * @access public
	 * @return DBRowCollection
	 */
	function & fetchCollection($sql)
	{
		global $__CS;
		$__CS->EnterMethod("fetchCollection");
		$__CS->SendVar($sql,"sql");
		$__CS->SendSQL($sql);
		
		include_once('lib/db/DBRowCollection.php');
		
		$coll =& new DBRowCollection(& $this, $sql);
		
		$__CS->ExitMethod("fetchCollection");
		return $coll;
	}
	
	
	/**
	 * Runs a MySQL Select query and returns results as an array DBRows.
	 *
	 * @param $sql string
	 * @access public
	 * @return DBRow array
	 */
	function & query($sql)
	{
		global $__CS;
		$__CS->EnterMethod("query");
		$__CS->SendVar($sql,"sql");
		$__CS->SendSQL($sql);
		
		
		// Run query
		if( !($result = @ mysql_query($sql, $this->db_conn) ) ) {
			$__CS->SendError("MySQL query failed.");
			$__CS->ExitMethod("query");
		 	return false;
		}
		include_once('lib/db/DBRow.php');
		
		$row_count = mysql_num_rows($result);
		
		$rows = array();
		for( $i=0; $i<$row_count; $i++) {
			$__CS->SendNote("Fetching query result ".$i.".");
			
			$next_row =& new DBRow();
			$arr = @ mysql_fetch_array($result);
			foreach($arr as $key => $value) {
				$__CS->SendNote("Adding DBRow column ".$key."=>".$value);
				$next_row->addColumn($key,$value);
			}
			
			$rows[] =& $next_row;
		}
		
		$__CS->ExitMethod("query");
		
		return $rows;           
	}
	
	
	/**
	 * Runs a MySQL Insert,Update,or Delete statement.
	 *
	 * @param $sql string
	 * @access public
	 * @return boolean
	 */
	function update($sql)
	{
		global $__CS;
		$__CS->EnterMethod("update");
		$__CS->SendSQL($sql);
		
		if( !(mysql_query($sql, $this->db_conn) )) {
		
			$__CS->SendNote("MySQL query failed.");
			$__CS->SendNote(mysql_error());
			$__CS->ExitMethod("update");
			return false;
		}
		else {
			$__CS->ExitMethod("update");
			return mysql_insert_id();
		}
	}
	
	
	/**
	 * Gets a MySQL statement builder for auto building simple queries.
	 *
	 * @access public
	 */
	function & getStatementBuilderInstance()
	{
		global $__CS; 
		$__CS->EnterMethod("getStatementBuilderInstance");
		
		if( $this->statement_builder == NULL ) {
			include( 'lib/db/MySQLStatementBuilder.php');
			$this->statement_builder =& new MySQLStatementBuilder();
		}
		
		$__CS->ExitMethod("getStatementBuilderInstance");
		return $this->statement_builder;
	}
	
	
	/**
	 * Checks whether a MySQL error has occured.
	 *
	 * @access public
	 * @return boolean
	 */
	function isError()
	{
		global $__CS;
		$__CS->EnterMethod("isError");
		$__CS->ExitMethod("isError");
		
		return mysql_error();
	}
	
}

?>