<?php
// DBRow.php

/**
 * A single database row of column=>value pairs.
 *
 */
class DBRow
{
	var $columns;
	
	/**
	 * Constructor.
	 *
	 * @access public
	 */
	function DBRow()
	{
		global $__CS; 
		$__CS->EnterMethod("DBRow");
		
		$this->columns = array();
		
		$__CS->ExitMethod("DBRow");
	}
	
	/**
	 * Adds a new column=>value pair.
	 *
	 * @param $name string
	 * @param $value
	 * @access public
	 */
	function addColumn($name, $value)
	{
		global $__CS; 
		$__CS->EnterMethod("addColumn");
		$__CS->SendVar($name,"name");
		$__CS->SendVar($value,"value");
		
		$this->columns[$name] = $value;
		
		$__CS->ExitMethod("addColumn");
	}
	
	/**
	 * Gets a column value.
	 *
	 * @param $name string
	 * @access public
	 */
	function getValue($name)
	{
		global $__CS; 
		$__CS->EnterMethod("getValue");
		$__CS->SendVar($name,"name");
		
		if( array_key_exists($name,$this->columns) ) {
			$__CS->ExitMethod("getValue");
			return $this->columns[$name];
		}
		else {
			//trigger_error(__ERROR.": Array key ".$name." does not exist in this Row");
		}
	}
	
	/**
	 * Returns an associative array of column=>value pairs.
	 *
	 * @access public
	 * @return array
	 */
	function getColumns()
	{
		global $__CS; 
		$__CS->EnterMethod("getColumns");
		$__CS->ExitMethod("getColumns");
		
		return $this->columns;
	}
	
}
?>