<?php
// ResponsibilitySearchView.php
include( 'core/responsibilities/views/ResponsibilityView.php');


/**
 * 
 * @author Matthew Lindberg
 *
 */
class ResponsibilitySearchView extends ResponsibilityView
{
	// The current page number of search results
	var $page_number;
	
	// Total number of pages
	var $tot_pages;
	
	// The total number of search results
	var $num_search_results;
	
	// DBRow collection
	var $result_rows;
	
	
	/**
	 * Constructor.
	 *
	 * @access public
	 */
	function ResponsibilitySearchView(& $timer, & $respon_model)
	{
		global $__CS;
		$__CS->EnterMethod("ResponsibilitySearchView");
		$__CS->SendObject($timer,"timer");
		$__CS->SendObject($respon_model,"respon_model");
		
		// instantiate parent class
		parent::ResponsibilityView(& $timer, & $respon_model);
		
		// Set all template variables
		$this->addToPageTitle("Search Responsibilities");
		$this->setTemplate("responsibility_find.tpl");
		
		$this->page_number 			= NULL;
		$this->tot_pages			= NULL;
		$this->num_search_results 	= NULL;
		$this->results_rows 		= NULL;
		
		$__CS->ExitMethod("ResponsibilitySearchView");
	}
	
	/**
	 * Sets the search views page number.
	 *
	 * @param $num integer
	 * @access public
	 * @return void
	 */
	function setPageNumber($num)
	{
		global $__CS;
		$__CS->EnterMethod("setPageNumber");
		$__CS->SendVar($num,"num");
		
		$this->page_number = $num;
		
		$__CS->ExitMethod("setPageNumber");
	}
	
	function setTotalPages($num)
	{
		$this->tot_pages = $num;
	}
	
	/**
	 * Sets the total number of search results.
	 *
	 * @param $num integer
	 * @access public
	 * @return void
	 */
	function setNumberOfSearchResults($num)
	{
		global $__CS;
		$__CS->EnterMethod("setNumberOfSearchResults");
		
		$this->num_search_results = $num;
		
		$__CS->ExitMethod("setNumberOfSearchResults");
	}
	
	/**
	 * Sets the views collection of search result rows.
	 *
	 * @param $row_collection arrayDBRows
	 * @access public
	 * @return void
	 */
	function setResultRows(& $rows)
	{
		global $__CS;
		$__CS->EnterMethod("setResultRows");
		$__CS->SendObject($rows,"rows");
		
		$this->result_rows =& $rows;
		
		$__CS->ExitMethod("setResultRows");
	}
	
	
	/**
	 * Sets all the Smarty template variables for this View.
	 *
	 * @access private
	 */
	function init()
	{
		global $__CS;
		parent::init();
		
		// Set module submenu
		$this->tpl->assign("modulemenu" , array(
													array("name" 	=> "search",
														  "class" 	=> "on",
														  "href"	=> $this->makeActionLink(__RESPON,__RESPON_SEARCH)
														 ),
													array("name"	=> "new",
														  "class"	=> "off",
														  "href"	=> $this->makeActionLink(__RESPON,__RESPON_NEW,array("pageback" => $this->page_number))
														 )
											    ));
				   
		// builds paginated result view from search results rows
		if( $this->result_rows == NULL ) { trigger_error(__ERROR."DBRow search results not set in ResponsibilitySearchView.  Cannot Render View."); }
		$respons = array();
		$iter =& $this->result_rows->createIterator();
		
		while( !$iter->isDone() ) {
			$row =& $iter->fetch();
			$this->model->loadFromDBRow(& $row);
			
			$next_respon = array();
			$next_respon['name'] 			= $this->model->getResponName();
			$next_respon['description']		= $this->model->getResponDesc();

			// Next, create action links for responsibility result
			$respon_id 						= $this->model->getResponID();
			$next_respon['linkedit'] 		= $this->makeActionLink(__RESPON,__RESPON_EDIT,array("id" => $respon_id, "pageback" => $this->page_number));
			$next_respon['linkdetail'] 		= $this->makeActionLink(__RESPON,__RESPON_EDIT,array("id" => $respon_id, "pageback" => $this->page_number));
			$next_respon['linkdelete'] 		= $this->makeActionLink(__RESPON,__RESPON_DELETE,array("id" => $respon_id, "page" => $this->page_number));
			
			$respons[] = $next_respon;
		}
		$this->tpl->assign( "respons", $respons );
		 
		
		if( ($this->page_number == NULL) || ($this->num_search_results == NULL) || ($this->tot_pages == NULL) ) {
			trigger_error(__ERROR."Page number, total pages, and number of search results must be set in ResponsibilitySearchView. Cannot render view.");
		}
		
		$this->tpl->assign( "rightcolumntitle", "The Book of Responsibilities" );
		$this->tpl->assign( "totalrespons", $this->num_search_results );
		$this->tpl->assign( "pagenumber", $this->page_number);
		$this->tpl->assign( "totalpages", $this->tot_pages);
		
		// Set all 'page back' links
		if( $this->page_number == 1 ) {
			$this->tpl->assign( "linkallpageback", "none" );
			$this->tpl->assign( "linkonepageback", "none" );
		}
		else {
			$this->tpl->assign( "linkallpageback", $this->makeActionLink(__RESPON,__RESPON_SEARCH,array("page" => 1)) );
			$this->tpl->assign( "linkonepageback", $this->makeActionLink(__RESPON,__RESPON_SEARCH,array("page" => ($this->page_number-1))));
		}
		
		// Set all 'page forward' links
		if( $this->page_number == $this->tot_pages ) {
			$this->tpl->assign( "linkallpageforward", "none" );
			$this->tpl->assign( "linkonepageforward", "none" );
		}
		else {
			$this->tpl->assign( "linkallpageforward", $this->makeActionLink(__RESPON,__RESPON_SEARCH,array("page" => $this->tot_pages)));
			$this->tpl->assign( "linkonepageforward", $this->makeActionLink(__RESPON,__RESPON_SEARCH,array("page" => ($this->page_number+1))));
		}
		
		$this->tpl->assign( "javascript", array(__DIR_ABS_JAVASCRIPT."confirmRequest.js" ));
		$this->tpl->assign( "searchtype", "advancedsearch");
	}
	
	/**
	 *
	 * @access public
	 */
	function getBreadcrumbs()
	{
		global $__CS; 
		$__CS->EnterMethod("getBreadcrumbs");
		
		return parent::getBreadcrumbs()." - <a href=".__SITE_BASE_URL."index.php?".__MODULE."=".__RESPON."&".__ACTION."=".__RESPON_SEARCH.">Find Deed</a>";
		
		$__CS->ExitMethod("getBreadcrumbs");
	}
}


?>