<?php
// ResponsibilityEditView.php
include( 'core/responsibilities/views/ResponsibilityView.php');


/**
 * 
 * @author Matthew Lindberg
 */
class ResponsibilityEditView extends ResponsibilityView
{
	// ResponsibilityForm
	var $respon_form;
	
	var $pagenum_from;
	
	/**
	 * Constructor.
	 *
	 * @param $timer 			StopWatch
	 * @param $respon_model 	ResponsibilityModel
	 * @param $respon_form 		ResponsibilityForm
	 * @access public
	 */
	function ResponsibilityEditView(& $timer, & $respon_model, & $respon_form)
	{
		global $__CS;
		$__CS->EnterMethod("ResponsibilityEditView ** Contructor");
		$__CS->SendObject($timer,"timer");
		$__CS->SendObject($respon_model,"respon_model");
		$__CS->SendObject($respon_form,"respon_form");
		
		// instantiate parent class
		parent::ResponsibilityView(& $timer, & $respon_model);
		
		// Set all template variables
		
		$this->setTemplate("responsibility_edit.tpl");
		$this->respon_form =& $respon_form;
		$this->pagenum_from = NULL;
		
		$__CS->ExitMethod("ResponsibilityEditView ** Constructor");
	}
	
	/**
	 * Sets the page number that requested a responsibility edit.
	 *
	 * @param $page integer
	 * @access public
	 */
	function setPageFrom($page)
	{
		$this->pagenum_from = $page;
	}
	
	/**
	 * Sets all the Smarty template variables for this View.
	 *
	 * @param $use_form_values boolean
	 * @access public
	 */
	function init()
	{
		global $__CS;
		$__CS->EnterMethod("init");
		
		parent::init();
		
		// Set module submenu
		$modulemenu = array(
							array("name" 	=> "search",
								"class" 	=> "off",
								"href"	=> $this->makeActionLink(__RESPON,__RESPON_SEARCH)
								 ),
							array("name"	=> "new",
								  "class"	=> "off",
								  "href"	=> $this->makeActionLink(__RESPON,__RESPON_NEW)
								));

		$existing = $this->respon_form->getExisting(); 
		if( $existing ) {
			$this->tpl->assign( "rightcolumntitle", "Edit Responsibility" );
			$this->tpl->assign( "formaction",      	$this->makeActionLink(__RESPON,__RESPON_UPDATE,array("pageback" => $this->pagenum_from)));
			$this->addToPageTitle("Edit Responsibility");
			$this->tpl->assign( "backbuttonlink", $this->makeActionLink(__RESPON,__RESPON_SEARCH,array("page" => $this->pagenum_from)));
			
		}
		else {
			$this->tpl->assign( "rightcolumntitle", "Create New Responsibility" );
			$this->tpl->assign( "formaction",      	$this->makeActionLink(__RESPON,__RESPON_ADD_NEW,array("pageback" => $this->pagenum_from)));
			$this->addToPageTitle("Create New Responsibility");
			$this->tpl->assign( "backbuttonlink", $this->makeActionLink(__RESPON,__RESPON_SEARCH,array("page" => $this->pagenum_from)) );
			$modulemenu[1]["class"] = "on";
		}
		$this->tpl->assign( "modulemenu", $modulemenu );
		
		$this->tpl->assign( "responname", 	$this->respon_form->getFormInput($this->respon_form->_ResponName) );
		$this->tpl->assign( "respondesc",	$this->respon_form->getFormInput($this->respon_form->_ResponDesc) );
		
		$this->tpl->assign( "editexisting", $this->respon_form->getFormInput($this->respon_form->_EditExisting) );
		$this->tpl->assign( "responid",		$this->respon_form->getFormInput($this->respon_form->_ResponID) );
		
		$__CS->ExitMethod("init");
	}
	
	/**
	 *
	 * @access public
	 */
	function getBreadcrumbs()
	{
		global $__CS; 
		$__CS->EnterMethod("getBreadcrumbs");
		
		return parent::getBreadcrumbs()." - <a href=".__SITE_BASE_URL."index.php?".__MODULE."=deeds&".__ACTION."=new>New Deed</a>";
		
		$__CS->ExitMethod("getBreadcrumbs");
	}
}


?>