<?php
// ResponsibilityModel.php
include_once('core/base/Model.php');

/**
 * The logical model for all responsibility operations.
 *
 * @author Matthew Lindberg
 */
class ResponsibilityModel extends Model
{
	var $_ResponTableName 	= "Responsibility";
	
	// deed table fields
	var $_ResponID			= "i_responID";
	var $_ResponName		= "vch_responName";
	var $_ResponDesc		= "text_responDesc";
	
	
	/**
	 * Constructor.
	 *
	 * @param $data_access DataAccess
	 * @access public
	 */
	function ResponsibilityModel(& $data_access)
	{
		global $__CS;
		$__CS->EnterMethod("ResponsibilityModel");
		$__CS->SendObject($data_access,"data_access");
		
		parent::Model(& $data_access);
		$this->init();
		
		$__CS->ExitMethod("ResponsibilityModel");
	}
	
	/**
	 * Loads all default values for this model.
	 *
	 * @access public
	 */
	function init()
	{
		global $__CS;
		$__CS->EnterMethod("init");
		
		$this->setData( $this->_ResponTableName,	$this->_ResponID,  		NULL );
		$this->setData( $this->_ResponTableName,	$this->_ResponName,  	NULL );
		$this->setData( $this->_ResponTableName,	$this->_ResponDesc,  	NULL );
					
		$this->setLoaded(false);	
		$this->setSaved(true);
		$this->setExisting(false);
		
		$__CS->ExitMethod("init");
	}
	
	/**
	 * Saves the model data into the database.
	 *
	 * @access public
	 */
	function save()
	{	
		global $__CS;
		$__CS->EnterMethod("save");
		
		if( !$this->isLoaded() ) {
			return false;
		}
		else if( $this->isSaved() ) {
			return false;
		}
		else if( $this->isExisting() ) {
			$this->_saveByUpdate();
		}
		else {
			$this->_saveByInsert();
		}
		
		$__CS->ExitMethod("save");
		return true;
	} 

	
	/**
	 *
	 */ 
	function _saveByUpdate()
	{
		global $__CS;
		$__CS->EnterMethod("_saveByUpdate:ResponsibilityModel");
		
		$sb =& $this->da->getStatementBuilderInstance();
		$sb->clear();
		$sb->addUpdate($this->_ResponTableName, $this->_ResponName,		$this->getDataValue( $this->_ResponTableName, $this->_ResponName));
		$sb->addUpdate($this->_ResponTableName, $this->_ResponDesc, 	$this->getDataValue( $this->_ResponTableName, $this->_ResponDesc));
		$sb->addConstraint($this->_ResponTableName, $this->_ResponID, "=", $this->getDataValue( $this->_ResponTableName, $this->_ResponID ));
		
		$sql = $sb->getUpdateSQL();
		$this->da->update($sql[0]);
		if( $this->da->isError() ) {
			trigger_error(mysql_error());
		}
		
		$this->setSaved(true);
		
		$__CS->ExitMethod("_saveByUpdate:ResponsibilityModel");
	} 
	
	/**
	 *
	 */ 
	function _saveByInsert()
	{
		global $__CS;
		$__CS->EnterMethod("_saveByInsert");
		
		$sb =& $this->da->getStatementBuilderInstance();
		$sb->clear();
		$sb->addInsert($this->_ResponTableName, $this->_ResponName,		$this->getDataValue( $this->_ResponTableName, $this->_ResponName));
		$sb->addInsert($this->_ResponTableName,	$this->_ResponDesc,		$this->getDataValue( $this->_ResponTableName, $this->_ResponDesc));
		
		$sql = $sb->getInsertSQL();
		$id = $this->da->update($sql[0]);
		if( $this->da->isError() || !($id) ) {
			trigger_error(mysql_error());
		}
		
		$this->setData( $this->_ResponTableName, $this->_ResponID, $id );
		
		$this->setSaved(true);
		$this->setExisting(true);
		
		$__CS->ExitMethod("_saveByInsert");
	} 
	
	
	/**
	 *
	 * @param $form DeedForm
	 * @access public
	 */ 
	function loadFromForm(& $form )
	{
		global $__CS;
		$__CS->EnterMethod("loadFromForm:ResponsibilityModel");
		$__CS->SendObject($form,"form");
		
		if( $form->getExisting() != 0 ) {
			$this->setExisting(true);
		}
		else {
			$this->setExisting(false);
		}
		$this->setData( $this->_ResponTableName,	$this->_ResponID,		$form->getResponID() );
		$this->setData( $this->_ResponTableName,	$this->_ResponName,	 	$form->getResponName() );
		$this->setData( $this->_ResponTableName,	$this->_ResponDesc,		$form->getResponDesc() );
		
		$this->setLoaded(true);
		$this->setSaved(false);
		
		$__CS->ExitMethod("loadFromForm");
	} 
	
	/**
	 * Loads the responsibility model with the responsibilty matching $responID.
	 *
	 * @param $responID integer
	 * @access public
	 */ 
	function loadFromID( $responID )
	{
		global $__CS;
		$__CS->EnterMethod("loadFromID:ResponsibilityModel");
		$__CS->SendVar($responID,"responID");
		
		$sb =& $this->da->getStatementBuilderInstance();
		$sb->addSelect( $this->_ResponTableName, array($this->_ResponID,$this->_ResponName,$this->_ResponDesc));
		$sb->addConstraint( $this->_ResponTableName, $this->_ResponID, "=", $responID );
		$sql = $sb->getSingleSelectSQL(false);
		$sb->clear();
		
		$result =& $this->da->query($sql);
		
		if( ($count = count($result)) != 1 ) {
			$__CS->ExitMethod("loadFromID:ResponsibilityModel");
			return false;
		}
		// Grab the DBRow result object
		$row =& $result[0];
		
		$this->loadFromDBRow(& $row);
		
		$__CS->ExitMethod("loadFromID:ResponsibilityModel");
		return true;
	} 
	
	/**
	 * Loads the deed model using a DBRow object filled with the correct
	 * fields.
	 *
	 * @param $dbrow DBRow
	 * @access public
	 * @return void
	 */
	function loadFromDBRow( & $dbrow )
	{
		global $__CS;
		$__CS->EnterMethod("loadFromDBRow");
		$__CS->SendObject($dbrow,"dbrow");
		
		$this->setData( $this->_ResponTableName, $this->_ResponID, 			$dbrow->getValue($this->_ResponID));
		$this->setData( $this->_ResponTableName, $this->_ResponName,		$dbrow->getValue($this->_ResponName));
		$this->setData( $this->_ResponTableName, $this->_ResponDesc,		$dbrow->getValue($this->_ResponDesc));
		
		$this->setLoaded(true);
		$this->setSaved(true);
		$this->setExisting(true);
		
		$__CS->ExitMethod("loadFromDBRow");
	}
	
	/**
	 *
	 */
	function & selectAll()
	{
		$sb =& $this->da->getStatementBuilderInstance();
		$sb->clear();
		$sb->addSelect($this->_ResponTableName,array("*"));
		$sql = $sb->getSingleSelectSQL();
		
		$collection =& $this->da->fetchCollection($sql);
		return $collection;
	}
	

	/**
	 * Finds all responsibilities from start_index to __MAX_RESPON_RESULTS.
	 *
	 * @param $start_index integer
	 * @access public
	 * @return array( <DBRowCollection>, <total count> )
	 */
	function & searchAll($start_index=0)
	{
		global $__CS;
		$__CS->EnterMethod("ResponsibilityModel:searchAll");
		$__CS->SendVar($start_index,"start_index");
		
		
		$sb =& $this->da->getStatementBuilderInstance();
		$sb->addSelect($this->_ResponTableName,array("*"));
		
		$sql_count  = $sb->getSingleSelectSQL(true);
		$sql_select = $sb->getSingleSelectSQL(false, array($start_index,__MAX_RESPON_RESULTS));
		$sb->clear();
		
		$__CS->SendSQL($sql_count);
		$__CS->SendSQL($sql_select);
	 	
		// First, check that the start index doesn't exceed the total number of items in the database
		$result_arr = $this->da->query($sql_count);
		
		$count_result =& $result_arr[0];
		$count = $count_result->getValue("rowcount");
		if($start_index > $count) {
			trigger_error(__ERROR."Start index $start_index exceeds total result count in ResponsibilityModel:searchAll()" );
		}
		
		// Now, select the result collection
		$collection =& $this->da->fetchCollection($sql_select);
		
		$__CS->SendObject($collection,"collection");
		$__CS->ExitMethod("ResponsibilityModel:searchAll");
		return array(& $collection, $count);
	}
	
	/**
	 * Deletes a responsibility matching $id
	 *
	 * @param $id integer
	 * @access public
	 * @return boolean
	 */ 
	function delete($id)
	{
		global $__CS;
		$__CS->EnterMethod("delete:ResponsibilityModel");
		$__CS->SendVar($id,"id");
		
		$sb =& $this->da->getStatementBuilderInstance();
		$sb->addDelete($this->_ResponTableName);
		$sb->addConstraint($this->_ResponTableName,$this->_ResponID,"=",$id);
		
		$sql = $sb->getDeleteSQL();
		$sb->clear();
		
		$__CS->SendSQL($sql);
		
		$this->da->update($sql);
		
		$__CS->ExitMethod("delete:ResponsibilityModel");
		return (!$this->da->isError());
	} 
	
	 
	 
	/**
	 * 
	 * @access public
	 */
	function getResponID()
	{
		return (int)$this->getDataValue($this->_ResponTableName, $this->_ResponID );
	}
	
	/**
	 * 
	 * @access public
	 */
	function getResponName()
	{
		return (string)$this->getDataValue($this->_ResponTableName,$this->_ResponName);
	}
	
	/**
	 *
	 */
	function getResponDesc()
	{
		return (string)$this->getDataValue($this->_ResponTableName,$this->_ResponDesc);
	}
}
?>