<?php
// UpdateResponsibility.php
include_once('core/base/Action.php');

/**
 * Saves a new responsibility to the database from a submitted responsibility form.
 * 
 * Set view to a new blank responsibility form on success, or an error view on failure.
 *
 * @author Matthew Lindberg
 */
class UpdateResponsibility extends Action
{
	/**
	 * 
	 *
	 * @access public
	 * @return boolean
	 */
	function execute(& $context)
	{
		global $__CS;
		$__CS->EnterMethod("execute:UpdateResponsibility");
		
		$session 	=& $context->getEntry(__SESSION);
		$request	=& $context->getEntry(__REQUEST);
		$timer		=& $context->getEntry(__TIMER);
		
		include_once('core/responsibilities/forms/ResponsibilityForm.php');
		$respon_form =& new ResponsibilityForm(& $session, & $request);
		$respon_form->loadFromRequest();
		
		$model 	=& $context->getEntry(__MODEL);
		$model->loadFromForm( & $respon_form );
		if( !$model->save() ) {
			trigger_error(__ERROR."Could not save responsibility in UpdateResponsibility");
			$__CS->ExitMethod("execute:UpdateResponsibility");
			return false;
		}
		$request->addFeedback("responsibility has been updated successfully");
		
		include_once('core/responsibilities/views/ResponsibilityEditView.php');
		$view 	=& new ResponsibilityEditView(& $timer, & $model, & $respon_form);
		$view->addFeedback($request->getFeedback());
		$view->setPageFrom($request->get("pageback"));
		$view->init();
		
		$controller =& $context->getEntry(__CONTROLLER);
		$controller->setView( & $view );
		
		$__CS->ExitMethod("execute:UpdateResponsibility");
		return true;
	}
}
?>