<?php
// SearchResponsibilities.php
include_once('core/base/Action.php');

/**
 * Searches for responsibilities.
 * 
 * Sets view to paginated responsibility results page, or an error view on failure.
 *
 * @author Matthew Lindberg
 * @todo Make execute functon set ErrorView in controller on error instead of triggering error.
 */
class SearchResponsibilities extends Action
{
	/**
	 * Executes the search deeds action.
	 *
	 * @access public
	 * @return boolean
	 */
	function execute(& $context)
	{
		global $__CS;
		$__CS->EnterMethod("execute");
		
		$model  	=& $context->getEntry(__MODEL);
		$request 	=& $context->getEntry(__REQUEST);
		$timer		=& $context->getEntry(__TIMER);
		
		include_once('core/responsibilities/views/ResponsibilitySearchView.php');
		$view =& new ResponsibilitySearchView(& $timer, & $model);
		
		if($page_num = $request->get('page')) {
			$search_index = ($page_num * __MAX_RESPON_RESULTS) - __MAX_RESPON_RESULTS;
			list($collection,$count) = $model->searchAll($search_index);
			$view->setPageNumber($page_num);
		}
		else {
			list($collection,$count) = $model->searchAll();
			$view->setPageNumber(1);
		}
		
		$view->setNumberOfSearchResults($count);
		
		$num_pages = ceil($count / __MAX_RESPON_RESULTS);
		if( $num_pages == 0 ) {
			$num_pages = 1;
		}
		
		$view->setTotalPages($num_pages);
		$view->setResultRows(& $collection);
		
		// Add any feedback messages, if they exist
		if($request->hasFeedback()) {
			$view->addFeedback($request->getFeedback());
		}
		$view->init();
		
		$controller =& $context->getEntry(__CONTROLLER);
		$controller->setView(& $view);
		
		$__CS->ExitMethod("execute");
		return true;
	}
}
?>