<?php
// EditResponsibility.php
include_once('core/base/Action.php');

/**
 * Opens a responsibility form loaded with an existing responsibility.
 * 
 * @author Matthew Lindberg
 * @todo
 */
class EditResponsibility extends Action
{
	/**
	 * Executes action.
	 *
	 * @access public
	 * @return boolean
	 */
	function execute(& $context)
	{
		global $__CS;
		$__CS->EnterMethod("execute:EditResponsibility");
		
		
		$model 		=& $context->getEntry(__MODEL);
		$request 	=& $context->getEntry(__REQUEST);
		$session	=& $context->getEntry(__SESSION);
		$timer		=& $context->getEntry(__TIMER);
		
		include_once('core/responsibilities/forms/ResponsibilityForm.php');
		$respon_form =& new ResponsibilityForm(& $session, & $request);
		
		$id = $request->get("id");
		
		if( !is_null($id) ) {
			if( $model->loadFromID($id) ) {
				$respon_form->loadFromModel(& $model);
				
				include_once('core/responsibilities/views/ResponsibilityEditView.php');
				$view =& new ResponsibilityEditView(& $timer, & $model, & $respon_form);
				$view->setPageFrom($request->get("pageback"));
				$view->init();
				
				$controller  =& $context->getEntry(__CONTROLLER);
				$controller->setView(& $view);
				return true;
			}
			else {
				trigger_error(__ERROR."Problem loading responsibility model from id in execute:EditResponsibility");
				return false;
			}
		}
		else {
			trigger_error(__ERROR."Responsibility ID was not set in execute:EditResponsibility");
			return false;
		}
		
		$__CS->ExitMethod("execute:EditResponsibility");
		return true;
	}
}
?>