<?php
// ResponsibilityController.php
include_once('core/base/ModuleController.php');
include_once('core/responsibilities/models/ResponsibilityModel.php');

/**
 *
 * @author Matthew Lindberg
 */
class ResponsibilityController extends ModuleController
{
	
	/**
	 * Constructor.
	 *
	 * @param $data_access DataAccess
	 * @param $timer StopWatch
	 * @access public
	 */
	function ResponsibilityController(& $data_access, & $session, & $timer, & $front_controller)
	{
		global $__CS; 
		$__CS->EnterMethod("ResponsibilityController ** Constructor");
		$__CS->SendObject($data_access,"DataAccess");
		$__CS->SendObject($timer,"StopWatch");
		
		$model =& new ResponsibilityModel(& $data_access);
		parent::ModuleController(& $data_access, & $session, & $model, & $timer, & $front_controller);
		
		$__CS->ExitMethod("ResponsibilityController ** Constructor");
	}
	
	
	
	/**
	 * Processes a request.
	 *
	 * @param $request Request
	 * @access public
	 */
	function processRequest(& $request)
	{
		global $__CS; 
		$__CS->EnterMethod("processRequest:ResponsibilityController");
		$__CS->SendObject($request,"Request");
		
		$this->request =& $request;
		$this->setRequestContext(& $this->request, & $this);
		
		// Register actions
		include_once('core/base/ActionHandler.php');
		$handler =& new ActionHandler( "core/responsibilities/actions/",& $this->context);
		$handler->registerAction(__RESPON_SEARCH,	"SearchResponsibilities");
		$handler->registerAction(__RESPON_EDIT,		"EditResponsibility");
		$handler->registerAction(__RESPON_NEW,		"NewResponsibility");
		$handler->registerAction(__RESPON_DELETE,	"DeleteResponsibility");
		$handler->registerAction(__RESPON_ADD_NEW,	"InsertNewResponsibility");
		$handler->registerAction(__RESPON_UPDATE,	"UpdateResponsibility");
		
		
		// Handle action
		$show_view = $handler->execute($this->request->get(__ACTION));
		
		if($show_view && ($this->view != NULL)) {
			$this->view->display();
		}
		$__CS->ExitMethod("processRequest:ResponsibilityController");
	}
}
?>