<?php
// RankView.php
include('core/base/View.php');

/** 
 * The Parent class for all RankViews.
 *
 */
class RankView extends View
{
	/**
	 * Constructor.
	 *
	 * @param $timer StopWatch
	 * @param $rank_model RankModel
	 * @access public
	 */
	function RankView(& $timer, & $rank_model)
	{
		global $__CS;
		$__CS->EnterMethod("RankView");
		$__CS->SendObject($timer,"timer");
		$__CS->SendObject($rank_model,"rank_model");
		
		// instantiate parent class
		parent::View(& $timer, & $rank_model);
		
		// Set all template variables
		$this->addToPageTitle("Rank");
		// Top main menu selection
		$this->tpl->assign("toollinkclass","mainmenulinkon");
		
		$__CS->ExitMethod("RankView");
	}
	
	/**
	 * Initialize a Rank View.
	 *
	 * @access public
	 */
	function init()
	{
		// Set submenu links
		$this->tpl->assign( "submenu",
					array(
							array( 	"name" 	=> "Members",
									"class" => "submenuoff",
									"href"	=> $this->makeActionLink(__MEMBER,__MEMBER_SEARCH)),
							array( 	"name"	=> "Deeds",
									"class"	=> "submenuoff",
									"href"	=> $this->makeActionLink(__DEED,__DEED_SEARCH)),
							array(  "name"	=> "Responsibilities",
									"class" => "submenuoff",
									"href"  => $this->makeActionLink(__RESPON,__RESPON_SEARCH))
						  )
						   );
	}
	
	/**
	 * Get the breadcrumb trail for a rank view.
	 *
	 * @access public
	 */
	function getBreadcrumbs()
	{
		return "<a href=".__SITE_BASE_URL."index.php?".__MODULE."=".__DEED.">Deeds</a>";
	}

}
?>