<?php
// MemberView.php
include('core/base/View.php');

/** 
 * The Parent class for all MemberViews.
 *
 * @author Matthew Lindberg
 */
class MemberView extends View
{
	/**
	 * Constructor.
	 *
	 * @access public
	 * @return void
	 */
	function MemberView(& $timer, & $member_model)
	{
		global $__CS;
		$__CS->EnterMethod("MemberView ** Constructor");
		$__CS->SendObject($timer,"StopWatch");
		$__CS->SendObject($member_model,"MemberModel");
		
		// instantiate parent class
		parent::View(& $timer, & $member_model);
		
		// Set all template variables
		$this->addToPageTitle("Members");
		// Top main menu selection
		$this->tpl->assign("toolslinkclass","mainmenulinkon");
		
		$__CS->ExitMethod("MemberView ** Constructor");
	}
	
	/**
	 * Initializes view.
	 *
	 * @access public
	 * @return void
	 */
	function init()
	{
		// Set submenu links
		$this->tpl->assign( "submenu",
					array(
							array( 	"name" 	=> "Members",
									"class" => "submenuon",
									"href"	=> $this->makeActionLink(__MEMBER,__MEMBER_SEARCH)),
							array( 	"name"	=> "Deeds",
									"class"	=> "submenuoff",
									"href"	=> $this->makeActionLink(__DEED,__DEED_SEARCH)),
							array(  "name"	=> "Responsibilities",
									"class" => "submenuoff",
									"href"  => $this->makeActionLink(__RESPON,__RESPON_SEARCH))
						  )
						   );
	}
	
	/**
	 * Returns html breadcrumb trail link.
	 *
	 * @access public
	 * @return string
	 */
	function getBreadcrumbs()
	{
		return "<a href=".__SITE_BASE_URL."index.php?".__MODULE."=".__MEMBER.">members</a>";
	}

}
?>