<?php
// MemberSearchView.php
include( 'core/members/views/MemberView.php');


/**
 * 
 * @author Matthew Lindberg
 *
 */
class MemberSearchView extends MemberView
{
	// The current page number of search results
	var $page_number;
	
	// Total number of pages
	var $tot_pages;
	
	// The total number of search results
	var $num_search_results;
	
	// DBRow collection
	var $result_rows;
	
	
	/**
	 * Constructor.
	 *
	 * @access public
	 */
	function MemberSearchView(& $timer, & $member_model)
	{
		global $__CS;
		$__CS->EnterMethod("MemberSearchView");
		$__CS->SendObject($timer,"timer");
		$__CS->SendObject($member_model,"member_model");
		
		// instantiate parent class
		parent::MemberView(& $timer, & $member_model);
		
		// Set all template variables
		$this->addToPageTitle("Search Members");
		$this->setTemplate("member_find.tpl");
		
		$this->page_number 			= NULL;
		$this->tot_pages			= NULL;
		$this->num_search_results 	= NULL;
		$this->results_rows 		= NULL;
		
		$__CS->ExitMethod("MemberSearchView");
	}
	
	/**
	 * Sets the search views page number.
	 *
	 * @param $num integer
	 * @access public
	 * @return void
	 */
	function setPageNumber($num)
	{
		global $__CS;
		$__CS->EnterMethod("setPageNumber");
		$__CS->SendVar($num,"num");
		
		$this->page_number = $num;
		
		$__CS->ExitMethod("setPageNumber");
	}
	
	function setTotalPages($num)
	{
		$this->tot_pages = $num;
	}
	
	/**
	 * Sets the total number of search results.
	 *
	 * @param $num integer
	 * @access public
	 * @return void
	 */
	function setNumberOfSearchResults($num)
	{
		global $__CS;
		$__CS->EnterMethod("setNumberOfSearchResults");
		
		$this->num_search_results = $num;
		
		$__CS->ExitMethod("setNumberOfSearchResults");
	}
	
	/**
	 * Sets the views collection of search result rows.
	 *
	 * @param $row_collection arrayDBRows
	 * @access public
	 * @return void
	 */
	function setResultRows(& $rows)
	{
		global $__CS;
		$__CS->EnterMethod("setResultRows");
		$__CS->SendObject($rows,"rows");
		
		$this->result_rows =& $rows;
		
		$__CS->ExitMethod("setResultRows");
	}
	
	
	/**
	 * Sets all the Smarty template variables for this View.
	 *
	 * @access private
	 */
	function init()
	{
		global $__CS;
		parent::init();
		
		// Set module submenu
		$this->tpl->assign("modulemenu" , array(
													array("name" 	=> "search",
														  "class" 	=> "on",
														  "href"	=> $this->makeActionLink(__MEMBER,__MEMBER_SEARCH)
														 ),
													array("name"	=> "new",
														  "class"	=> "off",
														  "href"	=> $this->makeActionLink(__MEMBER,__MEMBER_NEW,array("pageback" => $this->page_number))
														 )
											    ));
				
		if( ($this->page_number == NULL) || ($this->num_search_results == NULL) || ($this->tot_pages == NULL) ) {
			trigger_error(__ERROR."Page number, total pages, and number of search results must be set in MemberSearchView. Cannot render view.");
		}
		   
		$this->tpl->assign( "rightcolumntitle", "The Hall of Members" );
		$this->tpl->assign( "totalmembers", $this->num_search_results );
		$this->tpl->assign( "pagenumber", $this->page_number);
		$this->tpl->assign( "totalpages", $this->tot_pages);
		
		// Set all 'page back' links
		if( $this->page_number == 1 ) {
			$this->tpl->assign( "linkallpageback", "none" );
			$this->tpl->assign( "linkonepageback", "none" );
		}
		else {
			$this->tpl->assign( "linkallpageback", $this->makeActionLink(__RESPON,__RESPON_SEARCH,array("page" => 1)) );
			$this->tpl->assign( "linkonepageback", $this->makeActionLink(__RESPON,__RESPON_SEARCH,array("page" => ($this->page_number-1))));
		}
		
		// Set all 'page forward' links
		if( $this->page_number == $this->tot_pages ) {
			$this->tpl->assign( "linkallpageforward", "none" );
			$this->tpl->assign( "linkonepageforward", "none" );
		}
		else {
			$this->tpl->assign( "linkallpageforward", $this->makeActionLink(__RESPON,__RESPON_SEARCH,array("page" => $this->tot_pages)));
			$this->tpl->assign( "linkonepageforward", $this->makeActionLink(__RESPON,__RESPON_SEARCH,array("page" => ($this->page_number+1))));
		}
		
		$this->tpl->assign( "javascript", array(__DIR_ABS_JAVASCRIPT."confirmRequest.js" ));
		
		
		
		// builds paginated result view from search results rows
		if( $this->result_rows == NULL ) { trigger_error(__ERROR."DBRow search results not set in MemberSearchView.  Cannot Render View."); }
		$iter =& $this->result_rows->createIterator();
		
		$members = array();	
		while( !$iter->isDone() ) {
			$row =& $iter->fetch();
			$this->model->loadFromDBRowAliasesOnly(& $row);
			$deeds =& $this->model->getDeeds();
			
			$member_id = $this->model->getMemberID();
			$next_member = array();
			
			$next_member['rank']				= $this->model->getRank();
			$next_member['guilddptotal']		= $deeds->getDeedlogTotalGuildDP();
			$next_member['questdptotal']		= $deeds->getDeedlogTotalQuestDP();
			$next_member['pvpdptotal']			= $deeds->getDeedlogTotalPvpDP();
			
			$main_character =& $this->model->getMainCharacter();
			$next_member['name'] 				= $main_character->getName();
			$next_member['race']				= $main_character->getRace();
			$next_member['class']				= $main_character->getClass();
			$next_member['level']				= $main_character->getLevel();
			$next_member['characterimgfile'] 	= $main_character->getCharacterImg();
			
			$all_aliases =& $this->model->getAliases();
			$aliases = array();
			for($i=0; $i<count($all_aliases); $i++) {
				$alias_id = $all_aliases[$i]->getCharacterID();
				
				$next_alias = array();
				$next_alias['name'] = $all_aliases[$i]->getName();
				$next_alias['link'] = $this->makeActionLink(__MEMBER,__MEMBER_ALIAS_EDIT,array("memberid" => $member_id, "aliasid" => $alias_id));
				$aliases[] = $next_alias;
			}
			$next_member['aliases'] = $aliases;
			
			// Next, create action links for member result
			$next_member['deletelink'] 		= $this->makeActionLink(__MEMBER,__MEMBER_DELETE,array("id" => $member_id, "page" => $this->page_number ));
			$next_member['editlink'] 		= $this->makeActionLink(__MEMBER,__MEMBER_EDIT,array("id" => $member_id, "pageback" => $this->page_number));
			
			$members[] = $next_member;
		}
		$this->tpl->assign( "members", $members );
		 
	}
	
	/**
	 *
	 * @access public
	 */
	function getBreadcrumbs()
	{
		global $__CS; 
		$__CS->EnterMethod("getBreadcrumbs");
		
		return parent::getBreadcrumbs()." - <a href=".__SITE_BASE_URL."index.php?".__MODULE."=".__RESPON."&".__ACTION."=".__RESPON_SEARCH.">Find Deed</a>";
		
		$__CS->ExitMethod("getBreadcrumbs");
	}
}


?>