<?php
// DeedSelectView.php
include( 'core/members/views/MemberView.php');

/**
 * 
 * @author Matthew Lindberg
 */
class DeedSelectView extends MemberView
{
	// deed select list form
	var $deed_select_form;
	
	// deed model
	var $deed_model;
	
	// integer
	var $pagenum_from;
	
	// collection of DBRow deed results
	var $deed_coll;
	
	
	
	/**
	 * Constructor.
	 *
	 * @param $timer StopWatch
	 * @param $member_model MemberModel
	 * @param $member_form MemberEditForm
	 * @access public
	 */
	function DeedSelectView(& $timer, & $member_model, & $deed_model, & $deed_select_form)
	{
		global $__CS;
		$__CS->EnterMethod("DeedSelectView ** Constructor");
		$__CS->SendObject($timer,"timer");
		$__CS->SendObject($member_model,"member_model");
		$__CS->SendObject($deed_select_form,"deed_select_form");
		
		// instantiate parent class
		parent::MemberView(& $timer, & $member_model);
		
		// Set all template variables
		
		$this->setTemplate("deed_select_list.tpl");
		$this->deed_select_form =& $deed_select_form;
		$this->deed_model =& $deed_model;
		$this->pagenum_from = NULL;
		
		$__CS->ExitMethod("DeedSelectView ** Constructor");
	}
	
	/**
	 * Sets the page number that requested a new member edit.
	 *
	 * @param $page integer
	 * @access public
	 */
	function setPageFrom($page)
	{
		$this->pagenum_from = $page;
	}
	
	/**
	 *
	 * @access public
	 */
	function setDeedCollection(& $deed_coll)
	{
		$this->deed_coll =& $deed_coll;
	}
	
	/**
	 * Sets all the Smarty template variables for this View.
	 *
	 * @param $use_form_values boolean
	 * @access public
	 */
	function init()
	{
		global $__CS;
		$__CS->EnterMethod("init");
		
		parent::init();
		
		// Set module submenu
		$modulemenu = array(
							array("name" 	=> "search",
								"class" 	=> "off",
								"href"	=> $this->makeActionLink(__MEMBER,__MEMBER_SEARCH)
								 ),
							array("name"	=> "new",
								  "class"	=> "off",
								  "href"	=> $this->makeActionLink(__MEMBER,__MEMBER_NEW)
								));
		$this->tpl->assign( "modulemenu", $modulemenu );
		
		$member_id = $this->model->getMemberID();
		
		$this->tpl->assign( "memberid", $member_id );
		$this->addToPageTitle("Select Member Deeds");
		$this->tpl->assign( "rightcolumntitle", "Select Member Deeds");
		$this->tpl->assign("javascript",  array(__DIR_ABS_JAVASCRIPT."toggleMultiDisplay.js",__DIR_ABS_JAVASCRIPT."confirmRequest.js") );
	
		if($this->pagenum_from != NULL) {
			$this->tpl->assign( "backbuttonlink", $this->makeActionLink(__MEMBER,__MEMBER_SEARCH,array("page" => $this->pagenum_from)));
		}
		else {
			$this->tpl->assign( "backbuttonlink", $this->makeActionLink(__MEMBER,__MEMBER_EDIT,array("id"=>$member_id,"section"=>"deedlogsection")));
		}
		
		$this->tpl->assign( "checkboxname", "deedid" );
		$this->tpl->assign( "numoftimesname", "numoftimes");
		$this->tpl->assign( "formaction", $this->makeActionLink(__MEMBER,__MEMBER_INSERT_DEEDLOG_DEEDS,array("memberid"=>$member_id)));
		$this->tpl->assign( "numoftimesoptions", array( "1"=>"1", "2"=>"2", "3"=>"3", "4"=>"4", "5"=>"5", "6"=>"6" ));
		
		$deeds = array();
		$deed_iter =& $this->deed_coll->createIterator();
		while(!$deed_iter->isDone()) {
			$next_deed = array();
			$row =& $deed_iter->fetch();
			$this->deed_model->loadFromDBRow(& $row);
			$next_deed["deedid"]		= $this->deed_model->getDeedID();
			$next_deed["deeddesc"]		= $this->deed_model->getDeedName();
			$next_deed["checked"]		= "no";
			$next_deed["detailslink"]	= $this->makeActionLink(__DEED,__DEED_DETAIL_POPUP,array("deedid"=>$next_deed["deedid"]));
			$next_deed["guilddp"]		= $this->deed_model->getGuildGP();
			$next_deed["questdp"]		= $this->deed_model->getQuestGP();
			$next_deed["pvpdp"]			= $this->deed_model->getPvpGP();
			$next_deed["numoftimes"]	= 1;
			$deeds[] = $next_deed;
		}
		$this->tpl->assign( "deeds", $deeds);
		
		
		$__CS->ExitMethod("init");
	}
	
	/**
	 *
	 * @access public
	 */
	function getBreadcrumbs()
	{
		global $__CS; 
		$__CS->EnterMethod("getBreadcrumbs");
		
		return parent::getBreadcrumbs()." - <a href=".__SITE_BASE_URL."index.php?".__MODULE."=deeds&".__ACTION."=new>New Deed</a>";
		
		$__CS->ExitMethod("getBreadcrumbs");
	}
}