<?php
// MemberModel.php
include_once('core/base/Model.php');



/**
 * The logical model for all member operations.
 *
 * @author Matthew Lindberg
 */
class MemberModel extends Model
{
	// member table fields
	var $_MemberTable 					= "Member";
	var $_MemberID						= "i_memberID";
	var $_MemberRankID					= "i_rankID";
	var $_MemberMainCharacterID			= "i_mainCharacterID";
	var $_MemberLogin 					= "vch_login";
	var $_MemberEMail 					= "vch_email";
	var $_MemberIsDeleted      			= "i_deleted";
	var $_MemberDateCreated 			= "date_created";
	var $_MemberDateModified    		= "date_modified";
	
	// member-character association table fields
	var $_MemberCharacterTable			= "Member_GameCharacter";
	var $_MemberCharacterMemberID 		= "i_memberID";
	var $_MemberCharacterCharacterID 	= "i_characterID";
	
	// character table fields
	var $_CharacterTable				= "GameCharacter";
	var $_CharacterID					= "i_characterID";
	var $_CharacterName					= "vch_characterName";
	var $_CharacterSex					= "ch_characterSex";
	var $_CharacterRaceID				= "i_raceID";
	var $_CharacterClassID				= "i_classID";
	var $_CharacterServerID				= "i_serverID";
	var $_CharacterLevel				= "i_level";
	var $_CharacterThottbotEnabled		= "i_enableThottbot";
	var $_CharacterIsDeleted			= "i_deleted";
	var $_CharacterDateCreated			= "date_created";
	var $_CharacterDateModified			= "date_modified";
	
	// race table fields
	var $_RaceTable						= "Race";
	var $_RaceID						= "i_raceID";
	var $_RaceName						= "vch_raceName";
	var $_RaceFemalePictureID			= "i_femalePicID";
	var $_RaceMalePictureID				= "i_malePicID";
	
	// class table fields
	var $_ClassTable					= "Class";
	var $_ClassID						= "i_classID";
	var $_ClassName						= "vch_className";
	
	// server table fields
	var $_ServerTable					= "Server";
	var $_ServerID						= "i_serverID";
	var $_ServerName					= "vch_serverName";
	
	// image table fields
	var $_ImageTable					= "Image";
	var $_ImageID						= "i_imageID";
	var $_ImageName						= "vch_imageName";
	var $_ImagePath						= "vch_imagePath";
	
	// rank table fields
	var $_RankTable						= "Rank";
	var $_RankID						= "i_rankID";
	var $_RankName						= "vch_rankName";
	
	// note table
	var $_NoteTable						= "Note";
	var $_NoteID						= "i_noteID";
	var $_NoteTitle						= "vch_title";
	var $_NoteBody						= "text_note";
	var $_NoteIsDeleted					= "i_deleted";
	var $_NoteDateCreated				= "date_created";
	var $_NoteDateModified				= "date_modified";
	
	// note-member table
	var $_NoteMemberTable				= "Member_Note";
	var $_NoteMemberMemberID			= "i_memberID";
	var $_NoteMemberNoteID				= "i_noteID";
	
	// responsibility list entry
	var $_ResponListEntryTable			= "MemberResponsibilityListEntry";
	var $_ResponListEntryID				= "i_responListEntryID";
	var $_ResponListEntryType			= "vch_responType";
	var $_ResponListEntryMemberID		= "i_memberID";
	var $_ResponListEntryResponID		= "i_responID";
	var $_ResponListEntryFinishInCount  = "i_finishInCount";
	var $_ResponListEntryFinishInType   = "vch_finishInType";
	var $_ResponListEntryDateLastCompleted = "date_lastCompleted";
	var $_ResponListEntryDateAdded		= "date_added";
	
	// responsibility
	var $_ResponTable					= "Responsibility";
	var $_ResponID						= "i_responID";
	var $_ResponName					= "vch_responName";
	var $_ResponDesc					= "text_responDesc";
	var $_ResponIsDeleted				= "i_deleted";
	var $_ResponDateCreated				= "date_created";
	var $_ResponDateModified			= "date_modified";
	
	// deedlog
	var $_DeedLogEntryTable				= "DeedLogEntry";
	var $_DeedLogEntryID				= "i_deedLogEntryID";
	var $_DeedLogEntryMemberID			= "i_memberID";
	var $_DeedLogEntryDeedID			= "i_deedID";
	var $_DeedLogEntryNumTimes			= "i_numTimes";
	var $_DeedLogEntryDateAdded			= "date_added";
	var $_DeedLogEntryDateModified		= "date_modified";
	var $_DeedLogEntryIsDeleted			= "i_deleted";
	
	// deeds
	var $_DeedTable						= "Deed";
	var $_DeedID						= "i_deedID";
	var $_DeedName						= "vch_deedName";
	var $_DeedGuildDP					= "i_guildDeedPoints";
	var $_DeedQuestDP					= "i_questDeedPoints";
	var $_DeedPvpDP						= "i_pvpDeedPoints";
	var $_DeedDifficulty				= "vch_difficulty";
	var $_DeedMultiCompletion			= "i_multiCompletion";
	var $_DeedIsDeleted					= "i_deleted";
	var $_DeedDateCreated				= "date_created";
	var $_DeedDateModified				= "date_modified";
	
	
	
	
	// Member variables
	var $member_id;
	var $rank;
	var $rank_id;
	var $main_character_id;
	var $login;
	var $email;
	var $is_deleted;
	var $date_created;
	var $date_modified;
	
	
	// Member sub-model variables
	var $main_character;
	var $characters;
	var $notes;
	var $member_respons;
	var $rank_respons;
	var $deeds;
	
	
	var $char_options;
	
	// Extra member model state variables
	var $load_state;		
	var $__LOAD_FULL			= "full";
	var $__LOAD_PARTIAL 		= "partial";
	var $__LOAD_NEW				= "new";
	var $__MAX_CHARACTER_LEVEL 	= 60;
	
	
	/**
	 * Constructor.
	 *
	 * @param $data_access DataAccess
	 * @access public
	 */
	function MemberModel(& $data_access)
	{
		global $__CS;
		$__CS->EnterMethod("MemberModel");
		$__CS->SendObject($data_access,"data_access");
		
		parent::Model(& $data_access);
		$this->init();
		
		$__CS->ExitMethod("MemberModel");
	}
	
	/**
	 * Loads all default values for this model.
	 *
	 * @access public
	 */
	function init()
	{
		global $__CS;
		$__CS->EnterMethod("init");
		
		$this->setLoaded(false);	
		$this->setSaved(true);
		$this->setExisting(false);
		
		$__CS->ExitMethod("init");
	}
	
	
	/**
	 * Creates a new member using input from a new member form.
	 * 
	 * @param $form MemberNewForm
	 * @access public
	 */
	function saveFromNewForm(& $new_member_form )
	{
		global $__CS;
		$__CS->EnterMethod("saveFromNewForm:MemberModel");
		$__CS->SendObject($new_member_form,"new_member_form");
		
		$login		= $new_member_form->getLogin();
		$email		= $new_member_form->getEMail();
		$rankid		= $new_member_form->getRankID();
		$name		= $new_member_form->getMainCharName();
		$classid	= $new_member_form->getMainCharClassID();
		$raceid		= $new_member_form->getMainCharRaceID();
		$thott		= $new_member_form->getMainCharEnableThottbot();
		$level		= $new_member_form->getMainCharLevel();
		$sex		= $new_member_form->getMainCharSex();
		$serverid	= $new_member_form->getServerID();
		
		// First insert the new member's main character, to get it's generated id
		$char_sql = 'INSERT INTO GameCharacter (vch_characterName,ch_characterSex,i_raceID,i_classID,i_serverID,i_level,i_enableThottbot,date_created,date_modified) VALUES 
											   ("'.$name.'","'.$sex.'",'.$raceid.','.$classid.','.$serverid.','.$level.','.$thott.',NOW(),NOW())';
		$char_id = $this->da->update($char_sql);
		
		// Next, insert the member
		$member_sql = '	INSERT INTO Member (i_rankID,i_mainCharacterID,vch_login,vch_email,date_created,date_modified) 
					   	VALUES ('.$rankid.','.$char_id.',"'.$login.'","'.$email.'",NOW(),NOW())';
		$member_id = $this->da->update($member_sql);
		
		// Finally, relate the member with the character
		$member_char_sql = 'INSERT INTO Member_GameCharacter (i_memberID,i_characterID) VALUES ('.$member_id.','.$char_id.')';
		$this->da->update($member_char_sql);
		
		return true;
		$__CS->ExitMethod("saveFromNewForm:MemberModel");
	}
	
	/**
	 *
	 * @access public
	 */
	function updateFromForm(& $member_form, $member_id)
	{
		$login		= $member_form->getLogin();
		$email		= $member_form->getEMail();
		$rankid		= $member_form->getRankID();
		$name		= $member_form->getMainCharName();
		$classid	= $member_form->getMainCharClassID();
		$raceid		= $member_form->getMainCharRaceID();
		$thott		= $member_form->getMainCharEnableThottbot();
		$level		= $member_form->getMainCharLevel();
		$sex		= $member_form->getMainCharSex();
		$serverid	= $member_form->getServerID();
		
		$member_sql = 'UPDATE '.$this->_MemberTable.' 
					   SET
					  '.$this->_MemberLogin.'="'.$login.'",
					  '.$this->_MemberEMail.'="'.$email.'",
					  '.$this->_MemberRankID.'='.$rankid.',
					  '.$this->_MemberDateModified.'=NOW()
					  WHERE
					  '.$this->_MemberID.'='.$member_id;
		$char_sql = 'UPDATE GameCharacter
					 SET
					 vch_characterName="'.$name.'",
				     i_classID='.$classid.',
					 i_raceID='.$raceid.',
				     i_enableThottbot='.$thott.',
					 i_level='.$level.',
		             ch_characterSex="'.$sex.'",
					 i_serverID='.$serverid.'
					 WHERE
					 i_characterID='.$character_id;
		
		$this->da->update($member_sql);
		//$this->da->update($char_sql);
		return true;
	}
	
	/**
	 *
	 * @param $new_alias_form AliasEditForm
	 * @access public
	 */
	function saveNewAliasFromForm(& $new_alias_form, $member_id)
	{
		$sb	=& $this->da->getStatementBuilderInstance();
		
		$name		= $new_alias_form->getName();
		$sex		= $new_alias_form->getSex();
		$raceid 	= $new_alias_form->getRaceID();
		$classid	= $new_alias_form->getClassID();
		$level		= $new_alias_form->getLevel();
		$thott		= $new_alias_form->getEnableThottbot();
		
		$sb->clear();
		$sb->addInsert($this->_CharacterTable, $this->_CharacterName, $name);
		$sb->addInsert($this->_CharacterTable, $this->_CharacterSex, $sex);
		$sb->addInsert($this->_CharacterTable, $this->_CharacterRaceID, $raceid);
		$sb->addInsert($this->_CharacterTable, $this->_CharacterClassID, $classid);
		$sb->addInsert($this->_CharacterTable, $this->_CharacterServerID, 0);   //  Change this when I add servers to the new member form
		$sb->addInsert($this->_CharacterTable, $this->_CharacterLevel, $level);
		$sb->addInsert($this->_CharacterTable, $this->_CharacterThottbotEnabled, $thott);
		$sb->addInsert($this->_CharacterTable, $this->_CharacterDateCreated, "NOW()");
		$sb->addInsert($this->_CharacterTable, $this->_CharacterDateModified, "NOW()");
		
		$char_sql = $sb->getInsertSQL();
		$char_id = $this->da->update($char_sql[0]);
		
		// Relate the member to the character
		$sb->clear();
		$sb->addInsert($this->_MemberCharacterTable, $this->_MemberCharacterMemberID, $member_id);
		$sb->addInsert($this->_MemberCharacterTable, $this->_MemberCharacterCharacterID, $char_id);
		
		$member_char_sql = $sb->getInsertSQL();
		$this->da->update($member_char_sql[0]);
		
		return true;
	}
	
	/**
	 *
	 * @access public
	 */
	function saveNoteFromForm(& $note_form, $member_id)
	{
		$note_sql = 'INSERT INTO '.$this->_NoteTable.'
					 VALUES
					 (NULL,"'.$note_form->getTitle().'","'.$note_form->getBody().'",0,NOW(),NOW())';
		
		$note_id = $this->da->update($note_sql);
		
		$assoc_sql = 'INSERT INTO '.$this->_NoteMemberTable.'
					  VALUES
					  ('.$member_id.','.$note_id.')';
		
		$this->da->update($assoc_sql);
		return true;
	}
	
	/** 
	 *
	 * @access public
	 */
	function saveDeedlogDeeds(& $select_form, $member_id)
	{
		$inserts = array();
		$selections = $select_form->getSelections();
		for($i=0; $i<count($selections); $i++) {
			list($deed_id,$num_times) = $selections[$i];
			$inserts[] = 'INSERT INTO '.$this->_DeedLogEntryTable.
						 ' VALUES (NULL,'.$member_id.','.$deed_id.','.$num_times.',NOW(),0)';
		}
		
		for($i=0; $i<count($inserts); $i++) {
			$this->da->update($inserts[$i]);
		}
		
		return true;
	}
	
	/**
	 *
	 * @access public
	 */
	function saveResponsibilities(& $select_form, $member_id)
	{
		$deletesql = "DELETE FROM ".$this->_ResponListEntryTable." 
					  WHERE
					  ".$this->_ResponListEntryMemberID."=".$member_id;
		
		$this->da->update($deletesql);
		
		$inserts = array();
		$selections = $select_form->getSelections();
		for($i=0; $i<count($selections); $i++) {
			list($respon_id,$count_val,$count_type) = $selections[$i];
			$inserts[] = 'INSERT INTO '.$this->_ResponListEntryTable.'
						  VALUES (NULL,"member",'.$member_id.','.$respon_id.','.$count_val.',"'.$count_type.'",'.
						 'NOW(),NOW())';
		}
		
		for($i=0; $i<count($inserts); $i++) {
			$this->da->update($inserts[$i]);
		}
		
		return true;
	}
	
	/** 
	 *
	 * @param $alias_form AliasEditForm
	 * @param $member_id integer
	 * @param $alias_id integer
	 * @access public
	 */
	function updateAlias(& $alias_form, $member_id, $alias_id)
	{
		$name 		=	$alias_form->getName();
		$sex		= 	$alias_form->getSex();
		$raceid		= 	$alias_form->getRaceID();
		$classid	=	$alias_form->getClassID();
		$serverid	= 	$alias_form->getServerID();
		$level		= 	$alias_form->getLevel();
		$thott		= 	$alias_form->getEnableThottbot();
		
		$sql = 'UPDATE GameCharacter 
				SET vch_characterName="'.$name.'",ch_characterSex="'.$sex.'",
					i_raceID='.$raceid.',i_classID='.$classid.',i_level='.$level.',
					i_enableThottbot='.$level.' 
				WHERE i_characterID='.$alias_id;
		
		
		//$sql = $sb->getUpdateSQL();
	
		$this->da->update($sql);
		return !($this->da->isError());
	}
	
	
	/**
	 * Loads the member model with the member matching $member_id
	 *
	 * @param $member_id integer
	 * @access public
	 */
	function loadFromID( $member_id )
	{
		global $__CS;
		$__CS->EnterMethod("loadFromID:MemberModel");
		$__CS->SendVar($deedID,"member_id");
		$this->member_id = $member_id;
		
		$sb =& $this->da->getStatementBuilderInstance();
		
		$sb->clear();
		$sb->addSelect( $this->_MemberTable, array($this->_MemberRankID,$this->_MemberMainCharacterID,$this->_MemberLogin,
											       $this->_MemberEMail,$this->_MemberIsDeleted,$this->_MemberDateCreated,
											       $this->_MemberDateModified));
		$sb->addSelect( $this->_RankTable, array($this->_RankName));
		$sb->addConstraint( $this->_MemberTable, $this->_MemberID, "=", $this->member_id );
		$sb->addInnerJoin( $this->_MemberTable, $this->_MemberRankID, "=", $this->_RankTable, $this->_RankID);
		
		$member_sql = $sb->getJoinSelectSQL();
		
		$member = $this->da->query($member_sql);
		
		$this->rank 				= $member[0]->getValue($this->_RankName);
		$this->rankid				= $member[0]->getValue($this->_MemberRankID);
		$this->main_character_id	= $member[0]->getValue($this->_MemberMainCharacterID);
		$this->login				= $member[0]->getValue($this->_MemberLogin);						 
		$this->email				= $member[0]->getValue($this->_MemberEMail);
		$this->is_deleted			= $member[0]->getValue($this->_MemberIsDeleted);
		$this->date_created			= $member[0]->getValue($this->_MemberDateCreated);
		$this->date_modified		= $member[0]->getValue($this->_MemberDateModified);										 

		$this->loadCharacters($this->member_id,$this->main_character_id);					 
		$this->loadNotes($this->member_id);
		$this->loadResponsibilities($this->member_id,$this->rank_id);
		$this->loadDeedlog($this->member_id);
			  
		return true;
	}
	

	/**
	 * Loads the member model with only base member information and base alias data.  No information on notes,deeds,or responsibilties
	 * will be loaded.  This should be used on the main member search pages, which only link to the more detailed information.
	 *
	 * @param $dbrow DBRow
	 * @access public
	 * @return void
	 */
	function loadFromDBRowAliasesOnly( & $dbrow )
	{
		global $__CS;
		$__CS->EnterMethod("loadFromDBRowAliasesOnly:MemberModel");
		$__CS->SendObject($dbrow,"dbrow");
		
		$this->member_id			= $dbrow->getValue($this->_MemberID);
		$this->rank					= $dbrow->getValue($this->_RankName);
		$this->rank_id				= $dbrow->getValue($this->_MemberRankID);
		$this->main_character_id 	= $dbrow->getValue($this->_MemberMainCharacterID);
		$this->login				= $dbrow->getValue($this->_MemberLogin);
		$this->email				= $dbrow->getValue($this->_MemberEmail);
		$this->is_deleted			= $dbrow->getValue($this->_MemberIsDeleted);
		$this->date_created			= $dbrow->getValue($this->_MemberDateCreated);
		$this->date_modified		= $dbrow->getValue($this->_MemberDateModified);
		
		$this->loadCharacters($this->member_id,$this->main_character_id);
		$this->loadDeedlog($this->member_id);
		
		$this->load_state = $this->__LOAD_PARTIAL;
		$this->setLoaded(true);
		$this->setSaved(true);
		$this->setExisting(true);
		
		$__CS->ExitMethod("loadFromDBRowAliasesOnly:MemberModel");
	}
	
	
	/**
	 * Loads all of a member's alias characters.
	 *
	 * @param $member_id integer
	 * @param $main_character_id integer
	 * @access public
	 */
	function loadCharacters($member_id,$main_character_id)
	{
		include_once('core/members/models/Character.php');
		
		$sql = 'SELECT 	GameCharacter.i_characterID,GameCharacter.vch_characterName,GameCharacter.ch_characterSex,
						GameCharacter.i_level,GameCharacter.i_enableThottbot,Race.vch_raceName,Race.i_raceID,Race.i_femalePicID,
						Race.i_malePicID,Class.vch_className,Class.i_classID 
				FROM 	Member,Member_GameCharacter,GameCharacter,Rank,Race,Class 
				WHERE 	Member.i_memberID=Member_GameCharacter.i_memberID 
				AND 	Member.i_rankID=Rank.i_rankID 
				AND 	Member_GameCharacter.i_characterID=GameCharacter.i_characterID 
				AND 	GameCharacter.i_raceID=Race.i_raceID 
				AND 	GameCharacter.i_classID=Class.i_classID 
				AND 	Member.i_memberID = "'.$member_id.'"';
		
		$this->characters = array();
		$coll =& $this->da->fetchCollection($sql);
		$iter =& $coll->createIterator();
		while(!$iter->isDone()) {
			$next_alias =& $iter->fetch();
			
			$id 	= $next_alias->getValue($this->_CharacterID);
			$name 	= $next_alias->getValue($this->_CharacterName);
			$race 	= $next_alias->getValue($this->_RaceName);
			$raceid = $next_alias->getValue($this->_RaceID);
			$class  = $next_alias->getValue($this->_ClassName);
			$classid= $next_alias->getValue($this->_ClassID);
			$fem_id = $next_alias->getValue($this->_RaceFemalePictureID);
			$mal_id = $next_alias->getValue($this->_RaceMalePictureID);
			$sex	= $next_alias->getValue($this->_CharacterSex);
			$level	= $next_alias->getValue($this->_CharacterLevel);
			$thott	= $next_alias->getValue($this->_CharacterThottbotEnabled);
			
			
			if( $sex == "m" ) {
				$pic_id = $mal_id;
			}
			else {
				$pic_id = $fem_id;
			}
			$sql = 'SELECT vch_imageName,vch_imagePath 
					FROM Image 
					WHERE Image.i_imageID = "'.$pic_id.'"';
			
			
			$result_arr = $this->da->query($sql);
			$pic =& $result_arr[0];
			
			$picfile = $pic->getValue( $this->_ImagePath ).$pic->getValue( $this->_ImageName );
		
			if($id == $main_character_id) {
				$this->main_character =& new Character($id,$name,$race,$raceid,$class,$classid,$picfile,'','',$sex,$level,$thott);
			}
			else {
				$this->characters[] = new Character($id,$name,$race,$raceid,$class,$classid,$picfile,'','',$sex,$level,$thott);
			}
		}
	}
	
	
	/**
	 * Loads a member's note section.
	 *
	 * @param $member_id integer
	 * @access public
	 */
	function loadNotes($member_id)
	{
		include_once('core/members/models/Note.php');
		
		$sb =& $this->da->getStatementBuilderInstance();
		
		$sb->clear();
		$sb->addSelect($this->_NoteTable, array($this->_NoteID,$this->_NoteTitle,$this->_NoteBody,$this->_NoteDateCreated,$this->_NoteDateModified));
		$sb->addSelect($this->_NoteMemberTable, array());
		$sb->addConstraint($this->_NoteMemberTable,$this->_NoteMemberMemberID,"=",$member_id);
		$sb->addInnerJoin($this->_NoteMemberTable,$this->_NoteMemberNoteID,"=",$this->_NoteTable,$this->_NoteID);
		
		$sql = $sb->getJoinSelectSQL();
		
		$this->notes = array();
		$notes_coll =& $this->da->fetchCollection($sql);
		$notes_iter =& $notes_coll->createIterator();
		while(!$notes_iter->isDone()) {
			$next_note = $notes_iter->fetch();
			$this->notes[] =& new Note($next_note->getValue($this->_NoteID),$next_note->getValue($this->_NoteTitle),$next_note->getValue($this->_NoteBody),
									   $next_note->getValue($this->_NoteDateCreated));
		}
		return true;
	}
	
	
	/**
	 * Loads a member's responsibility list.
	 *
	 * @param $member_id integer
	 * @access public
	 */
	function loadResponsibilities($member_id)
	{
		include_once('core/members/models/MemberResponsibility.php');
		
		$sb =& $this->da->getStatementBuilderInstance();
		
		$sb->clear();
		$sb->addSelect($this->_ResponListEntryTable, array("*"));
		$sb->addSelect($this->_ResponTable, array("*"));
		$sb->addConstraint($this->_ResponListEntryTable,$this->_ResponListEntryMemberID,"=",$member_id);
		$sb->addInnerJoin($this->_ResponListEntryTable,$this->_ResponListEntryResponID,"=",$this->_ResponTable,$this->_ResponID);
	
		$sql = $sb->getJoinSelectSQL();
		
		$this->member_respons = array();
		$this->rank_respons	  = array();
		$respon_coll =& $this->da->fetchCollection($sql);
		$respon_iter =& $respon_coll->createIterator();
		while(!$respon_iter->isDone()) {
			$next_respon =& $respon_iter->fetch();
			$respon_obj  =& new MemberResponsibility($next_respon->getValue($this->_ResponListEntryID),$next_respon->getValue($this->_ResponID),
										$next_respon->getValue($this->_ResponName),$next_respon->getValue($this->_ResponDesc),
										$next_respon->getValue($this->_ResponDateCreated),$next_respon->getValue($this->_ResponDateModified),
										$next_respon->getValue($this->_ResponListEntryDateAdded),$next_respon->getValue($this->_ResponListEntryDateLastCompleted),
										$next_respon->getValue($this->_ResponListEntryFinishInCount),$next_respon->getValue($this->_ResponListEntryFinishInType));
			$respon_type = $next_respon->getValue($this->_ResponListEntryType);
			if($respon_type == "member") {
				$this->member_respons[] =& $respon_obj;
			}
			else if($respon_type == "rank" ) {
				$this->rank_respons[] =& $respon_obj;
			}
			else {
				die("A responsibility must be of type 'member' or 'rank'");
			}
		}
	}
	
	
	/** 
	 * Loads a member's deedlog.
	 *
	 * @param $member_id integer
	 * @access public
	 */
	function loadDeedlog($member_id)
	{
		include_once('core/members/models/DeedLogSequence.php');
		
		$sb =& $this->da->getStatementBuilderInstance();
		
		$sb->clear();
		$sb->addSelect($this->_DeedLogEntryTable, array("*"));
		$sb->addSelect($this->_DeedTable, array("*"));
		$sb->addConstraint($this->_DeedLogEntryTable,$this->_DeedLogEntryMemberID,"=",$member_id);
		$sb->addInnerJoin($this->_DeedLogEntryTable,$this->_DeedLogEntryDeedID,"=",$this->_DeedTable,$this->_DeedID);
		
		$sql = $sb->getJoinSelectSQL();
		
		$this->deeds =& new DeedLogSequence();
		$deed_coll =& $this->da->fetchCollection($sql);
		$deed_iter =& $deed_coll->createIterator();
		while(!$deed_iter->isDone()) {
			$next_entry =& $deed_iter->fetch();
			$this->deeds->addDeed($next_entry->getValue($this->_DeedID),$next_entry->getValue($this->_DeedLogEntryNumTimes),
								$next_entry->getValue($this->_DeedName),$next_entry->getValue($this->_DeedGuildDP), 
								$next_entry->getValue($this->_DeedQuestDP), $next_entry->getValue($this->_DeedPvpDP), $next_entry->getValue($this->_DeedLogEntryID));
		}
	}
	
	/**
	 *
	 */
	function deleteAlias($member_id,$alias_id)
	{
		$sb =& $this->da->getStatementBuilderInstance();
		
		$sb->clear();
		$sb->addDelete($this->_MemberCharacterTable);
		$sb->addConstraint($this->_MemberCharacterTable,$this->_MemberCharacterMemberID,"=",$member_id);
		$sb->addConstraint($this->_MemberCharacterTable,$this->_MemberCharacterCharacterID,"=",$alias_id);
		
		$sql1 = $sb->getDeleteSQL();
		
		$sb->clear();
		$sb->addDelete($this->_CharacterTable);
		$sb->addConstraint($this->_CharacterTable,$this->_CharacterID,"=",$alias_id);
		
		$sql2 = $sb->getDeleteSQL();
		
		$this->da->update($sql1);
		$this->da->update($sql2);
		
		return true;
	}
	
	
	/**
	 *
	 * @access public
	 */
	function deleteMember($member_id)
	{
		$sel_sql = 'SELECT * 
				 FROM '.$this->_MemberTable.','.$this->_MemberCharacterTable.','.$this->_CharacterTable.'
		         WHERE
				 '.$this->_MemberTable.'.'.$this->_MemberID.'='.$member_id.'
				 AND
				 '.$this->_MemberTable.'.'.$this->_MemberID.'='.$this->_MemberCharacterTable.'.'.$this->_MemberCharacterMemberID.'
				 AND
				 '.$this->_MemberCharacterTable.'.'.$this->_MemberCharacterCharacterID.'='.$this->_CharacterTable.'.'.$this->_CharacterID;
		
		$coll =& $this->da->fetchCollection($sel_sql);
		$character_deletes = array();
		$iter =& $coll->createIterator();
		while(!$iter->isDone()) {
			$next =& $iter->fetch();
			$character_deletes[] = 'DELETE FROM '.$this->_CharacterTable.' WHERE
								   '.$this->_CharacterID.'='.$next->getValue($this->_CharacterID);
		}
		$assoc_delete = 'DELETE FROM '.$this->_MemberCharacterTable.' WHERE
						 '.$this->_MemberCharacterMemberID.'='.$member_id;
		$member_delete = 'DELETE FROM '.$this->_MemberTable.' WHERE
						 '.$this->_MemberID.'='.$member_id;
		$respon_delete = 'DELETE FROM '.$this->_ResponListEntryTable.' WHERE
						 '.$this->_ResponListEntryMemberID.'='.$member_id;
		$deedlog_delete = 'DELETE FROM '.$this->_DeedLogEntryTable.' WHERE
						  '.$this->_DeedLogEntryMemberID.'='.$member_id;
		
		// Delete all member entries
		for($i=0; $i<count($character_deletes); $i++) {
			$this->da->update($character_deletes[$i]);
		}
		$this->da->update($assoc_delete);
		$this->da->update($member_delete);
		$this->da->update($respon_delete);
		$this->da->update($deedlog_delete);
		
		return true;
	}
	
	/**
	 *
	 * @access public
	 */
	function deleteDeedlogDeed($member_id,$deed_id)
	{
		$sql = 'DELETE FROM '.$this->_DeedLogEntryTable.'
				WHERE
			   '.$this->_DeedLogEntryMemberID.'='.$member_id.'
				AND
			   '.$this->_DeedLogEntryDeedID.'='.$deed_id;
	
		$this->da->update($sql);
		return true;
	}
	
	/**
	 *
	 * @access public
	 */
	function deleteNote($note_id)
	{
		$sql = 'DELETE FROM '.$this->_NoteTable.'
				WHERE
				'.$this->_NoteID.'='.$note_id;
		$this->da->update($sql);
		$sql = 'DELETE FROM '.$this->_NoteMemberTable.'
				WHERE
				'.$this->_NoteMemberNoteID.'='.$note_id;
		$this->da->update($sql);
		return true;
	}
	
	/**
	 *
	 * @access public
	 */
	function setAsMainCharacter($member_id,$alias_id)
	{
		$sql = "UPDATE ".$this->_MemberTable."
				SET
				".$this->_MemberMainCharacterID."=".$alias_id."
				WHERE
				".$this->_MemberID."=".$member_id;
		$this->da->update($sql);
		return true;
	}
	
	/**
	 * Finds all member from start_index to __MAX_MEMBER_RESULTS.
	 *
	 * @param $start_index integer
	 * @access public
	 * @return array( <DBRowCollection>,<DBRowCollection>, <total count> )
	 */
	function & searchAll($start_index=0)
	{
		global $__CS;
		$__CS->EnterMethod("searchAll");
		$__CS->SendVar($start_index,"start_index");
		
		$sql_count = 'SELECT Count(*) As rowcount 
					  FROM Member,Rank 
					  WHERE Member.i_rankID=Rank.i_rankID';
		
		$sql_select = 'SELECT Member.*,Rank.vch_rankName 
					   FROM Member,Rank 
					   WHERE Member.i_rankID=Rank.i_rankID 
					   LIMIT '.$start_index.','.__MAX_MEMBER_RESULTS;
		
		$__CS->SendSQL($sql_count);
		$__CS->SendSQL($sql_select);
	 	
		// First, check that the start index doesn't exceed the total number of items in the database
		$result_arr = $this->da->query($sql_count);
		
		$count_result =& $result_arr[0];
		$count = $count_result->getValue("rowcount");
		if($start_index > $count) {
			trigger_error(__ERROR."Start index $start_index exceeds total result count in MemberModel:searchAll()" );
		}
	
		// Now, select the result collection
		$collection =& $this->da->fetchCollection($sql_select);
	
		$__CS->SendObject($collection,"collection");
		$__CS->ExitMethod("searchAll");
		return array(& $collection, $count);
	}
	

	/**
	 *
	 * @access public
	 */
	function getCharacterOptions()
	{
		$ranks 		= array();
		$races 		= array();
		$classes 	= array();
		$levels		= array();
		$pics		= array();
		
		if( $this->char_options != NULL ) {
			return $this->char_options;	
		}
		
		// Generate rank options sql
		$sb =& $this->da->getStatementBuilderInstance();
		$sb->clear();
		$sb->addSelect($this->_RankTable, array($this->_RankID,$this->_RankName));
		
		$ranksql = $sb->getSingleSelectSQL();
		// Generate race options sql
		$sb->clear();
		$sb->addSelect($this->_RaceTable, array($this->_RaceID,$this->_RaceName));
		
		$racesql = $sb->getSingleSelectSQL();
		
		// Generate class options sql
		$sb->clear();
		$sb->addSelect($this->_ClassTable, array($this->_ClassID,$this->_ClassName));
		
		$classsql = $sb->getSingleSelectSQL();
		
		// Generate male class avatar options sql
		$sb->clear();
		$sb->addSelect($this->_RaceTable, array($this->_RaceID,$this->_RaceName,$this->_RaceMalePictureID));
		$sb->addSelect($this->_ImageTable, array($this->_ImageName,$this->_ImagePath,$this->_ImageID));
		$sb->addInnerJoin($this->_RaceTable, $this->_RaceMalePictureID, "=", $this->_ImageTable, $this->_ImageID);
		
		$malepicssql = $sb->getJoinSelectSQL();
		
		// Generate female class avatar options sql
		$sb->clear();
		$sb->addSelect($this->_RaceTable, array($this->_RaceID,$this->_RaceName,$this->_RaceFemalePictureID));
		$sb->addSelect($this->_ImageTable, array($this->_ImageName,$this->_ImagePath,$this->_ImageID));
		$sb->addInnerJoin($this->_RaceTable, $this->_RaceFemalePictureID, "=", $this->_ImageTable, $this->_ImageID);
		
		$femalepicssql = $sb->getJoinSelectSQL();
		
		// Generate server options sql
		$sb->clear();
		$sb->addSelect($this->_ServerTable, array($this->_ServerID,$this->_ServerName));
		
		$server_sql = $sb->getSingleSelectSQL();
		
		
		
		// Set rank options array
		$rank_coll =& $this->da->fetchCollection($ranksql);
		$rank_iter =& $rank_coll->createIterator();
		while(!$rank_iter->isDone()) {
			$next_rank =& $rank_iter->fetch();
			$ranks[$next_rank->getValue($this->_RankID)] = $next_rank->getValue($this->_RankName);
		}
		
		// Set race options array
		$race_coll =& $this->da->fetchCollection($racesql);
		$race_iter =& $race_coll->createIterator();
		while(!$race_iter->isDone()) {
			$next_race =& $race_iter->fetch();
			$races[$next_race->getValue($this->_RaceID)] = $next_race->getValue($this->_RaceName);
		}
		
		// Set class options array
		$class_coll =& $this->da->fetchCollection($classsql);
		$class_iter =& $class_coll->createIterator();
		while(!$class_iter->isDone()) {
			$next_class =& $class_iter->fetch();
			$classes[$next_class->getValue($this->_ClassID)] = $next_class->getValue($this->_ClassName);
		}
		
		// Set level options array
		for($i=1; $i<=$this->__MAX_CHARACTER_LEVEL; $i++) {
			$levels[$i] = $i;
		}
		
		// Set character avatar options
		$fempics_coll =& $this->da->fetchCollection($femalepicssql);
		$fempics_iter =& $fempics_coll->createIterator();
		$fempics = array();
		while(!$fempics_iter->isDone()) {
			$next_pic =& $fempics_iter->fetch();
			$arr = array();
			$arr["raceid"] = $next_pic->getValue($this->_RaceID);
			$arr["picfile"] = $next_pic->getValue($this->_ImagePath).$next_pic->getValue($this->_ImageName);
			$fempics[] = $arr;
		}
		
		$malepics_coll =& $this->da->fetchCollection($malepicssql);
		$malepics_iter =& $malepics_coll->createIterator();
		$malepics = array();
		while(!$malepics_iter->isDone()) {
			$next_pic =& $malepics_iter->fetch();
			$arr = array();
			$arr["raceid"] = $next_pic->getValue($this->_RaceID);
			$arr["picfile"] = $next_pic->getValue($this->_ImagePath).$next_pic->getValue($this->_ImageName);
			$malepics[] = $arr;
		}
		
		$pics["male"] 	= $malepics;
		$pics["female"] = $fempics;
		
		// Set server options
		$server_coll =& $this->da->fetchCollection($server_sql);
		$server_iter =& $server_coll->createIterator();
		$servers = array();
		while(!$server_iter->isDone()) {
			$next_server =& $server_iter->fetch();
			$servers[$next_server->getValue($this->_ServerID)] = $next_server->getValue($this->_ServerName);
		}
		
		$this->char_options[] = $ranks;
		$this->char_options[] = $races;
		$this->char_options[] = $classes;
		$this->char_options[] = $levels;
		$this->char_options[] = $pics;
		$this->char_options[] = $servers;
		
		return $this->char_options;
	}	
		
	/**
	 *
	 * @access public
	 */
	function getMemberID()
	{
		return (int)$this->member_id;
	}
	
	/**
	 *
	 * @access public
	 */
	function setMemberID($member_id)
	{
		return $this->member_id = $member_id;
	}
	
	/**
	 *
	 * @access public
	 */
	function getMainCharacterID()
	{
		return (int)$this->main_character_id;
	}
	
	/** 
	 *
	 * @access public
	 */
	function & getMainCharacter()
	{
		return $this->main_character;
	}
	
	/**
	 * @access public
	 */
	function & getAliases()
	{
		return $this->characters;
	}
	
	/**
	 * 
	 * @access public
	 */
	function & getCharacter($alias_id)
	{
		
		
		include_once('core/members/models/Character.php');
		
		$sb =& $this->da->getStatementBuilderInstance();
		
		// Find a single member character
		$sb->clear();
		// Add selection fields
		$sb->addSelect(		$this->_CharacterTable, array("*"));
		$sb->addSelect(		$this->_RaceTable, array($this->_RaceName,$this->_RaceID,$this->_RaceFemalePictureID,$this->_RaceMalePictureID) );
		$sb->addSelect(		$this->_ClassTable, array($this->_ClassName,$this->_ClassID) );
		// Add constraints
		$sb->addConstraint( $this->_CharacterTable,$this->_CharacterID,"=",$alias_id);
		$sb->addInnerJoin(	$this->_CharacterTable,$this->_CharacterRaceID,"=",$this->_RaceTable,$this->_RaceID );
		$sb->addInnerJoin(	$this->_CharacterTable,$this->_CharacterClassID,"=",$this->_ClassTable,$this->_ClassID );
		
		$sql = $sb->getJoinSelectSQL();
		$result =& $this->da->query($sql);
		$char =& $result[0];
		
		$id 	= $char->getValue($this->_CharacterID);
		$name 	= $char->getValue($this->_CharacterName);
		$race 	= $char->getValue($this->_RaceName);
		$raceid = $char->getValue($this->_RaceID);
		$class  = $char->getValue($this->_ClassName);
		$classid= $char->getValue($this->_ClassID);
		$fem_id = $char->getValue($this->_RaceFemalePictureID);
		$mal_id = $char->getValue($this->_RaceMalePictureID);
		$sex	= $char->getValue($this->_CharacterSex);
		$level	= $char->getValue($this->_CharacterLevel);
		$thott	= $char->getValue($this->_CharacterThottbotEnabled);
			
		if( $sex == "m" ) {
			$pic_id = $mal_id;
		}
		else {
			$pic_id = $fem_id;
		}
		$sql = 'SELECT vch_imageName,vch_imagePath 
				FROM Image 
				WHERE Image.i_imageID = "'.$pic_id.'"';
			
		$result_arr = $this->da->query($sql);
		$pic =& $result_arr[0];
			
		$picfile = $pic->getValue( $this->_ImagePath ).$pic->getValue( $this->_ImageName );
		
		$character =& new Character($id,$name,$race,$raceid,$class,$classid,$picfile,'','',$sex,$level,$thott);
		return $character;
	}
	
	/**
	 * @access public
	 */
	function & getNotes()
	{
		return $this->notes;
	}
	
	/** 
	 *
	 * @access public
	 */
	function & getMemberResponsibilities()
	{
		return array(& $this->member_respons,& $this->rank_respons);
	}
	
	/** 
	 *
	 * @access public
	 */
	function & getDeeds()
	{
		return $this->deeds;
	}
	
	/**
	 * 
	 * @access public
	 */
	function getRank()
	{
		return (string)$this->rank;
	}
	
	/**
	 *
	 * @access public
	 */
	function getRankID()
	{
		return (int)$this->rank_id;
	}
	
	/**
	 *
	 * @access public
	 */
	function getLogin()
	{
		return (string)$this->login;
	}
	
	/**
	 *
	 * @access public
	 */
	function getEmail()
	{
		return (string)$this->email;
	}
}
?>