<?php
// DeedLogSequence.php






class DeedLogSequence
{
	
	var $deeds;
	var $keys;
	var $cur_deed;
	var $tot_guild_dp;
	var $tot_quest_dp;
	var $tot_pvp_dp;
	var $entry_id;
	
	function DeedLogSequence()
	{
		$this->deeds = array();
		$this->keys  = array();
		$this->cur_deed = 0;
		$this->tot_guild_dp = 0;
		$this->tot_quest_dp = 0;
		$this->tot_pvp_dp = 0;
	}
	
	function addDeed($deed_id,$num_times,$deed_name,$guild_dp,$quest_dp,$pvp_dp,$entry_id)
	{
		if(array_key_exists($deed_id, $this->deeds)) {
			$this->deeds[$deed_id]["tot_guild_dp"] += ($guild_dp * $num_times);
			$this->deeds[$deed_id]["tot_quest_dp"] += ($quest_dp * $num_times);
			$this->deeds[$deed_id]["tot_pvp_dp"]   += ($pvp_dp * $num_times);
			$this->deeds[$deed_id]["num_times"] += $num_times;
			$this->tot_guild_dp += ($guild_dp * $num_times);
			$this->tot_quest_dp += ($quest_dp * $num_times);
			$this->tot_pvp_dp 	+= ($pvp_dp * $num_times);
		}
		else {
			$this->deeds[$deed_id] = array();
			$this->deeds[$deed_id]["deed_name"] = $deed_name;
			$this->deeds[$deed_id]["guild_dp"]  = $guild_dp;
			$this->deeds[$deed_id]["quest_dp"]  = $quest_dp;
			$this->deeds[$deed_id]["pvp_dp"]    = $pvp_dp;
			$this->deeds[$deed_id]["tot_guild_dp"]  = ($guild_dp * $num_times);
			$this->deeds[$deed_id]["tot_quest_dp"]  = ($quest_dp * $num_times);
			$this->deeds[$deed_id]["tot_pvp_dp"]    = ($pvp_dp * $num_times);
			$this->deeds[$deed_id]["num_times"] = $num_times;
			$this->keys[] = $deed_id;
			$this->tot_guild_dp += ($guild_dp * $num_times);
			$this->tot_quest_dp += ($quest_dp * $num_times);
			$this->tot_pvp_dp 	+= ($pvp_dp * $num_times);
		}
	}
	
	function first()
	{
		$this->cur_deed = 0;
	}
	
	function forward()
	{
		$this->cur_deed++;
	}
	
	function pastEnd()
	{
		if($this->cur_deed < count($this->keys)) {
			return false;
		}
		else {
			return true;
		}
	}
	
	function getDeedID()
	{
		return $this->keys[$this->cur_deed];
	}
	
	function getDeedName()
	{
		return $this->deeds[$this->keys[$this->cur_deed]]["deed_name"];
	}
	
	function getNumTimes()
	{
		return $this->deeds[$this->keys[$this->cur_deed]]["num_times"];
	}
	
	function getGuildDP()
	{
		return $this->deeds[$this->keys[$this->cur_deed]]["guild_dp"];
	}
	
	function getGuildDPTotal()
	{
		return $this->deeds[$this->keys[$this->cur_deed]]["tot_guild_dp"];
	}
	
	function getQuestDP()
	{
		return $this->deeds[$this->keys[$this->cur_deed]]["quest_dp"];
	}
	
	function getQuestDPTotal()
	{
		return $this->deeds[$this->keys[$this->cur_deed]]["tot_quest_dp"];
	}
	
	function getPvpDP()
	{
		return $this->deeds[$this->keys[$this->cur_deed]]["pvp_dp"];
	}
	
	function getPvpDPTotal()
	{
		return $this->deeds[$this->keys[$this->cur_deed]]["tot_pvp_dp"];
	}
	
	function getDeedlogTotalGuildDP()
	{
		return $this->tot_guild_dp;
	}
	
	function getDeedlogTotalQuestDP()
	{
		return $this->tot_quest_dp;
	}
	
	function getDeedlogTotalPvpDP()
	{
		return $this->tot_pvp_dp;
	}
}