<?php
// AliasEditForm.php
include_once('core/base/Form.php');

/**
 * 
 *
 * @author Matthew Lindberg
 */
class AliasEditForm extends Form
{
	var $_Sex 				= "sex";
	var $_Name				= "name";
	var $_RaceID			= "raceid";
	var $_ClassID			= "classid";
	var $_Level				= "level";
	var $_EnableThottbot	= "enablethottbot";
	var $_ServerID			= "serverid";
	
	var $alias_id;
	var $is_loaded;
	
	
	/**
	 * Constructor.
	 *
	 * @access public
	 */
	function AliasEditForm(& $session, & $request)
	{
		global $__CS; 
		$__CS->EnterMethod("AliasEditForm ** Constructor");
		$__CS->SendObject($session,"session");
		$__CS->SendObject($request,"request");
		
		parent::Form(& $session, & $request);
		$this->init();
		
		$__CS->ExitMethod("AliasEditForm ** Constructor");
	}

	/**
	 * Sets all of the default values for this form.
	 *
	 * @access public
	 */
	function init()
	{
		global $__CS; 
		$__CS->EnterMethod("setDefaultValues:AliasEditForm");
		
		$this->setField($this->_Sex,				"m");
		$this->setField($this->_Name,				"");
		$this->setField($this->_RaceID,				NULL);
		$this->setField($this->_ClassID,			NULL);
		$this->setField($this->_Level,				1);
		$this->setField($this->_EnableThottbot,		0);
		$this->setField($this->_ServerID,			NULL);
		
		$this->is_loaded = false;
		
		$__CS->ExitMethod("setDefaultValues:AliasEditForm");	
	}
	
	/**
	 * Loads the form with a DeedModel.
	 *
	 * @param $model
	 * @param $alias_id integer
	 * @access public
	 */
	function loadFromModel(& $model, $alias_id)
	{
		global $__CS; 
		$__CS->EnterMethod("loadFromModel:MemberNewForm");
		$__CS->SendObject($model,"model");
		
		$alias_char =& $model->getCharacter($alias_id);
		$this->setField( $this->_Sex,				$alias_char->getSex());
		$this->setField( $this->_Name,				$alias_char->getName());
		$this->setField( $this->_RaceID,			$alias_char->getRaceID());
		$this->setField( $this->_ClassID,			$alias_char->getClassID());
		$this->setField( $this->_Level,				$alias_char->getLevel());
		$this->setField( $this->_EnableThottbot, 	$alias_char->isThottbotEnabled() );
		$this->setField( $this->_ServerID,			$alias_char->getServerID());
			
		$this->alias_id = $alias_id;
		$this->is_loaded = true;
		
		$__CS->ExitMethod("loadFromModel:MemberNewForm");
	}
	
	function getAliasID()
	{
		return $this->alias_id;
	}
	
	function isLoaded()
	{
		return $this->is_loaded;
	}
	
	function getSex()
	{
		return (string)$this->getFieldValue($this->_Sex);
	}
	
	function getName()
	{
		return (string)$this->getFieldValue($this->_Name);
	}
	
	function getRaceID()
	{
		return (int)$this->getFieldValue($this->_RaceID);
	}
	
	function getClassID()
	{
		return (int)$this->getFieldValue($this->_ClassID);
	}
	
	function getLevel()
	{
		return (int)$this->getFieldValue($this->_Level);
	}
	
	function getEnableThottbot()
	{
		return (int)$this->getFieldValue($this->_EnableThottbot);
	}
	
	function getServerID()
	{
		return (int)$this->getFieldValue($this->_ServerID);
	}
}
?>