<?php
// SearchMembers.php
include_once('core/base/Action.php');

/**
 * 
 *
 * @author Matthew Lindberg
 * @todo Make execute functon set ErrorView in controller on error instead of triggering error.
 */
class SearchMembers extends Action
{
	/**
	 * Executes the search members action.
	 *
	 * @access public
	 * @return boolean
	 */
	function execute(& $context)
	{
		global $__CS;
		$__CS->EnterMethod("execute:SearchMembers");
		
		$model  	=& $context->getEntry(__MODEL);
		$request 	=& $context->getEntry(__REQUEST);
		$timer		=& $context->getEntry(__TIMER);
		
		include_once('core/members/views/MemberSearchView.php');
		$view =& new MemberSearchView(& $timer, & $model);
		
		if($page_num = $request->get('page')) {
			$search_index = ($page_num * __MAX_MEMBER_RESULTS) - __MAX_MEMBER_RESULTS;
			list($collection,$count) = $model->searchAll($search_index);
			$view->setPageNumber($page_num);
		}
		else {
			list($collection,$count) = $model->searchAll();
			$view->setPageNumber(1);
		}
		
		$view->setNumberOfSearchResults($count);
		
		$num_pages = ceil($count / __MAX_MEMBER_RESULTS);
		if( $num_pages == 0 ) {
			$num_pages = 1;
		}
		
		$view->setTotalPages($num_pages);
		$view->setResultRows(& $collection);
		
		// Add any feedback messages, if they exist
		if($request->hasFeedback()) {
			$view->addFeedback($request->getFeedback());
		}
		$view->init();
		
		$controller =& $context->getEntry(__CONTROLLER);
		$controller->setView(& $view);
		
		$__CS->ExitMethod("execute:SearchMembers");
		return true;
	}
}
?>