<?php
// NewMember.php
include_once('core/base/Action.php');

/**
 * Opens a new member form.
 *
 * @author Matthew Lindberg
 */
class NewMember extends Action
{
	
	/**
	 * Sets view to new member form.
	 *
	 * @access public
	 * @return boolean
	 */
	function execute(& $context)
	{
		global $__CS; 
		$__CS->EnterMethod("execute");
		
		$session	=& $context->getEntry(__SESSION);
		$request	=& $context->getEntry(__REQUEST);
		$timer		=& $context->getEntry(__TIMER);
		$model		=& $context->getEntry(__MODEL);
		
		include_once('core/members/forms/MemberEditForm.php');
		$member_form =& new MemberEditForm(& $session, & $request);
		
		include_once('core/members/views/MemberNewView.php');
		
		$view =& new MemberNewView(& $timer, & $model, & $member_form);
		$view->init();
		
		$controller =& $context->getEntry(__CONTROLLER);
		$controller->setView(& $view);
		return true;
	}
	
}
?>