<?php
// NewAlias.php
include_once('core/base/Action.php');

/**
 * Opens a new alias form.
 *
 * @author Matthew Lindberg
 */
class NewAlias extends Action
{
	
	/**
	 * Sets view to new member alias form.
	 *
	 * @access public
	 * @return boolean
	 */
	function execute(& $context)
	{
		global $__CS; 
		$__CS->EnterMethod("execute");
		
		$session	=& $context->getEntry(__SESSION);
		$request	=& $context->getEntry(__REQUEST);
		$timer		=& $context->getEntry(__TIMER);
		$model		=& $context->getEntry(__MODEL);
		
		$model->setMemberID($request->get("memberid"));
		
		include_once('core/members/forms/AliasEditForm.php');
		$alias_form =& new AliasEditForm(& $session, & $request);
		
		include_once('core/members/views/AliasEditView.php');
		
		$view =& new AliasEditView(& $timer, & $model, & $alias_form);
		$view->init();
		
		$controller =& $context->getEntry(__CONTROLLER);
		$controller->setView(& $view);
		return true;
	}
	
}
?>