<?php
// EditMember.php
include_once('core/base/Action.php');

/**
 * Opens a edit member form.
 *
 * @author Matthew Lindberg
 */
class EditMember extends Action
{
	
	/**
	 * Sets view to the edit member form.
	 *
	 * @access public
	 * @return boolean
	 */
	function execute(& $context)
	{
		global $__CS; 
		$__CS->EnterMethod("execute:EditMember");
		
		$session	=& $context->getEntry(__SESSION);
		$request	=& $context->getEntry(__REQUEST);
		$timer		=& $context->getEntry(__TIMER);
		$model		=& $context->getEntry(__MODEL);
		
		include_once('core/members/forms/MemberEditForm.php');
		$member_form =& new MemberEditForm(& $session, & $request);
		include_once('core/members/forms/MemberNotesForm.php');
		$note_form =& new MemberNotesForm(& $session, & $reqest);
		
		if( !$model->loadFromID($request->get("id"))) {
			die("Problem loading model in EditMember action");
		}
		$member_form->loadFromModel(& $model);
		
		include_once('core/members/views/MemberEditView.php');
		
		$view =& new MemberEditView(& $timer, & $model, & $member_form);
		$view->setNoteForm(& $note_form);
		
		if( $request->keyExists("section") ) {
			$view->setDisplaySection($request->get("section"));
		}
		// Add any feedback messages, if they exist
		if($request->hasFeedback()) {
			$view->addFeedback($request->getFeedback());
		}
		if($request->keyExists("pageback")) {
			$view->setPageFrom($request->get("pageback"));
		}
		$view->init();
		$controller =& $context->getEntry(__CONTROLLER);
		$controller->setView(& $view);
	
		$__CS->ExitMethod("execute:EditMember");
		return true;
	}
	
}
?>