<?php
// EditDeed.php
include_once('core/base/Action.php');

/**
 * Opens a deed form loaded with an existing deed.
 * 
 * @author Matthew Lindberg
 * @todo
 */
class EditDeed extends Action
{
	/**
	 * Executes action.
	 *
	 * @access public
	 * @return boolean
	 */
	function execute(& $context)
	{
		global $__CS;
		$__CS->EnterMethod("execute");
		
		
		$model 		=& $context->getEntry(__MODEL);
		$request 	=& $context->getEntry(__REQUEST);
		$session	=& $context->getEntry(__SESSION);
		$timer		=& $context->getEntry(__TIMER);
		
		include_once('core/deeds/forms/DeedForm.php');
		$deed_form =& new DeedForm(& $session, & $request);
		
		$id = $request->get("id");
		
		if( !is_null($id) ) {
			if( $model->loadFromID($id) ) {
				$deed_form->loadFromModel(& $model);
				
				include_once('core/deeds/views/DeedEditFormView.php');
				$view =& new DeedEditFormView(& $timer, & $model, & $deed_form);
				$view->setPageFrom($request->get("pageback"));
				$view->init();
				
				$controller  =& $context->getEntry(__CONTROLLER);
				$controller->setView(& $view);
				return true;
			}
			else {
				trigger_error(__ERROR."Problem loading deed model from id in LoadDeedFormFromID:execute()");
				return false;
			}
		}
		else {
			trigger_error(__ERROR."Deed ID was not set in LoadDeedFormFromID:execute()");
			return false;
		}
		
		
		
		$__CS->ExitMethod("execute");
		return true;
	}
}
?>