<?php
// ModuleController.php
include_once('core/base/Controller.php');

/**
 *
 * @author Matthew Lindberg
 */
class ModuleController extends Controller
{
	var $model;
	
	var $view;
	
	var $context;
	
	/**
	 * Constructor.
	 *
	 * @param $data_access 			DataAccess
	 * @param $session 				Session
	 * @param $model 				Model
	 * @param $timer 				StopWatch
	 * @param $front_controller 	AppController
	 * @access public
	 */
	function ModuleController(& $data_access, & $session, & $model, & $timer, & $front_controller)
	{
		global $__CS; 
		$__CS->EnterMethod("ModuleController");
		$__CS->SendObject($data_access,"DataAccess");
		$__CS->SendObject($timer,"StopWatch");
		$__CS->SendObject($model,"Model");
		
		$this->model 			=& 	$model;
		$this->view				= 	NULL;
		parent::Controller(& $data_access, & $session, & $timer);
		
		// fill the global context object
		include_once('core/base/Context.php');
		$this->context 	=& new Context();
		$this->context->setEntry(__SESSION,			& $this->sess);
		$this->context->setEntry(__DATAACCESS, 		& $this->da);
		$this->context->setEntry(__MODEL, 			& $this->model);
		$this->context->setEntry(__TIMER,			& $this->timer);
		$this->context->setEntry(__FRONTCONTROLLER, & $front_controller);
		
		$__CS->ExitMethod("ModuleController");
	}
	
	/**
	 * Sets the context for a specific module action request.
	 *
	 * @param $request Request
	 * @param $controller ModuleController
	 */
	function setRequestContext(& $request,& $controller)
	{
		$this->context->setEntry(__REQUEST,		& $request);
		$this->context->setEntry(__CONTROLLER, 	& $controller);
	}
	
	
	/**
	 * Sets the view current used by this module.
	 *
	 * @param $view View
	 * @access public
	 */
	function setView( & $view ) 
	{
		$this->view =& $view;
	}
}
?>